/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.websocket;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.objectspy.websocket.AddonSocket;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class AddonSocketServer {
    private static AddonSocketServer instance;
    private Server server;
    private List<AddonSocket> activeSockets = new ArrayList<AddonSocket>();
    private ServerConnector firefoxConnetor;

    private AddonSocketServer() {
    }

    public static AddonSocketServer getInstance() {
        if (instance == null) {
            instance = new AddonSocketServer();
        }
        return instance;
    }

    public void start(Class<?> socketClass, int port) {
        if (this.isRunning()) {
            return;
        }
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(port);
        this.firefoxConnetor = new ServerConnector(this.server);
        this.firefoxConnetor.setPort(50001);
        this.server.addConnector((Connector)connector);
        this.server.addConnector((Connector)this.firefoxConnetor);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        try {
            ServerContainer wscontainer = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)context);
            wscontainer.addEndpoint(socketClass);
            System.out.println("port in start = " + port);
            this.server.start();
            this.server.dump((Appendable)System.err);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    public synchronized void addActiveSocket(AddonSocket socket) {
        if (socket == null) {
            return;
        }
        this.activeSockets.add(socket);
    }

    public synchronized void removeActiveSocket(AddonSocket socket) {
        if (socket == null) {
            return;
        }
        this.activeSockets.remove(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddonSocket getAddonSocketByBrowserName(String browserName) {
        if (StringUtils.isEmpty((String)browserName)) {
            return null;
        }
        List<AddonSocket> list = this.activeSockets;
        synchronized (list) {
            for (AddonSocket addonSocket : this.activeSockets) {
                if (addonSocket.getBrowserType() == null || !browserName.equals(addonSocket.getBrowserType().toString())) continue;
                return addonSocket;
            }
        }
        return null;
    }
}

