/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.util;

import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;

public class Win32Helper {
    private static final String SLACK = "Slack";
    private static final String CHROME_CLASS_NAME = "Chrome_WidgetWin_1";
    private static final String FIREFOX_CLASS_NAME = "MozillaWindowClass";

    public static void switchFocusToBrowser(WebUIDriverType browser) {
        switch (browser) {
            case CHROME_DRIVER: {
                Win32Helper.switchFocusToChrome();
                break;
            }
            default: {
                Win32Helper.switchFocusToFirefox();
            }
        }
    }

    public static void switchFocusToChrome() {
        if (Win32Helper.isOnWin32()) {
            return;
        }
        Win32Helper.switchFocusToWindow(CHROME_CLASS_NAME);
    }

    public static void switchFocusToFirefox() {
        if (Win32Helper.isOnWin32()) {
            return;
        }
        Win32Helper.switchFocusToWindow(FIREFOX_CLASS_NAME);
    }

    private static boolean isOnWin32() {
        return !Platform.getOS().equals("win32");
    }

    private static void switchFocusToWindow(String windowClassName) {
        Memory foundWindowPointer = new Memory((long)Pointer.SIZE);
        Win32Helper.isWindowOpen(windowClassName, (Pointer)foundWindowPointer);
        if (foundWindowPointer.getPointer(0L) != null) {
            Win32Helper.activateWindow(new WinDef.HWND(foundWindowPointer.getPointer(0L)));
        }
    }

    public static void main(String[] args) {
        Win32Helper.switchFocusToFirefox();
    }

    private static void activateWindow(WinDef.HWND foundWindow) {
        if (foundWindow == null) {
            return;
        }
        User32.INSTANCE.ShowWindow(foundWindow, 3);
        User32.INSTANCE.SetForegroundWindow(foundWindow);
    }

    private static void isWindowOpen(final String windowClassName, Pointer foundWindowPointer) {
        User32.INSTANCE.EnumWindows(new WinUser.WNDENUMPROC(){

            public boolean callback(WinDef.HWND hWnd, Pointer foundWindowPointer) {
                if (foundWindowPointer == null) {
                    return true;
                }
                String className = Win32Helper.getWindowClassName(hWnd);
                String title = Win32Helper.getWindowTitle(hWnd);
                if (className.contains(windowClassName) && StringUtils.isNotEmpty((String)title) && !title.equals(Win32Helper.SLACK)) {
                    foundWindowPointer.setPointer(0L, hWnd.getPointer());
                }
                return true;
            }
        }, foundWindowPointer);
    }

    private static String getWindowClassName(WinDef.HWND hWnd) {
        char[] windowText = new char[512];
        User32.INSTANCE.GetClassName(hWnd, windowText, 512);
        return Native.toString((char[])windowText);
    }

    private static String getWindowTitle(WinDef.HWND hWnd) {
        char[] windowTitle = new char[512];
        User32.INSTANCE.GetWindowText(hWnd, windowTitle, 512);
        return Native.toString((char[])windowTitle);
    }
}

