/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import com.kms.katalon.objectspy.constants.StringConstants;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebFrame;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class WebElementUtils {
    private static final String PAGE_ELEMENT_NAME_PREFIX = "Page_";
    private static final String FRAME_ELEMENT_NAME_PREFIX = "Frame_";
    private static final String WEB_ELEMENT_NAME_PREFIX = "Element_";
    private static final String ELEMENT_ATTRIBUTES_STYLE_KEY = "style";
    private static final int NAME_LENGTH_LIMIT = 220;
    public static final String PAGE_TITLE_KEY = "title";
    private static final String ELEMENT_PARENT_KEY = "parent";
    private static final String ELEMENT_PAGE_KEY = "page";
    private static final String ELEMENT_XPATHS_KEY = "xpaths";
    private static final String ELEMENT_USEFUL_NEIGHBOR_TEXT = "neighbor_text";
    private static final String ELEMENT_ATTRIBUTES_KEY = "attributes";
    private static final String ELEMENT_CONTENT_KEY = "content";
    private static final String ELEMENT_TEXT_KEY = "text";
    private static final String ELEMENT_ID_KEY = "id";
    private static final String ELEMENT_NAME_KEY = "name";
    private static final String ELEMENT_CLASS_KEY = "class";
    private static final String ELEMENT_TYPE_KEY = "type";
    private static final String ELEMENT_TAG_KEY = "tag";
    private static final String XPATH_KEY = "xpath";
    private static final String PAGE_URL_KEY = "url";
    private static final List<String> PRIORITY_PROPERTIES = Arrays.asList("id", "name", "alt", "checked", "form", "href", "placeholder", "selected", "src", "title", "type", "text", "linked_text");

    public static String generateWebElementName(String elementType, List<WebElementPropertyEntity> properties, String usefulNeighborText) {
        Map<String, String> propsMap = properties.stream().filter(p -> ELEMENT_TEXT_KEY.equals(p.getName()) || ELEMENT_NAME_KEY.equals(p.getName()) || ELEMENT_ID_KEY.equals(p.getName()) || ELEMENT_CLASS_KEY.equals(p.getName())).collect(Collectors.toMap(WebElementPropertyEntity::getName, WebElementPropertyEntity::getValue));
        String content = propsMap.get(ELEMENT_TEXT_KEY);
        if (content != null) {
            return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(content);
        }
        String name = propsMap.get(ELEMENT_NAME_KEY);
        if (name != null) {
            if ("".equals(usefulNeighborText)) {
                return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(name);
            }
            return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(usefulNeighborText) + "_" + WebElementUtils.toValidFileName(name);
        }
        String id = propsMap.get(ELEMENT_ID_KEY);
        if (id != null) {
            if ("".equals(usefulNeighborText)) {
                return String.valueOf(elementType) + WebElementUtils.toValidFileName(id);
            }
            return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(usefulNeighborText) + "_" + WebElementUtils.toValidFileName(id);
        }
        String cssClass = propsMap.get(ELEMENT_CLASS_KEY);
        if (cssClass != null) {
            if ("".equals(usefulNeighborText)) {
                return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(cssClass);
            }
            return String.valueOf(elementType) + "_" + WebElementUtils.toValidFileName(usefulNeighborText) + "_" + WebElementUtils.toValidFileName(cssClass);
        }
        return elementType;
    }

    public static String decodeURIComponent(String encodedString) throws UnsupportedEncodingException {
        return URLDecoder.decode(encodedString.replace("+", "%2B"), "UTF-8").replace("%2B", "+");
    }

    public static WebElement buildWebElement(String jsonString) throws Exception {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(WebElementUtils.decodeURIComponent(jsonString).trim());
        if (jsonElement instanceof JsonObject) {
            return WebElementUtils.buildWebElement((JsonObject)jsonElement, false);
        }
        return null;
    }

    public static WebElement buildWebElement(JsonObject elementJsonObject, boolean isFrame) throws UnsupportedEncodingException {
        if (elementJsonObject == null || !elementJsonObject.get(ELEMENT_TYPE_KEY).isJsonPrimitive()) {
            return null;
        }
        String elementType = elementJsonObject.getAsJsonPrimitive(ELEMENT_TYPE_KEY).getAsString();
        ArrayList<WebElementPropertyEntity> properties = new ArrayList<WebElementPropertyEntity>();
        properties.add(new WebElementPropertyEntity(ELEMENT_TAG_KEY, elementType));
        WebElementUtils.collectElementContents(elementJsonObject, properties);
        WebElementUtils.collectElementAttributes(elementJsonObject, properties);
        ArrayList<WebElementXpathEntity> xpaths = new ArrayList<WebElementXpathEntity>();
        WebElementUtils.collectElementXpaths(elementJsonObject, xpaths);
        String xpathString = WebElementUtils.getElementXpath(elementJsonObject);
        if (xpathString != null) {
            boolean hasPriorityProperty = properties.stream().filter(p -> PRIORITY_PROPERTIES.contains(p.getName())).findAny().isPresent();
            properties.add(new WebElementPropertyEntity(XPATH_KEY, xpathString, !hasPriorityProperty));
        }
        Map<String, Boolean> customSettings = WebElementUtils.getCapturedTestObjectAttributeLocatorSettings().stream().collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        properties.stream().filter(i -> customSettings.get(i.getName()) != null).forEach(i -> i.setIsSelected((Boolean)customSettings.get(i.getName())));
        SelectorMethod selectorMethod = WebElementUtils.getCapturedTestObjectSelectorMethod();
        final List capturedTestObjectXpaths = WebElementUtils.getCapturedTestObjectXpathLocatorSettings().stream().map(o -> (String)o.getLeft()).collect(Collectors.toList());
        Comparator<WebElementXpathEntity> comparator = new Comparator<WebElementXpathEntity>(){

            @Override
            public int compare(WebElementXpathEntity o1, WebElementXpathEntity o2) {
                int p1 = capturedTestObjectXpaths.indexOf(o1.getName());
                int p2 = capturedTestObjectXpaths.indexOf(o2.getName());
                if (p1 == -1 && p2 != -1) {
                    return 1;
                }
                if (p1 != -1 && p2 == -1) {
                    return -1;
                }
                if (p1 != p2) {
                    return p1 - p2;
                }
                return o1.getName().compareTo(o2.getName());
            }
        };
        Collections.sort(xpaths, comparator);
        Iterator it = xpaths.iterator();
        while (it.hasNext()) {
            WebElementXpathEntity xpath = (WebElementXpathEntity)it.next();
            if (capturedTestObjectXpaths.indexOf(xpath.getName()) != -1) continue;
            it.remove();
        }
        if (!xpaths.isEmpty()) {
            Optional.ofNullable((WebElementXpathEntity)xpaths.get(0)).ifPresent(a -> a.setIsSelected(Boolean.valueOf(true)));
        }
        String usefulNeighborText = WebElementUtils.getElementUsefulNeighborText(elementJsonObject);
        WebFrame parentElement = WebElementUtils.getParentElement(elementJsonObject);
        String newName = WebElementUtils.generateWebElementName(elementType, properties, usefulNeighborText);
        if (newName.length() > 220) {
            newName = newName.substring(0, 220);
        }
        WebElement el = isFrame ? new WebFrame(newName) : new WebElement(newName);
        el.setParent(parentElement);
        el.setProperties(properties);
        el.setXpaths(xpaths);
        el.setUsefulNeighborText(usefulNeighborText);
        el.setSelectorMethod(selectorMethod);
        switch (selectorMethod) {
            case XPATH: {
                if (xpaths.isEmpty()) break;
                String value = Optional.ofNullable((WebElementXpathEntity)xpaths.get(0)).orElse(new WebElementXpathEntity("", "")).getValue();
                el.setSelectorValue(selectorMethod, value);
                break;
            }
        }
        return el;
    }

    private static List<Pair<String, Boolean>> getCapturedTestObjectAttributeLocatorSettings() {
        WebUiExecutionSettingStore store = new WebUiExecutionSettingStore(ProjectController.getInstance().getCurrentProject());
        try {
            return store.getCapturedTestObjectAttributeLocators();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<Pair<String, Boolean>> getCapturedTestObjectXpathLocatorSettings() {
        WebUiExecutionSettingStore store = new WebUiExecutionSettingStore(ProjectController.getInstance().getCurrentProject());
        try {
            return store.getCapturedTestObjectXpathLocators();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private static SelectorMethod getCapturedTestObjectSelectorMethod() {
        WebUiExecutionSettingStore store = new WebUiExecutionSettingStore(ProjectController.getInstance().getCurrentProject());
        try {
            return store.getCapturedTestObjectSelectorMethod();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return SelectorMethod.BASIC;
        }
    }

    public static String toValidFileName(String fileName) {
        return fileName.trim().replaceAll("[^A-Za-z0-9_()\\- ]", "");
    }

    private static WebFrame getParentElement(JsonObject elementJsonObject) throws UnsupportedEncodingException {
        WebFrame parentElement = null;
        if (elementJsonObject.has(ELEMENT_PARENT_KEY) && elementJsonObject.get(ELEMENT_PARENT_KEY).isJsonObject()) {
            WebElement tempParentElement = WebElementUtils.buildWebElement(elementJsonObject.getAsJsonObject(ELEMENT_PARENT_KEY), true);
            if (tempParentElement instanceof WebFrame) {
                parentElement = (WebFrame)tempParentElement;
            }
        } else {
            parentElement = WebElementUtils.buildWebPageElement(elementJsonObject.getAsJsonObject(ELEMENT_PAGE_KEY));
        }
        return parentElement;
    }

    private static String getElementXpath(JsonObject elementJsonObject) {
        if (elementJsonObject.has(XPATH_KEY) && elementJsonObject.get(XPATH_KEY).isJsonPrimitive()) {
            return elementJsonObject.getAsJsonPrimitive(XPATH_KEY).getAsString();
        }
        return null;
    }

    private static void collectElementAttributes(JsonObject elementJsonObject, List<WebElementPropertyEntity> properties) {
        if (!WebElementUtils.isElementAttributesSet(elementJsonObject)) {
            return;
        }
        for (Map.Entry entry : elementJsonObject.getAsJsonObject(ELEMENT_ATTRIBUTES_KEY).entrySet()) {
            if (!WebElementUtils.isValidElementAttribute(entry)) continue;
            String propertyName = (String)entry.getKey();
            properties.add(new WebElementPropertyEntity(propertyName, ((JsonElement)entry.getValue()).getAsString(), PRIORITY_PROPERTIES.contains(propertyName)));
        }
    }

    private static String getElementUsefulNeighborText(JsonObject elementJsonObject) {
        if (elementJsonObject.has(ELEMENT_USEFUL_NEIGHBOR_TEXT) && elementJsonObject.get(ELEMENT_USEFUL_NEIGHBOR_TEXT).isJsonPrimitive()) {
            return elementJsonObject.getAsJsonPrimitive(ELEMENT_USEFUL_NEIGHBOR_TEXT).getAsString();
        }
        return "";
    }

    private static void collectElementXpaths(JsonObject elementJsonObject, List<WebElementXpathEntity> xpaths) {
        if (!WebElementUtils.isElementXpathsSet(elementJsonObject)) {
            return;
        }
        for (Map.Entry entry : elementJsonObject.getAsJsonObject(ELEMENT_XPATHS_KEY).entrySet()) {
            String xpathFinder = (String)entry.getKey();
            JsonElement xpath = (JsonElement)entry.getValue();
            if (xpath instanceof JsonObject) {
                xpaths.add(new WebElementXpathEntity(xpathFinder, ((JsonElement)entry.getValue()).getAsString(), false));
                continue;
            }
            if (!(xpath instanceof JsonArray)) continue;
            for (JsonElement jsonElement : xpath.getAsJsonArray()) {
                xpaths.add(new WebElementXpathEntity(xpathFinder, jsonElement.getAsString(), false));
            }
        }
    }

    private static boolean isElementAttributesSet(JsonObject elementJsonObject) {
        return elementJsonObject.has(ELEMENT_ATTRIBUTES_KEY) && elementJsonObject.get(ELEMENT_ATTRIBUTES_KEY).isJsonObject();
    }

    private static boolean isElementXpathsSet(JsonObject elementJsonObject) {
        return elementJsonObject.has(ELEMENT_XPATHS_KEY) && elementJsonObject.get(ELEMENT_XPATHS_KEY).isJsonObject();
    }

    private static boolean isValidElementAttribute(Map.Entry<String, JsonElement> attributeEntry) {
        return attributeEntry.getValue() != null && StringUtils.isNotBlank((String)attributeEntry.getValue().getAsString()) && !ELEMENT_ATTRIBUTES_STYLE_KEY.equals(attributeEntry.getKey());
    }

    private static void collectElementContents(JsonObject elementJsonObject, List<WebElementPropertyEntity> properties) {
        if (!WebElementUtils.isElementContent(elementJsonObject)) {
            return;
        }
        JsonArray contentArray = elementJsonObject.getAsJsonArray(ELEMENT_CONTENT_KEY);
        if (!WebElementUtils.isValidElementContent(contentArray)) {
            return;
        }
        properties.add(new WebElementPropertyEntity(ELEMENT_TEXT_KEY, contentArray.get(0).getAsString()));
    }

    private static boolean isElementContent(JsonObject elementJsonObject) {
        return elementJsonObject.has(ELEMENT_CONTENT_KEY) && elementJsonObject.get(ELEMENT_CONTENT_KEY).isJsonArray();
    }

    private static boolean isValidElementContent(JsonArray contentArray) {
        return contentArray != null && contentArray.size() == 1 && contentArray.get(0).isJsonPrimitive() && StringUtils.isNotBlank((String)contentArray.get(0).getAsString());
    }

    private static WebPage buildWebPageElement(JsonObject parentPageJsonObject) {
        if (parentPageJsonObject == null) {
            return null;
        }
        String pageUrlString = parentPageJsonObject.getAsJsonPrimitive(PAGE_URL_KEY).getAsString();
        String pageTitleString = parentPageJsonObject.getAsJsonPrimitive(PAGE_TITLE_KEY).getAsString();
        ArrayList<WebElementPropertyEntity> properties = new ArrayList<WebElementPropertyEntity>();
        properties.add(new WebElementPropertyEntity(PAGE_URL_KEY, pageUrlString, PRIORITY_PROPERTIES.contains(PAGE_URL_KEY)));
        properties.add(new WebElementPropertyEntity(PAGE_TITLE_KEY, pageTitleString, PRIORITY_PROPERTIES.contains(PAGE_TITLE_KEY)));
        WebPage webPage = new WebPage(WebElementUtils.generateWebPageName(pageTitleString));
        webPage.setProperties(properties);
        return webPage;
    }

    private static String generateWebPageName(String pageTitleString) {
        return PAGE_ELEMENT_NAME_PREFIX + StringUtils.substring((String)WebElementUtils.toValidFileName(pageTitleString), (int)0, (int)220);
    }

    public static WebElementEntity convertWebElementToTestObject(WebElement element, WebElementEntity refElement, FolderEntity parentFolder) throws Exception {
        WebElementEntity newWebElement = new WebElementEntity();
        newWebElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(parentFolder, WebElementUtils.toValidFileName(StringUtils.trim((String)element.getName()))));
        newWebElement.setParentFolder(parentFolder);
        newWebElement.setElementGuidId(Util.generateGuid());
        newWebElement.setProject(parentFolder.getProject());
        newWebElement.setWebElementProperties(new ArrayList<WebElementPropertyEntity>(element.getProperties()));
        newWebElement.setWebElementXpaths(new ArrayList<WebElementXpathEntity>(element.getXpaths()));
        newWebElement.setSelectorMethod(WebElementSelectorMethod.valueOf((String)element.getSelectorMethod().name()));
        element.getSelectorCollection().entrySet().forEach(entry -> {
            SelectorMethod selectorMethod = (SelectorMethod)entry.getKey();
            if (SelectorMethod.BASIC == selectorMethod) {
                return;
            }
            newWebElement.setSelectorValue(WebElementSelectorMethod.valueOf((String)selectorMethod.name()), (String)entry.getValue());
        });
        if (refElement == null) {
            return newWebElement;
        }
        newWebElement.getWebElementProperties().add(new WebElementPropertyEntity("ref_element", refElement.getIdForDisplay()));
        return newWebElement;
    }

    public static FolderEntity convertWebPageToFolder(WebPage page, FolderEntity parentFolder) throws Exception {
        FolderEntity newFolder = new FolderEntity();
        newFolder.setName(WebElementUtils.toValidFileName(StringUtils.trim((String)page.getName())));
        newFolder.setParentFolder(parentFolder);
        newFolder.setDescription("folder");
        newFolder.setFolderType(parentFolder.getFolderType());
        newFolder.setProject(parentFolder.getProject());
        return newFolder;
    }

    public static WebPage createWebPage() {
        return new WebPage(PAGE_ELEMENT_NAME_PREFIX + System.currentTimeMillis());
    }

    public static WebFrame createWebFrame(WebFrame parent) {
        long currentTime = System.currentTimeMillis();
        WebFrame el = new WebFrame(FRAME_ELEMENT_NAME_PREFIX + currentTime);
        el.setTag("IFRAME");
        el.setParent(parent);
        el.addProperty(XPATH_KEY, XPATH_KEY + currentTime);
        return el;
    }

    public static WebElement createWebElement(WebFrame parent) {
        long currentTime = System.currentTimeMillis();
        WebElement el = new WebElement(WEB_ELEMENT_NAME_PREFIX + currentTime);
        el.setTag("DIV");
        el.setParent(parent);
        el.addProperty(XPATH_KEY, XPATH_KEY + currentTime);
        return el;
    }

    public static String buildXpathForHTMLElement(WebElement element) {
        if (element != null && element.getParent() instanceof WebFrame) {
            if (element.getXpath().startsWith("/")) {
                return String.valueOf(WebElementUtils.buildXpathForHTMLElement(element.getParent())) + element.getXpath();
            }
            return element.getXpath();
        }
        return StringConstants.EMPTY;
    }

    public static List<WebPage> createWebElementFromFolder(FolderEntity folder, Map<String, WebElement> elementsMap) {
        if (folder == null) {
            return Collections.emptyList();
        }
        ArrayList<WebPage> pageElements = new ArrayList<WebPage>();
        WebElement mappedWebPage = elementsMap.get(folder.getId());
        if (mappedWebPage != null) {
            pageElements.add((WebPage)mappedWebPage);
            return pageElements;
        }
        WebPage pageElement = WebElementUtils.createWebPage();
        pageElement.setName(folder.getName());
        elementsMap.put(folder.getId(), pageElement);
        pageElements.add(pageElement);
        try {
            for (FileEntity entity : FolderController.getInstance().getChildren(folder)) {
                if (entity instanceof WebElementEntity) {
                    WebElementUtils.createWebElementFromTestObject((WebElementEntity)entity, false, pageElement, elementsMap);
                    continue;
                }
                if (!(entity instanceof FolderEntity)) continue;
                List<WebPage> childPageElements = WebElementUtils.createWebElementFromFolder((FolderEntity)entity, elementsMap);
                pageElements.addAll(childPageElements);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return pageElements;
    }

    public static WebElement createWebElementFromTestObject(WebElementEntity webElementEntity, boolean isFrame, WebPage pageElement, Map<String, WebElement> elementsMap) {
        if (webElementEntity == null) {
            return null;
        }
        String entityId = webElementEntity.getId();
        WebElement mappedWebElement = elementsMap.get(entityId);
        if (mappedWebElement != null) {
            if (isFrame && !(mappedWebElement instanceof WebFrame)) {
                elementsMap.remove(entityId);
                WebFrame parentElementOfFrame = mappedWebElement.getParent();
                parentElementOfFrame.getChildren().remove(mappedWebElement);
                WebFrame replacedElement = new WebFrame(mappedWebElement.getName());
                replacedElement.setParent(parentElementOfFrame);
                if (mappedWebElement.hasProperty()) {
                    replacedElement.setProperties(mappedWebElement.getProperties());
                }
                if (mappedWebElement.hasXpath()) {
                    replacedElement.setXpaths(mappedWebElement.getXpaths());
                }
                elementsMap.put(entityId, replacedElement);
                return replacedElement;
            }
            return mappedWebElement;
        }
        WebFrame parentFrameElement = null;
        Optional<WebElementPropertyEntity> refElement = webElementEntity.getWebElementProperties().stream().filter(p -> "ref_element".equals(p.getName())).findFirst();
        if (refElement.isPresent()) {
            try {
                parentFrameElement = (WebFrame)WebElementUtils.createWebElementFromTestObject(ObjectRepositoryController.getInstance().getWebElementByDisplayPk(refElement.get().getValue()), true, pageElement, elementsMap);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        String entityName = webElementEntity.getName();
        WebElement element = isFrame ? new WebFrame(entityName) : new WebElement(entityName);
        element.setParent(parentFrameElement != null ? parentFrameElement : pageElement);
        element.setProperties(webElementEntity.getWebElementProperties());
        element.setXpaths(webElementEntity.getWebElementXpaths());
        element.setSelectorMethod(SelectorMethod.valueOf((String)webElementEntity.getSelectorMethod().name()));
        webElementEntity.getSelectorCollection().entrySet().forEach(entry -> {
            WebElementSelectorMethod selectorMethod = (WebElementSelectorMethod)entry.getKey();
            if (WebElementSelectorMethod.BASIC == selectorMethod) {
                return;
            }
            element.setSelectorValue(SelectorMethod.valueOf((String)selectorMethod.name()), (String)entry.getValue());
        });
        element.setSelectorMethod(SelectorMethod.valueOf((String)webElementEntity.getSelectorMethod().name()));
        webElementEntity.getSelectorCollection().entrySet().forEach(entry -> {
            WebElementSelectorMethod selectorMethod = (WebElementSelectorMethod)entry.getKey();
            if (WebElementSelectorMethod.BASIC == selectorMethod) {
                return;
            }
            element.setSelectorValue(SelectorMethod.valueOf((String)selectorMethod.name()), (String)entry.getValue());
        });
        element.setSelectorMethod(SelectorMethod.valueOf((String)webElementEntity.getSelectorMethod().name()));
        webElementEntity.getSelectorCollection().entrySet().forEach(entry -> {
            WebElementSelectorMethod selectorMethod = (WebElementSelectorMethod)entry.getKey();
            if (WebElementSelectorMethod.BASIC == selectorMethod) {
                return;
            }
            element.setSelectorValue(SelectorMethod.valueOf((String)selectorMethod.name()), (String)entry.getValue());
        });
        element.setSelectorMethod(SelectorMethod.valueOf((String)webElementEntity.getSelectorMethod().name()));
        webElementEntity.getSelectorCollection().entrySet().forEach(entry -> {
            WebElementSelectorMethod selectorMethod = (WebElementSelectorMethod)entry.getKey();
            if (WebElementSelectorMethod.BASIC == selectorMethod) {
                return;
            }
            element.setSelectorValue(SelectorMethod.valueOf((String)selectorMethod.name()), (String)entry.getValue());
        });
        elementsMap.put(entityId, element);
        return element;
    }

    public static TestObject buildTestObject(WebElement webElement) {
        TestObject testObject = new TestObject(webElement.getScriptId());
        WebFrame parentFrame = webElement.getParent();
        if (parentFrame != null && !(parentFrame instanceof WebPage)) {
            TestObject parent = WebElementUtils.buildTestObject(parentFrame);
            testObject.setParentObject(parent);
        }
        webElement.getProperties().forEach(prop -> testObject.addProperty(prop.getName(), ConditionType.fromValue((String)prop.getMatchCondition()), prop.getValue(), prop.getIsSelected().booleanValue()));
        webElement.getXpaths().forEach(xpath -> testObject.addXpath(xpath.getName(), ConditionType.fromValue((String)xpath.getMatchCondition()), xpath.getValue(), xpath.getIsSelected().booleanValue()));
        testObject.setSelectorMethod(webElement.getSelectorMethod());
        webElement.getSelectorCollection().entrySet().forEach(entry -> testObject.setSelectorValue((SelectorMethod)entry.getKey(), (String)entry.getValue()));
        return testObject;
    }
}

