/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.util;

import com.kms.katalon.objectspy.constants.StringConstants;
import com.kms.katalon.objectspy.element.DomElementXpath;
import com.kms.katalon.objectspy.element.HTMLElement;
import com.kms.katalon.objectspy.exception.DOMException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtils {
    private static int getIndexForNode(Node parentNode, Node node) {
        if (parentNode == null || node == null) {
            return -1;
        }
        int count = 0;
        int i = 0;
        while (i < parentNode.getChildNodes().getLength()) {
            Node htmlNode = parentNode.getChildNodes().item(i);
            if (htmlNode instanceof Element) {
                if (htmlNode.equals(node)) {
                    return count;
                }
                ++count;
            }
            ++i;
        }
        return -1;
    }

    public static String getXpathForNode(Node node) {
        if (node != null && node instanceof Element) {
            return String.valueOf(node.getParentNode() != null ? String.valueOf(DOMUtils.getXpathForNode(node.getParentNode())) + "/" : "") + node.getNodeName() + (node.getParentNode() != null ? "[" + (DOMUtils.getIndexForNode(node.getParentNode(), node) + 1) + "]" : "");
        }
        return "";
    }

    public static DomElementXpath getDOMElementXpathForNode(Node node) {
        if (node != null && node instanceof Element) {
            DomElementXpath parentDomElementXpath = DOMUtils.getDOMElementXpathForNode(node.getParentNode());
            String xpath = String.valueOf(parentDomElementXpath != null ? parentDomElementXpath.getXpath() : "") + "/" + node.getNodeName() + (node.getParentNode() != null ? "[" + (DOMUtils.getIndexForNode(node.getParentNode(), node) + 1) + "]" : "");
            String[] xpathTreePaths = null;
            if (parentDomElementXpath != null) {
                String[] parentXpathTreePaths = parentDomElementXpath.getXpathTreePath();
                xpathTreePaths = new String[parentXpathTreePaths.length + 1];
                int i = 0;
                i = 0;
                while (i < parentXpathTreePaths.length) {
                    xpathTreePaths[i] = parentXpathTreePaths[i];
                    ++i;
                }
                xpathTreePaths[i] = parentDomElementXpath.getXpath();
            } else {
                xpathTreePaths = new String[]{};
            }
            DomElementXpath domElementXpath = new DomElementXpath(node, xpath, xpathTreePaths);
            return domElementXpath;
        }
        return null;
    }

    public static void compareNodeAttributes(HTMLElement expectedElement, Element actualElement) throws DOMException {
        Map<String, String> expectedAttrs = expectedElement.getAttributes();
        if (expectedAttrs.entrySet().size() - 1 != actualElement.getAttributes().getLength()) {
            throw new DOMException(StringConstants.UTIL_EXC_ATTR_NUMBER_DOES_NOT_MATCH);
        }
        int i = 0;
        while (i < actualElement.getAttributes().getLength()) {
            Attr expectedAttr = (Attr)actualElement.getAttributes().item(i);
            if (!expectedAttr.getName().startsWith("xmlns")) {
                String actualAttr = expectedAttrs.get(expectedAttr.getName());
                if (actualAttr == null) {
                    throw new DOMException(MessageFormat.format(StringConstants.UTIL_EXC_ELEM_ATTR_NOT_FOUND, expectedAttr.getName()));
                }
                if (!expectedAttr.getValue().equals(actualAttr)) {
                    throw new DOMException(MessageFormat.format(StringConstants.UTIL_EXC_ATTR_VAL_DOES_NOT_MATCH, expectedAttr.getName(), expectedAttr.getValue(), actualAttr));
                }
            }
            ++i;
        }
    }

    public static String[] getXpathTreePath(String xpath) {
        ArrayList<String> paths = new ArrayList<String>();
        while (xpath.lastIndexOf("/") != -1) {
            paths.add(0, xpath);
            xpath = xpath.substring(0, xpath.lastIndexOf("/"));
        }
        return paths.toArray(new String[paths.size()]);
    }
}

