/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.element.tree;

import com.kms.katalon.core.webui.constants.HTMLTags;
import com.kms.katalon.objectspy.constants.ImageConstants;
import com.kms.katalon.objectspy.constants.StringConstants;
import com.kms.katalon.objectspy.element.WebElement;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class WebElementLabelProvider
extends CellLabelProvider {
    public void update(ViewerCell cell) {
        String name = StringConstants.EMPTY;
        if (cell.getElement() != null && cell.getElement() instanceof WebElement) {
            name = ((WebElement)cell.getElement()).getName();
        }
        cell.setText(name);
        cell.setImage(this.getImage(cell.getElement()));
    }

    public Image getImage(Object element) {
        if (!(element instanceof WebElement)) {
            return null;
        }
        WebElement htmlElement = (WebElement)element;
        switch (htmlElement.getType()) {
            case PAGE: {
                return ImageConstants.IMG_16_PAGE_OBJECT;
            }
            case FRAME: {
                return ImageConstants.IMG_16_FRAME_OBJECT;
            }
        }
        switch (HTMLTags.getElementType((String)htmlElement.getTag(), (String)htmlElement.getTypeProperty())) {
            case "a": {
                return ImageConstants.IMG_16_LNK_TEST_OBJECT;
            }
            case "button": 
            case "submit": 
            case "reset": {
                return ImageConstants.IMG_16_BTN_TEST_OBJECT;
            }
            case "checkbox": {
                return ImageConstants.IMG_16_CHK_TEST_OBJECT;
            }
            case "file": {
                return ImageConstants.IMG_16_FILE_TEST_OBJECT;
            }
            case "img": 
            case "image": {
                return ImageConstants.IMG_16_IMG_TEST_OBJECT;
            }
            case "select": {
                return ImageConstants.IMG_16_CBX_TEST_OBJECT;
            }
            case "label": {
                return ImageConstants.IMG_16_LBL_TEST_OBJECT;
            }
            case "textarea": 
            case "text": {
                return ImageConstants.IMG_16_TXT_TEST_OBJECT;
            }
            case "radio": {
                return ImageConstants.IMG_16_RBT_TEST_OBJECT;
            }
        }
        return ImageConstants.IMG_16_TEST_OBJECT;
    }
}

