/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.element.tree;

import com.kms.katalon.objectspy.constants.StringConstants;
import com.kms.katalon.objectspy.element.HTMLPageElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class CheckboxTreeSelectionHelper {
    private CheckboxTreeViewer viewer;
    private ITreeContentProvider contentProvider;

    private CheckboxTreeSelectionHelper(CheckboxTreeViewer viewer, ITreeContentProvider contentProvider) {
        this.viewer = viewer;
        if (contentProvider == null) {
            throw new IllegalArgumentException(StringConstants.TREE_ERROR_MSG_CONTENT_PROVIDER_IS_REQUIRED);
        }
        this.contentProvider = contentProvider;
        this.init();
    }

    private void init() {
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object node = event.getElement();
                if (CheckboxTreeSelectionHelper.this.viewer.getGrayed(node)) {
                    CheckboxTreeSelectionHelper.this.viewer.setGrayChecked(node, false);
                }
                List<Object> checkedElements = CheckboxTreeSelectionHelper.this.getCheckedElements();
                CheckboxTreeSelectionHelper.this.updateTree(node, checkedElements, event.getChecked());
            }
        });
        if (this.viewer.getContentProvider() != this.contentProvider) {
            this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        }
    }

    public static CheckboxTreeSelectionHelper attach(CheckboxTreeViewer viewer, ITreeContentProvider contentProvider) {
        return new CheckboxTreeSelectionHelper(viewer, contentProvider);
    }

    private void updateTree(Object node, List<Object> checkedElements, boolean checked) {
        List<Object> descendants = this.getDescendants(node);
        HashSet<Object> checkedSet = new HashSet<Object>(checkedElements);
        for (Object n : descendants) {
            this.viewer.setGrayChecked(n, false);
            this.viewer.setChecked(n, checked);
            if (checked) {
                checkedSet.add(n);
                continue;
            }
            checkedSet.remove(n);
        }
        this.updateAncestors(node, checkedSet);
    }

    private void updateAncestors(Object child, Set<Object> checkedElements) {
        boolean isGreyed;
        Object parent = this.contentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean bl = isGreyed = this.viewer.getChecked(child) && this.viewer.getGrayed(child);
        if (isGreyed) {
            this.viewer.setGrayChecked(parent, true);
        } else {
            Object[] children = this.contentProvider.getChildren(parent);
            ArrayList<Object> cloned = new ArrayList<Object>();
            cloned.addAll(Arrays.asList(children));
            cloned.removeAll(checkedElements);
            if (cloned.isEmpty()) {
                this.viewer.setGrayed(parent, false);
                this.viewer.setChecked(parent, true);
                checkedElements.add(parent);
            } else {
                if (this.viewer.getChecked(parent) && !this.viewer.getGrayed(parent)) {
                    checkedElements.remove(parent);
                }
                this.viewer.setGrayChecked(parent, false);
                if (cloned.size() < children.length) {
                    this.viewer.setGrayChecked(parent, true);
                }
            }
        }
        this.updateAncestors(parent, checkedElements);
    }

    private List<Object> getDescendants(Object node) {
        ArrayList<Object> desc = new ArrayList<Object>();
        this.getDescendantsHelper(desc, node);
        return desc;
    }

    private void getDescendantsHelper(List<Object> descendants, Object node) {
        Object[] children = this.contentProvider.getChildren(node);
        if (children == null || children.length == 0) {
            return;
        }
        descendants.addAll(Arrays.asList(children));
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.getDescendantsHelper(descendants, child);
            ++n2;
        }
    }

    public List<Object> getCheckedElements() {
        ArrayList<Object> checkedElements = new ArrayList<Object>(Arrays.asList(this.viewer.getCheckedElements()));
        checkedElements.removeAll(this.getGrayedElements());
        return checkedElements;
    }

    public List<Object> getGrayedElements() {
        return Arrays.asList(this.viewer.getGrayedElements());
    }

    public void setCheckAllItems(boolean checked) {
        Object input = this.viewer.getInput();
        if (input == null) {
            return;
        }
        List inputList = null;
        if (input != null && input.getClass().isArray()) {
            inputList = Arrays.asList((Object[])input);
        } else if (input != null && input instanceof List) {
            inputList = (List)input;
        } else {
            return;
        }
        for (Object item : inputList) {
            this.setCheckItem(item, checked);
        }
    }

    public void setCheckItem(Object item, boolean checked) {
        this.viewer.setChecked(item, checked);
        List<Object> descendants = this.getDescendants(item);
        for (Object node : descendants) {
            this.viewer.setChecked(node, checked);
        }
    }

    public void checkAllItemInTree(List<HTMLPageElement> elements) {
        for (HTMLPageElement element : elements) {
            this.viewer.setChecked((Object)element, true);
            List<Object> descendants = this.getDescendants(element);
            for (Object node : descendants) {
                this.viewer.setChecked(node, true);
            }
        }
    }
}

