/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.element;

import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.objectspy.element.WebFrame;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.XPathProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class WebElement
implements XPathProvider {
    private static final String AND_OPERATOR = " and ";
    private static final String XPATH_METHOD = "xpath";
    private static final String TEXT_METHOD = "text";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_TAG = "tag";
    private static final String XPATH_FIND_BY_ATTRIBUTE = "@{0}=''{1}''";
    private static final String XPATH_FIND_BY_TEXT = "text()=''{0}''";
    private static final String XPATH_EXPRESSION = "//{0}[{1}]";
    private String name;
    private WebElementType type = WebElementType.ELEMENT;
    private String usefulNeighborText = "";
    private WebFrame parent;
    private List<WebElementPropertyEntity> properties = new ArrayList<WebElementPropertyEntity>();
    private List<WebElementXpathEntity> xpaths = new ArrayList<WebElementXpathEntity>();
    private SelectorMethod selectorMethod = SelectorMethod.XPATH;
    private Map<SelectorMethod, String> selectorCollection = new HashMap<SelectorMethod, String>();
    private FileEntity savedEntity;

    public WebElement(String name) {
        this.name = name;
    }

    protected WebElement(String name, WebElementType type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebElementType getType() {
        return this.type;
    }

    public void setUsefulNeighborText(String text) {
        this.usefulNeighborText = text;
    }

    public String getUsefulNeighborText() {
        return this.usefulNeighborText;
    }

    public String getTag() {
        WebElementPropertyEntity tagProperty = this.getProperty(PROPERTY_TAG);
        if (tagProperty == null) {
            return null;
        }
        return tagProperty.getValue();
    }

    public void setTag(String tag) {
        WebElementPropertyEntity tagProperty = this.getProperty(PROPERTY_TAG);
        if (tagProperty == null) {
            this.addProperty(PROPERTY_TAG, tag);
            return;
        }
        tagProperty.setValue(tag);
    }

    @Override
    public WebFrame getParent() {
        return this.parent;
    }

    public void setParent(WebFrame parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void setParentOnly(WebFrame parent) {
        this.parent = parent;
    }

    public List<WebElementPropertyEntity> getProperties() {
        return this.properties;
    }

    public void setProperties(List<WebElementPropertyEntity> properties) {
        this.properties = properties;
    }

    public void addProperty(WebElementPropertyEntity property) {
        this.properties.add(property);
    }

    public void addProperty(String name, String value) {
        this.addProperty(new WebElementPropertyEntity(name, value));
    }

    public WebElementPropertyEntity getProperty(String name) {
        Optional<WebElementPropertyEntity> property = this.properties.stream().filter(prop -> prop.getName().equals(name)).findFirst();
        if (property.isPresent()) {
            return property.get();
        }
        return null;
    }

    public String getTypeProperty() {
        WebElementPropertyEntity typeProperty = this.getProperty(PROPERTY_TYPE);
        return typeProperty == null ? null : typeProperty.getValue();
    }

    public boolean hasProperty() {
        return this.properties != null && this.properties.size() > 0;
    }

    public List<WebElementXpathEntity> getXpaths() {
        return this.xpaths;
    }

    public void setXpaths(List<WebElementXpathEntity> xpaths) {
        this.xpaths = xpaths;
    }

    public void addXpath(WebElementXpathEntity xpath) {
        this.xpaths.add(xpath);
    }

    public void addXpath(String name, String value) {
        this.addXpath(new WebElementXpathEntity(name, value));
    }

    public WebElementXpathEntity getXpath(String name) {
        Optional<WebElementXpathEntity> property = this.xpaths.stream().filter(prop -> prop.getName().equals(name)).findFirst();
        if (property.isPresent()) {
            return property.get();
        }
        return null;
    }

    public boolean hasXpath() {
        return this.xpaths != null && this.xpaths.size() > 0;
    }

    public boolean hasChild() {
        return false;
    }

    @Override
    public String getXpath() {
        StringBuilder xpathBuilder = new StringBuilder();
        for (WebElementPropertyEntity p : this.properties) {
            String name;
            if (!p.getIsSelected().booleanValue()) continue;
            String value = p.getValue();
            switch (name = p.getName()) {
                case "xpath": {
                    return value;
                }
                case "text": {
                    this.appendAndOperator(xpathBuilder);
                    xpathBuilder.append(MessageFormat.format(XPATH_FIND_BY_TEXT, value));
                    break;
                }
                default: {
                    this.appendAndOperator(xpathBuilder);
                    xpathBuilder.append(MessageFormat.format(XPATH_FIND_BY_ATTRIBUTE, name, value));
                }
            }
        }
        return MessageFormat.format(XPATH_EXPRESSION, StringUtils.defaultIfEmpty((String)this.getTag(), (String)"*"), xpathBuilder.toString());
    }

    private void appendAndOperator(StringBuilder xpathBuilder) {
        if (StringUtils.isNotEmpty((String)xpathBuilder.toString())) {
            xpathBuilder.append(AND_OPERATOR);
        }
    }

    public WebElement softClone() {
        WebElement clone = new WebElement(this.getName(), this.getType());
        clone.setSelectorMethod(this.getSelectorMethod());
        this.getSelectorCollection().entrySet().forEach(entry -> clone.setSelectorValue((SelectorMethod)entry.getKey(), (String)entry.getValue()));
        clone.setProperties(new ArrayList<WebElementPropertyEntity>(this.getProperties()));
        clone.setXpaths(new ArrayList<WebElementXpathEntity>(this.getXpaths()));
        return clone;
    }

    public WebElement clone() {
        WebElement clone = this.softClone();
        ArrayList<WebElementPropertyEntity> cloneProperties = new ArrayList<WebElementPropertyEntity>();
        ArrayList<WebElementXpathEntity> cloneXpaths = new ArrayList<WebElementXpathEntity>();
        for (WebElementPropertyEntity webElementPropertyEntity : this.getProperties()) {
            cloneProperties.add(webElementPropertyEntity.clone());
        }
        for (WebElementXpathEntity webElementXpathEntity : this.getXpaths()) {
            cloneXpaths.add(webElementXpathEntity.clone());
        }
        clone.setProperties(cloneProperties);
        clone.setUsefulNeighborText(this.getUsefulNeighborText());
        clone.setXpaths(cloneXpaths);
        return clone;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append((Object)this.getType()).append((Object)this.getTag()).append((Object)this.getParent()).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof WebElement)) {
            return false;
        }
        WebElement that = (WebElement)object;
        return new EqualsBuilder().append((Object)this.getName(), (Object)that.getName()).append((Object)this.getType(), (Object)that.getType()).append((Object)this.getTag(), (Object)that.getTag()).append((Object)this.getParent(), (Object)that.getParent()).append(this.hasChild(), that.hasChild()).append(this.hasProperty(), that.hasProperty()).isEquals();
    }

    public boolean isSameProperties(WebElement that) {
        if (!(that instanceof WebElement)) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getName(), (Object)that.getName()).append((Object)this.getType(), (Object)that.getType()).append((Object)this.getTag(), (Object)that.getTag()).append(this.hasProperty(), that.hasProperty()).isEquals();
    }

    public SelectorMethod getSelectorMethod() {
        return this.selectorMethod;
    }

    public void setSelectorMethod(SelectorMethod selectorMethod) {
        this.selectorMethod = selectorMethod;
    }

    public void setSelectorValue(SelectorMethod selectorMethod, String selectorValue) {
        this.selectorCollection.put(selectorMethod, selectorValue);
    }

    public Map<SelectorMethod, String> getSelectorCollection() {
        return this.selectorCollection;
    }

    public WebPage getRoot() {
        if (this instanceof WebPage) {
            return (WebPage)this;
        }
        return this.getParent().getRoot();
    }

    public String getScriptId() {
        WebPage root = this.getRoot();
        if (root == this) {
            return "Object Repository/" + this.getName();
        }
        return this.savedEntity != null ? this.savedEntity.getIdForDisplay() : String.valueOf(root.getScriptId()) + "/" + this.getName();
    }

    public FileEntity getSavedEntity() {
        return this.savedEntity;
    }

    public void setSavedEntity(FileEntity savedEntity) {
        this.savedEntity = savedEntity;
    }

    public static enum WebElementType {
        ELEMENT,
        FRAME,
        PAGE;

    }
}

