/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.impl.control.Dropdown;
import com.kms.katalon.composer.components.impl.control.DropdownGroup;
import com.kms.katalon.composer.components.impl.control.DropdownItemSelectionListener;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.CustomRunConfigurationContributor;
import com.kms.katalon.execution.webui.util.WebUIExecutionUtil;
import com.kms.katalon.objectspy.constants.ImageConstants;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import com.kms.katalon.objectspy.constants.StringConstants;
import com.kms.katalon.objectspy.core.HTMLElementCaptureServer;
import com.kms.katalon.objectspy.core.HTMLElementCollector;
import com.kms.katalon.objectspy.core.InspectSession;
import com.kms.katalon.objectspy.dialog.GoToAddonStoreMessageDialog;
import com.kms.katalon.objectspy.dialog.ObjectSpyEvent;
import com.kms.katalon.objectspy.exception.IEAddonNotInstalledException;
import com.kms.katalon.objectspy.util.BrowserUtil;
import com.kms.katalon.objectspy.util.UtilitiesAddonUtil;
import com.kms.katalon.objectspy.util.Win32Helper;
import com.kms.katalon.objectspy.util.WinRegistry;
import com.kms.katalon.objectspy.websocket.AddonSocket;
import com.kms.katalon.objectspy.websocket.AddonSocketServer;
import com.kms.katalon.objectspy.websocket.messages.StartInspectAddonMessage;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.listener.EventListener;
import com.kms.katalon.util.listener.EventManager;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.openqa.selenium.WebDriver;
import org.osgi.framework.Bundle;

public class ObjectSpyUrlView
implements EventManager<ObjectSpyEvent> {
    private static final String IE_WINDOW_CLASS = "IEFrame";
    private static final String RELATIVE_PATH_TO_IE_ADDON_SETUP = String.valueOf(File.separator) + "extensions" + File.separator + "IE" + File.separator + "Object Spy" + File.separator + "setup.exe";
    private static final String RESOURCES_FOLDER_NAME = "resources";
    private static final String IE_ADDON_BHO_KEY = "{8CB0FB3A-8EFA-4F94-B605-F3427688F8C7}";
    public static final String IE_WINDOWS_32BIT_BHO_REGISTRY_KEY = "SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\explorer\\Browser Helper Objects";
    public static final String IE_WINDOWS_BHO_REGISTRY_KEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\explorer\\Browser Helper Objects";
    public static final String OBJECT_SPY_CHROME_ADDON_URL = "https://chrome.google.com/webstore/detail/katalon-utilities/ljdobmomdgdljniojadhoplhkpialdid";
    public static final String OBJECT_SPY_FIREFOX_ADDON_URL = "https://addons.mozilla.org/en-US/firefox/addon/katalon-automation-record";
    private Text txtStartUrl;
    private ToolItem startBrowser;
    private IDriverConnector selectedBrowser;
    private boolean isInstant = false;
    private Shell shell;
    private HTMLElementCaptureServer server;
    private InspectSession session;
    private AddonSocket currentInstantSocket;
    private HTMLElementCollector elementCollector;
    private Map<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>> eventListeners = new HashMap<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>>();

    public ObjectSpyUrlView(HTMLElementCollector parent) {
        this.elementCollector = parent;
        this.selectedBrowser = this.getDefaultBrowser();
        this.isInstant = this.getBrowserActiveFlag();
    }

    public void addStartBrowserToolbar(Composite parentComposite) {
        this.shell = parentComposite.getShell();
        Composite toolbarRightSideComposite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        toolbarRightSideComposite.setLayout((Layout)layout);
        toolbarRightSideComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblStartUrl = new Label(toolbarRightSideComposite, 0);
        lblStartUrl.setText(ObjectspyMessageConstants.LBL_DLG_START_URL);
        this.txtStartUrl = new Text(toolbarRightSideComposite, 2048);
        GridData gdTxtStartUrl = new GridData(4, 0x1000000, true, false);
        gdTxtStartUrl.widthHint = 100;
        this.txtStartUrl.setLayoutData((Object)gdTxtStartUrl);
        this.txtStartUrl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    ObjectSpyUrlView.this.spy();
                }
            }
        });
        this.txtStartUrl.setText(this.getPreferenceStore().getString("objectspy.defaultStartingURL"));
        ToolBar startBrowserToolbar = new ToolBar(toolbarRightSideComposite, 0x820000);
        startBrowserToolbar.setLayout((Layout)new FillLayout(256));
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)startBrowserToolbar);
        this.startBrowser = new ToolItem(startBrowserToolbar, 4);
        this.startBrowser.setText(this.getBrowserToolItemName());
        this.startBrowser.setImage(this.getWebUIDriverToolItemImage(this.getSelectedBrowserType()));
        Dropdown dropdown = new Dropdown(this.shell);
        this.createDropdownContent(dropdown);
        this.startBrowser.addSelectionListener((SelectionListener)new DropdownItemSelectionListener(dropdown){

            public void itemSelected(SelectionEvent event) {
                ObjectSpyUrlView.this.spy();
            }
        });
        this.txtStartUrl.setFocus();
        this.txtStartUrl.selectAll();
    }

    private void spy() {
        if (this.isInstant) {
            this.spyInActiveBrowser();
        } else {
            this.spyInNewBrowser();
        }
    }

    private void startObjectSpy() {
        WebUIDriverType browserType = this.getSelectedBrowserType();
        if (!BrowserUtil.isBrowserInstalled(browserType)) {
            MessageDialog.openError((Shell)this.shell, (String)StringConstants.ERROR_TITLE, (String)ObjectspyMessageConstants.DIA_MSG_CANNOT_START_BROWSER);
            return;
        }
        try {
            if (browserType == WebUIDriverType.IE_DRIVER) {
                this.checkIEAddon();
            }
            this.changeBrowserToolItemName();
            if (this.isInstant) {
                this.startInstantSession();
                return;
            }
            this.startServerWithPort(0);
            this.startInspectSession();
            this.invoke((Object)ObjectSpyEvent.SELENIUM_SESSION_STARTED, this.session);
            Trackings.trackSpy((String)"web");
        }
        catch (IEAddonNotInstalledException iEAddonNotInstalledException) {
            this.stop();
            this.showMessageForMissingIEAddon();
            try {
                this.shell.setMinimized(true);
                this.runIEAddonInstaller();
            }
            catch (IOException iOException) {
                LoggerSingleton.logError((Throwable)iOException);
            }
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            MessageDialog.openError((Shell)this.shell, (String)StringConstants.ERROR_TITLE, (String)ex.getMessage());
        }
    }

    private void changeBrowser(WebUIDriverType browserType, boolean isInstant) {
        try {
            IDriverConnector driverConnector = WebUIExecutionUtil.getBrowserDriverConnector((WebUIDriverType)browserType, (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
            this.changeBrowser(driverConnector, isInstant);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void changeBrowser(IDriverConnector driverConnector, boolean isInstant) {
        this.selectedBrowser = driverConnector;
        this.isInstant = isInstant;
        this.startBrowser.setImage(this.getWebUIDriverToolItemImage((WebUIDriverType)driverConnector.getDriverType()));
    }

    private void startBrowser() {
        this.startObjectSpy();
    }

    public void startServerWithPort(int port) throws Exception {
        this.closeInstantSession();
        if (this.server != null && this.server.isStarted() && this.isCurrentServerPortUsable(port)) {
            return;
        }
        if (this.server != null && this.server.isRunning()) {
            this.server.stop();
        }
        try {
            this.server = new HTMLElementCaptureServer(port, this.elementCollector, AddonSocket.class);
            this.server.start();
        }
        catch (BindException bindException) {
            MessageDialog.openError((Shell)this.shell, (String)StringConstants.ERROR_TITLE, (String)MessageFormat.format(ObjectspyMessageConstants.ERR_DLG_OBJECT_SPY_PORT_IN_USE, port));
            this.server = null;
        }
    }

    public boolean isCurrentServerPortUsable(int port) {
        return port == 0 || port == this.server.getServerPort();
    }

    private void changeBrowserToolItemName() {
        String string = this.getBrowserToolItemName();
        this.changeBrowserName(string);
    }

    private String getBrowserToolItemName() {
        String string = StringConstants.DIA_BTN_START_BROWSER;
        if (this.isInstant) {
            string = StringConstants.ACTIVE_BROWSER_PREFIX;
        }
        return string;
    }

    private void changeBrowserName(final String string) {
        UISynchronizeService.getInstance().getSync().asyncExec(new Runnable(){

            @Override
            public void run() {
                ObjectSpyUrlView.this.startBrowser.setText(string);
                ObjectSpyUrlView.this.startBrowser.getParent().getParent().layout(true, true);
            }
        });
    }

    private void checkIEAddon() throws IllegalAccessException, InvocationTargetException, IEAddonNotInstalledException {
        if (this.checkRegistryKey(IE_WINDOWS_32BIT_BHO_REGISTRY_KEY) || this.checkRegistryKey(IE_WINDOWS_BHO_REGISTRY_KEY)) {
            return;
        }
        throw new IEAddonNotInstalledException("Object Spy");
    }

    private boolean checkRegistryKey(String parentKey) throws IllegalAccessException, InvocationTargetException {
        List<String> bhos = WinRegistry.readStringSubKeys(-2147483646, parentKey);
        if (bhos == null || bhos.isEmpty()) {
            return false;
        }
        for (String bho : bhos) {
            if (!bho.toLowerCase().equals(IE_ADDON_BHO_KEY.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void showMessageForMissingIEAddon() {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)ObjectSpyUrlView.this.shell, (String)StringConstants.INFO, (String)StringConstants.DIALOG_CANNOT_START_IE_MESSAGE);
            }
        });
    }

    private void closeInstantSession() {
        if (this.currentInstantSocket != null && this.currentInstantSocket.isConnected()) {
            this.currentInstantSocket.close();
        }
        this.currentInstantSocket = null;
    }

    private void createDropdownContent(Dropdown dropdown) {
        DropdownGroup newBrowser = dropdown.addDropdownGroupItem(StringConstants.MENU_ITEM_NEW_BROWSERS, ImageConstants.IMG_16_NEW_BROWSER);
        this.addNewBrowserItem(newBrowser, WebUIDriverType.FIREFOX_DRIVER);
        this.addNewBrowserItem(newBrowser, WebUIDriverType.CHROME_DRIVER);
        DropdownGroup activeBrowser = dropdown.addDropdownGroupItem(StringConstants.MENU_ITEM_ACTIVE_BROWSERS, ImageConstants.IMG_16_ACTIVE_BROWSER);
        this.addActiveBrowserItem(activeBrowser, WebUIDriverType.CHROME_DRIVER);
        this.addActiveBrowserItem(activeBrowser, WebUIDriverType.FIREFOX_DRIVER);
        DropdownGroup customCapabilities = dropdown.addDropdownGroupItem("Custom Capabilities", null);
        this.addCustomCapabilitiesItem(customCapabilities);
        if ("win32".equals(Platform.getOS())) {
            this.addNewBrowserItem(newBrowser, WebUIDriverType.IE_DRIVER);
        }
    }

    private void addCustomCapabilitiesItem(DropdownGroup customCapabilities) {
        boolean isAdded = false;
        CustomRunConfigurationContributor[] customRunConfigurationContributorArray = RunConfigurationCollector.getInstance().getAllCustomRunConfigurationContributors();
        int n = customRunConfigurationContributorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomRunConfigurationContributor customRunConfigContributor = customRunConfigurationContributorArray[n2];
            final IDriverConnector driverConnector = this.getBrowser(customRunConfigContributor);
            customCapabilities.addItem(customRunConfigContributor.getId(), null, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (driverConnector != null) {
                        ObjectSpyUrlView.this.changeBrowser(driverConnector, false);
                        ObjectSpyUrlView.this.spyInNewBrowser();
                    }
                }
            });
            isAdded = true;
            ++n2;
        }
        if (!isAdded) {
            customCapabilities.addItem("Empty", null, (SelectionListener)new SelectionAdapter(){});
        }
    }

    private IDriverConnector getBrowser(CustomRunConfigurationContributor customRunConfigContributor) {
        AbstractRunConfiguration runConfiguration = null;
        try {
            runConfiguration = (AbstractRunConfiguration)customRunConfigContributor.getRunConfiguration(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return Optional.ofNullable(runConfiguration).map(IRunConfiguration::getDriverConnectors).map(driverConnectors -> (IDriverConnector)driverConnectors.get("WebUI")).orElse(null);
    }

    private void addNewBrowserItem(DropdownGroup newBrowserGroup, final WebUIDriverType webUIDriverType) {
        newBrowserGroup.addItem(webUIDriverType.toString(), this.getWebUIDriverDropdownImage(webUIDriverType), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectSpyUrlView.this.changeBrowser(webUIDriverType, false);
                ObjectSpyUrlView.this.spyInNewBrowser();
            }
        });
    }

    private void spyInNewBrowser() {
        this.startBrowser();
    }

    private void addActiveBrowserItem(DropdownGroup activeBrowserGroup, final WebUIDriverType webUIDriverType) {
        activeBrowserGroup.addItem(webUIDriverType.toString(), this.getWebUIDriverDropdownImage(webUIDriverType), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ObjectSpyUrlView.this.changeBrowser(webUIDriverType, true);
                ObjectSpyUrlView.this.spyInActiveBrowser();
            }
        });
    }

    private void spyInActiveBrowser() {
        try {
            if (!UtilitiesAddonUtil.isNotShowingInstantBrowserDialog() && !this.showInstantBrowserDialog(this.getSelectedBrowserType())) {
                return;
            }
            this.endInspectSession();
            this.startBrowser();
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
        }
    }

    private boolean showInstantBrowserDialog(WebUIDriverType webUIDriverType) throws IOException, URISyntaxException {
        if (webUIDriverType == WebUIDriverType.IE_DRIVER) {
            this.showMessageForStartingInstantIE();
            return true;
        }
        GoToAddonStoreMessageDialog messageDialogWithToggle = new GoToAddonStoreMessageDialog(this.shell, StringConstants.HAND_ACTIVE_BROWSERS_DIA_TITLE, MessageFormat.format(StringConstants.HAND_ACTIVE_BROWSERS_DIA_MESSAGE, webUIDriverType.toString()), StringConstants.HAND_INSTANT_BROWSERS_DIA_TOOGLE_MESSAGE);
        int returnCode = messageDialogWithToggle.open();
        UtilitiesAddonUtil.setNotShowingInstantBrowserDialog(messageDialogWithToggle.getToggleState());
        if (returnCode == 3) {
            return true;
        }
        if (returnCode != 2) {
            return false;
        }
        this.openBrowserToAddonUrl(webUIDriverType);
        return true;
    }

    private void openBrowserToAddonUrl(WebUIDriverType webUIDriverType) throws IOException, URISyntaxException {
        String url = this.getAddonUrl(webUIDriverType);
        if (url == null) {
            return;
        }
        Program.launch((String)url);
    }

    protected void showMessageForStartingInstantIE() {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.HAND_ACTIVE_BROWSERS_DIA_TITLE, (String)StringConstants.DIALOG_RUNNING_INSTANT_IE_MESSAGE, (String)StringConstants.HAND_INSTANT_BROWSERS_DIA_TOOGLE_MESSAGE, (boolean)false, null, null);
                UtilitiesAddonUtil.setNotShowingInstantBrowserDialog(messageDialogWithToggle.getToggleState());
            }
        });
    }

    private String getAddonUrl(WebUIDriverType webUIDriverType) {
        if (webUIDriverType == WebUIDriverType.CHROME_DRIVER) {
            return OBJECT_SPY_CHROME_ADDON_URL;
        }
        if (webUIDriverType == WebUIDriverType.FIREFOX_DRIVER) {
            return OBJECT_SPY_FIREFOX_ADDON_URL;
        }
        return null;
    }

    private boolean getBrowserActiveFlag() {
        return this.getPreferenceStore().getBoolean("objectSpy.browserActive");
    }

    private Image getWebUIDriverDropdownImage(WebUIDriverType webUIDriverType) {
        switch (webUIDriverType) {
            case FIREFOX_DRIVER: {
                return ImageConstants.IMG_16_BROWSER_FIREFOX;
            }
            case CHROME_DRIVER: {
                return ImageConstants.IMG_16_BROWSER_CHROME;
            }
            case IE_DRIVER: {
                return ImageConstants.IMG_16_BROWSER_IE;
            }
        }
        return null;
    }

    private Image getWebUIDriverToolItemImage(WebUIDriverType webUIDriverType) {
        switch (webUIDriverType) {
            case FIREFOX_DRIVER: {
                return ImageConstants.IMG_24_FIREFOX;
            }
            case CHROME_DRIVER: {
                return ImageConstants.IMG_24_CHROME;
            }
            case IE_DRIVER: {
                return ImageConstants.IMG_24_IE;
            }
        }
        return null;
    }

    private void endInspectSession() {
        if (this.session != null && this.session.isRunning()) {
            this.session.stop();
        }
    }

    private void startInspectSession() throws Exception {
        if (this.session != null) {
            this.session.stop();
        }
        this.session = new InspectSession(this.server, this.selectedBrowser, this.txtStartUrl.getText());
        new Thread(this.session).start();
    }

    public void stop() {
        if (this.server != null && this.server.isRunning()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        this.endInspectSession();
        AddonSocketServer.getInstance().stop();
    }

    private void startInstantSession() throws Exception {
        WebUIDriverType browserType = this.getSelectedBrowserType();
        if (browserType == WebUIDriverType.IE_DRIVER) {
            this.runInstantIE();
        }
        this.currentInstantSocket = AddonSocketServer.getInstance().getAddonSocketByBrowserName(browserType.toString());
        if (this.currentInstantSocket == null) {
            return;
        }
        Win32Helper.switchFocusToBrowser(browserType);
        this.currentInstantSocket.sendMessage(new StartInspectAddonMessage());
        this.invoke((Object)ObjectSpyEvent.ADDON_SESSION_STARTED, this.currentInstantSocket);
        Trackings.trackSpy((String)"web");
    }

    protected void runInstantIE() throws Exception {
        this.session = new InspectSession(this.server, this.selectedBrowser);
        this.session.setupIE();
        WinDef.HWND hwnd = User32.INSTANCE.FindWindow(IE_WINDOW_CLASS, null);
        if (hwnd == null) {
            return;
        }
        this.shiftFocusToWindow(hwnd);
    }

    private void shiftFocusToWindow(WinDef.HWND hwnd) {
        User32.INSTANCE.ShowWindow(hwnd, 9);
        User32.INSTANCE.SetForegroundWindow(hwnd);
    }

    private void runIEAddonInstaller() throws IOException {
        String ieAddonSetupPath = String.valueOf(this.getResourcesDirectory().getAbsolutePath()) + RELATIVE_PATH_TO_IE_ADDON_SETUP;
        Program.launch((String)new File(ieAddonSetupPath).toURI().toString());
    }

    private File getResourcesDirectory() throws IOException {
        Bundle bundleExec = Platform.getBundle((String)"com.kms.katalon.composer.webui.objectspy");
        File bundleFile = FileLocator.getBundleFile((Bundle)bundleExec);
        if (bundleFile.isDirectory()) {
            return new File(bundleFile + File.separator + RESOURCES_FOLDER_NAME);
        }
        return new File(ClassPathResolver.getConfigurationFolder() + File.separator + RESOURCES_FOLDER_NAME);
    }

    private ScopedPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.webui.objectspy");
    }

    public void save() {
        ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setValue("objectspy.defaultStartingURL", this.txtStartUrl.getText());
        preferenceStore.setValue("objectspy.defaultBrowser", this.getSelectedBrowserType().toString());
        preferenceStore.setValue("objectSpy.browserActive", this.isInstant);
        try {
            preferenceStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public boolean isInstant() {
        return this.isInstant;
    }

    private WebUIDriverType getDefaultBrowserType() {
        String defaultBrowserValue = this.getPreferenceStore().getString("objectspy.defaultBrowser");
        if (StringUtils.isEmpty((String)defaultBrowserValue)) {
            return WebUIDriverType.CHROME_DRIVER;
        }
        return WebUIDriverType.fromStringValue((String)defaultBrowserValue);
    }

    private IDriverConnector getDefaultBrowser() {
        try {
            return WebUIExecutionUtil.getBrowserDriverConnector((WebUIDriverType)this.getDefaultBrowserType(), (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private WebUIDriverType getSelectedBrowserType() {
        if (this.selectedBrowser == null || !(this.selectedBrowser.getDriverType() instanceof WebUIDriverType)) {
            return null;
        }
        return (WebUIDriverType)this.selectedBrowser.getDriverType();
    }

    public AddonSocket getCurrentInstanceSocket() {
        return this.currentInstantSocket;
    }

    public WebDriver getWebDriver() {
        if (this.session == null) {
            return null;
        }
        return this.session.getWebDriver();
    }

    public Iterable<EventListener<ObjectSpyEvent>> getListeners(ObjectSpyEvent event) {
        return this.eventListeners.get((Object)event);
    }

    public void addListener(EventListener<ObjectSpyEvent> listener, Iterable<ObjectSpyEvent> events) {
        events.forEach(e -> {
            Set<EventListener<ObjectSpyEvent>> listenerOnEvent = this.eventListeners.get(e);
            if (listenerOnEvent == null) {
                listenerOnEvent = new HashSet<EventListener<ObjectSpyEvent>>();
            }
            listenerOnEvent.add(listener);
            this.eventListeners.put((ObjectSpyEvent)((Object)e), listenerOnEvent);
        });
    }
}

