/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import com.kms.katalon.objectspy.dialog.ObjectSpyEvent;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.util.WebElementUtils;
import com.kms.katalon.util.listener.EventListener;
import com.kms.katalon.util.listener.EventManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ObjectSpySelectorEditor
implements EventListener<ObjectSpyEvent>,
EventManager<ObjectSpyEvent> {
    private static final int EDITOR_LINE_HEIGHT = 4;
    private StyledText txtSelector;
    private WebElement webElement;
    private Map<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>> eventListeners = new HashMap<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>>();

    public Composite createObjectSelectorEditor(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label lblSelectorEditor = new Label(composite, 0);
        lblSelectorEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblSelectorEditor.setText(ObjectspyMessageConstants.LBL_DLG_SELECTOR_EDITOR);
        ControlUtils.setFontToBeBold((Control)lblSelectorEditor);
        this.txtSelector = new StyledText(composite, 2624);
        GridData gdTxtSelector = new GridData(4, 4, true, true, 1, 1);
        GC graphicContext = new GC((Drawable)this.txtSelector);
        FontMetrics fm = graphicContext.getFontMetrics();
        gdTxtSelector.heightHint = 4 * fm.getHeight();
        gdTxtSelector.widthHint = 300;
        this.txtSelector.setLayoutData((Object)gdTxtSelector);
        this.registerControlListeners();
        return composite;
    }

    private void registerControlListeners() {
        this.txtSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ObjectSpySelectorEditor.this.webElement == null) {
                    return;
                }
                ObjectSpySelectorEditor.this.webElement.setSelectorValue(ObjectSpySelectorEditor.this.webElement.getSelectorMethod(), ObjectSpySelectorEditor.this.txtSelector.getText());
                ObjectSpySelectorEditor.this.invoke((Object)ObjectSpyEvent.SELECTOR_HAS_CHANGED, ObjectSpySelectorEditor.this.webElement);
            }
        });
    }

    private void changeEditorStatus(String text, boolean editable) {
        this.txtSelector.setText(StringUtils.defaultString((String)text));
        this.txtSelector.setEditable(editable);
        if (editable) {
            this.txtSelector.forceFocus();
            this.txtSelector.selectAll();
            this.txtSelector.setBackground(ColorUtil.getWhiteBackgroundColor());
            return;
        }
        this.txtSelector.setBackground(ColorUtil.getDisabledItemBackgroundColor());
    }

    private void onWebElementChanged() {
        if (this.txtSelector.isDisposed()) {
            return;
        }
        if (this.webElement == null) {
            this.txtSelector.setEnabled(false);
            this.txtSelector.setText("");
            return;
        }
        this.txtSelector.setEnabled(true);
        SelectorMethod selectorMethod = this.webElement.getSelectorMethod();
        switch (selectorMethod) {
            case BASIC: {
                TestObject testObject = WebElementUtils.buildTestObject(this.webElement);
                this.changeEditorStatus(WebUiCommonHelper.getSelectorValue((TestObject)testObject), false);
                return;
            }
            case XPATH: {
                TestObject testObject2 = WebElementUtils.buildTestObject(this.webElement);
                String textToSet = WebUiCommonHelper.getSelectorValue((TestObject)testObject2);
                textToSet = textToSet == null ? "" : textToSet;
                this.changeEditorStatus(textToSet, true);
                break;
            }
            default: {
                this.changeEditorStatus(this.webElement.getSelectorCollection().get(selectorMethod), true);
            }
        }
    }

    public String getSelectorValue() {
        return this.txtSelector.getText();
    }

    public void handleEvent(ObjectSpyEvent event, Object object) {
        switch (event) {
            case ELEMENT_PROPERTIES_CHANGED: {
                this.webElement = (WebElement)object;
                if (this.webElement instanceof WebPage) {
                    this.webElement = null;
                }
                this.onWebElementChanged();
                return;
            }
        }
    }

    public Iterable<EventListener<ObjectSpyEvent>> getListeners(ObjectSpyEvent event) {
        return this.eventListeners.get((Object)event);
    }

    public void addListener(EventListener<ObjectSpyEvent> listener, Iterable<ObjectSpyEvent> events) {
        events.forEach(e -> {
            Set<EventListener<ObjectSpyEvent>> listenerOnEvent = this.eventListeners.get(e);
            if (listenerOnEvent == null) {
                listenerOnEvent = new HashSet<EventListener<ObjectSpyEvent>>();
            }
            listenerOnEvent.add(listener);
            this.eventListeners.put((ObjectSpyEvent)((Object)e), listenerOnEvent);
        });
    }
}

