/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.objectspy.dialog.SaveToObjectRepositoryDialog;
import com.kms.katalon.objectspy.element.ConflictWebElementWrapper;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebFrame;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.util.WebElementUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ObjectRepositoryService {
    public SaveActionResult saveObject(SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult dialogResult) throws Exception {
        ArrayList<Object[]> testObjectIds = new ArrayList<Object[]>();
        Set<ITreeEntity> newSelectionOnExplorer = new HashSet<ITreeEntity>();
        for (ConflictWebElementWrapper webPageWrapper : dialogResult.getAllSelectedPages()) {
            if (webPageWrapper.getType() != WebElement.WebElementType.PAGE) continue;
            WebPage page = (WebPage)webPageWrapper.getOriginalWebElement();
            for (ConflictWebElementWrapper webElementChildWrapper : webPageWrapper.getChildren()) {
                if (webElementChildWrapper.isConflicted()) {
                    this.addConflictedWebElement(page, webElementChildWrapper, dialogResult, testObjectIds);
                    continue;
                }
                newSelectionOnExplorer = this.addNonConflictedWebElement(page, webElementChildWrapper.getOriginalWebElement(), dialogResult);
            }
        }
        int savedObjectCount = dialogResult.getEntitySavedMap().size();
        if (!dialogResult.isCreateFolderAsPageNameAllowed()) {
            savedObjectCount -= dialogResult.getAllSelectedPages().size();
        }
        return new SaveActionResult(testObjectIds, newSelectionOnExplorer, savedObjectCount);
    }

    private Set<ITreeEntity> addNonConflictedWebElement(WebPage pageElement, WebElement selectedWebElement, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult dialogResult) throws Exception {
        HashSet<ITreeEntity> newSelectionOnExplorer = new HashSet();
        boolean createFolderAsPageNameAllowed = dialogResult.isCreateFolderAsPageNameAllowed();
        FolderTreeEntity selectedParentFolder = dialogResult.getSelectedParentFolder();
        Map<WebElement, FileEntity> entitySavedMap = dialogResult.getEntitySavedMap();
        FolderEntity pageFolder = this.getPageFolder(pageElement, selectedParentFolder);
        FolderTreeEntity webPageDestinationFolder = selectedParentFolder;
        if (createFolderAsPageNameAllowed) {
            webPageDestinationFolder = pageFolder == null ? this.createTreeFolderForPageElement(pageElement, selectedParentFolder, createFolderAsPageNameAllowed) : new FolderTreeEntity(pageFolder, (ITreeEntity)selectedParentFolder);
        }
        entitySavedMap.put(pageElement, (FileEntity)webPageDestinationFolder.getObject());
        newSelectionOnExplorer = this.createNewObject(webPageDestinationFolder, selectedWebElement, entitySavedMap);
        return newSelectionOnExplorer;
    }

    private FolderEntity getPageFolder(WebPage pageElement, FolderTreeEntity selectedParentFolder) throws Exception {
        String pageFolderAbsolutePath = String.valueOf(selectedParentFolder.getObject().getLocation()) + File.separator + StringUtils.trim((String)pageElement.getName());
        FolderEntity pageFolder = FolderController.getInstance().getFolder(pageFolderAbsolutePath);
        return pageFolder;
    }

    private Set<ITreeEntity> createNewObject(FolderTreeEntity webPageFolder, WebElement selectedWebElement, Map<WebElement, FileEntity> entitySavedMap) throws Exception {
        HashSet<ITreeEntity> newSelectionOnExplorer = new HashSet<ITreeEntity>();
        newSelectionOnExplorer.add((ITreeEntity)webPageFolder);
        newSelectionOnExplorer.addAll(this.createWebElementTree(selectedWebElement, webPageFolder, null, entitySavedMap));
        return newSelectionOnExplorer;
    }

    private FolderTreeEntity createTreeFolderForPageElement(WebPage pageElement, FolderTreeEntity selectedParentFolder, boolean createFolderAsPageNameAllowed) throws Exception {
        if (createFolderAsPageNameAllowed) {
            return new FolderTreeEntity(this.createFolderForPageElement(pageElement, selectedParentFolder, createFolderAsPageNameAllowed), (ITreeEntity)selectedParentFolder);
        }
        return selectedParentFolder;
    }

    public FolderEntity createFolderForPageElement(WebPage pageElement, FolderTreeEntity selectedParentFolder, boolean createFolderAsPageNameAllowed) throws Exception {
        FolderEntity parentFolder = selectedParentFolder.getObject();
        return createFolderAsPageNameAllowed ? this.newPageWebElementAsFolder(parentFolder, pageElement) : parentFolder;
    }

    private FolderEntity newPageWebElementAsFolder(FolderEntity parentFolder, WebPage pageElement) throws Exception {
        return ObjectRepositoryController.getInstance().importWebElementFolder(WebElementUtils.convertWebPageToFolder(pageElement, parentFolder), parentFolder);
    }

    private Collection<ITreeEntity> createWebElementTree(WebElement element, FolderTreeEntity parentTreeFolder, WebElementEntity refElement, Map<WebElement, FileEntity> entitySavedMap) throws Exception {
        FolderEntity parentFolderEntity = parentTreeFolder.getObject();
        WebElementEntity importedElement = ObjectRepositoryController.getInstance().importWebElement(WebElementUtils.convertWebElementToTestObject(element, refElement, parentFolderEntity), parentFolderEntity);
        WebElementTreeEntity webElementNode = new WebElementTreeEntity(importedElement, (ITreeEntity)parentTreeFolder);
        entitySavedMap.put(element, (FileEntity)importedElement);
        ArrayList<ITreeEntity> newWebElementTree = new ArrayList<ITreeEntity>();
        newWebElementTree.add((ITreeEntity)webElementNode);
        if (element instanceof WebFrame) {
            for (WebElement childElement : ((WebFrame)element).getChildren()) {
                newWebElementTree.addAll(this.createWebElementTree(childElement, parentTreeFolder, importedElement, entitySavedMap));
            }
        }
        return newWebElementTree;
    }

    private void addConflictedWebElement(WebPage webPage, ConflictWebElementWrapper wrapElement, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult dialogResult, List<Object[]> testObjectIds) throws Exception {
        FolderTreeEntity selectedParentFolder = dialogResult.getSelectedParentFolder();
        SaveToObjectRepositoryDialog.ConflictOptions selectedConflictOption = dialogResult.getSelectedConflictOption();
        Map<WebElement, FileEntity> entitySavedMap = dialogResult.getEntitySavedMap();
        WebElement newWebElement = wrapElement.getOriginalWebElement().clone();
        String folderPath = String.valueOf(ProjectController.getInstance().getCurrentProject().getFolderLocation()) + File.separator + selectedParentFolder.getObject().getRelativePath();
        if (dialogResult.isCreateFolderAsPageNameAllowed()) {
            folderPath = String.valueOf(folderPath) + File.separator + StringUtils.trim((String)webPage.getName());
        }
        FolderEntity conflictedFolderEntity = FolderController.getInstance().getFolder(folderPath);
        if (wrapElement.isConflicted()) {
            String oldElementAbsolutePath = String.valueOf(folderPath) + File.separator + StringUtils.trim((String)newWebElement.getName()) + WebElementEntity.getWebElementFileExtension();
            WebElementEntity oldWebElementEntity = ObjectRepositoryController.getInstance().getWebElement(oldElementAbsolutePath);
            switch (selectedConflictOption) {
                case CREATE_NEW_OBJECT: {
                    newWebElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(conflictedFolderEntity, StringUtils.trim((String)newWebElement.getName())));
                    WebElementEntity importedWebElement = ObjectRepositoryController.getInstance().importWebElement(WebElementUtils.convertWebElementToTestObject(newWebElement, null, conflictedFolderEntity), conflictedFolderEntity);
                    entitySavedMap.put(wrapElement.getOriginalWebElement(), (FileEntity)importedWebElement);
                    break;
                }
                case REPLACE_EXISTING_OBJECT: {
                    oldWebElementEntity.setWebElementProperties(newWebElement.getProperties());
                    oldWebElementEntity.setWebElementXpaths(newWebElement.getXpaths());
                    oldWebElementEntity.setSelectorMethod(WebElementSelectorMethod.valueOf((String)wrapElement.getOriginalWebElement().getSelectorMethod().toString()));
                    entitySavedMap.put(wrapElement.getOriginalWebElement(), (FileEntity)oldWebElementEntity);
                    break;
                }
                case MERGE_CHANGE_TO_EXISTING_OBJECT: {
                    LinkedHashSet<WebElementPropertyEntity> mergedProperties = new LinkedHashSet<WebElementPropertyEntity>();
                    mergedProperties.addAll(newWebElement.getProperties());
                    for (WebElementPropertyEntity wProperty : oldWebElementEntity.getWebElementProperties()) {
                        wProperty.setIsSelected(Boolean.valueOf(false));
                    }
                    mergedProperties.addAll(oldWebElementEntity.getWebElementProperties());
                    oldWebElementEntity.setWebElementProperties(new ArrayList(mergedProperties));
                    LinkedHashSet<WebElementXpathEntity> mergedXpaths = new LinkedHashSet<WebElementXpathEntity>();
                    mergedXpaths.addAll(newWebElement.getXpaths());
                    for (WebElementXpathEntity wXpath : oldWebElementEntity.getWebElementXpaths()) {
                        wXpath.setIsSelected(Boolean.valueOf(false));
                    }
                    mergedXpaths.addAll(oldWebElementEntity.getWebElementXpaths());
                    oldWebElementEntity.setWebElementXpaths(new ArrayList(mergedXpaths));
                    oldWebElementEntity.setSelectorMethod(WebElementSelectorMethod.valueOf((String)wrapElement.getOriginalWebElement().getSelectorMethod().toString()));
                    entitySavedMap.put(wrapElement.getOriginalWebElement(), (FileEntity)oldWebElementEntity);
                    break;
                }
            }
            ObjectRepositoryController.getInstance().updateTestObject(oldWebElementEntity);
            testObjectIds.add(new Object[]{oldWebElementEntity.getId(), oldWebElementEntity});
        } else {
            WebElementEntity newWebElementEntity = ObjectRepositoryController.getInstance().importWebElement(WebElementUtils.convertWebElementToTestObject(newWebElement, null, conflictedFolderEntity), conflictedFolderEntity);
            testObjectIds.add(new Object[]{newWebElementEntity.getId(), conflictedFolderEntity});
        }
    }

    public class SaveActionResult {
        List<Object[]> updatedTestObjectIds;
        Set<ITreeEntity> newSelectionOnExplorer;
        int savedObjectCount;

        public SaveActionResult(List<Object[]> updatedTestObjectIds, Set<ITreeEntity> newSelectionOnExplorer, int savedObjectCount) {
            this.updatedTestObjectIds = updatedTestObjectIds;
            this.newSelectionOnExplorer = newSelectionOnExplorer;
            this.savedObjectCount = savedObjectCount;
        }

        public List<Object[]> getUpdatedTestObjectIds() {
            return this.updatedTestObjectIds;
        }

        public Set<ITreeEntity> getNewSelectionOnExplorer() {
            return this.newSelectionOnExplorer;
        }

        public int getSavedObjectCount() {
            return this.savedObjectCount;
        }
    }
}

