/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AddTestObjectPropertyDialog;
import com.kms.katalon.composer.components.impl.editors.StringComboBoxCellEditor;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.objectspy.constants.ImageConstants;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import com.kms.katalon.objectspy.constants.StringConstants;
import com.kms.katalon.objectspy.dialog.ObjectSpyEvent;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.util.listener.EventListener;
import com.kms.katalon.util.listener.EventManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ObjectPropertiesView
extends Composite
implements EventListener<ObjectSpyEvent>,
EventManager<ObjectSpyEvent> {
    private static final String WARN_MSG_OBJECT_PROPERTY_NAME_IS_EXISTED = ObjectspyMessageConstants.WARN_MSG_OBJECT_PROPERTY_NAME_IS_EXISTED;
    private static final String LBL_OBJECT_SELECTION_METHOD = ObjectspyMessageConstants.DIA_LBL_OBJECT_SELECTION_METHOD;
    private static final String RADIO_LABEL_CSS = ObjectspyMessageConstants.DIA_RADIO_LABEL_CSS;
    private static final String RADIO_LABEL_XPATH = ObjectspyMessageConstants.DIA_RADIO_LABEL_XPATH;
    private static final String RADIO_LABEL_ATTRIBUTES = ObjectspyMessageConstants.DIA_RADIO_LABEL_ATTRIBUTES;
    private static final String COL_LABEL_CONDITION = ObjectspyMessageConstants.DIA_COL_LABEL_CONDITION;
    private Table tProperty;
    private Table tXpath;
    private TableViewer tvProperty;
    private TableViewer tvXpath;
    private TableViewerColumn cvProperty;
    private TableViewerColumn cvCondition;
    private TableViewerColumn cvValue;
    private TableViewerColumn cvSelected;
    private TableViewerColumn cvXpathName;
    private TableViewerColumn cvXpathValue;
    private TableViewerColumn cvXpathSelected;
    private TableColumn cName;
    private TableColumn cCondition;
    private TableColumn cValue;
    private TableColumn cSelected;
    private TableColumn cXpathName;
    private TableColumn cXpathValue;
    private TableColumn cXpathSelected;
    private Text txtName;
    private Button radioAttributes;
    private Button radioXpath;
    private Button radioCss;
    private ToolItem btnAdd;
    private ToolItem btnDelete;
    private ToolItem btnClear;
    private Label lblHelp;
    private Composite radioBtnComposite;
    private Composite compositeAttributeToolbar;
    private ToolBar toolbar;
    private WebElement webElement;
    private Runnable refreshTreeRunnable;
    private Shell shell;
    private Map<SelectorMethod, Button> selectorButtons = new HashMap<SelectorMethod, Button>();
    private Composite tableAndButtonsComposite;
    private Composite xpathTableComposite;
    private Composite propertyTableComposite;
    private int lastHeight = -1;
    private Map<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>> eventListeners = new HashMap<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>>();

    public ObjectPropertiesView(Composite parent, int style) {
        super(parent, style);
        this.shell = parent.getShell();
        this.setLayoutAndLayoutData();
        this.createHeaderLabel();
        this.createObjectFields();
        this.tableAndButtonsComposite = new Composite((Composite)this, 0);
        this.tableAndButtonsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout ldTableAndButtons = new GridLayout(1, false);
        ldTableAndButtons.marginWidth = 0;
        ldTableAndButtons.marginHeight = 0;
        this.tableAndButtonsComposite.setLayout((Layout)ldTableAndButtons);
        this.createAttributeToolbarButtons(this.tableAndButtonsComposite);
        this.createPropertyTable(this.tableAndButtonsComposite);
        this.createXpathTable(this.tableAndButtonsComposite);
        this.showComposite(this.propertyTableComposite, false);
        this.showComposite(this.xpathTableComposite, true);
        this.showComposite(this.compositeAttributeToolbar, false);
        this.addControlListeners();
        this.enableControls();
        this.subscribeEvents();
    }

    private void displayPropertiesTableComposite(boolean visible) {
        GridData gdPropertiesComposite = (GridData)this.tableAndButtonsComposite.getLayoutData();
        gdPropertiesComposite.exclude = !visible;
        gdPropertiesComposite.heightHint = this.lastHeight;
        if (!visible) {
            this.lastHeight = this.tableAndButtonsComposite.getBounds().height;
        }
        this.tableAndButtonsComposite.setVisible(visible);
        this.tableAndButtonsComposite.pack();
        GridData gdView = new GridData(4, 4, true, true);
        if (!visible) {
            gdView = new GridData(4, 128, true, false);
        }
        this.setLayoutData(gdView);
        this.tableAndButtonsComposite.getParent().getParent().layout(true, true);
        this.invoke((Object)ObjectSpyEvent.REQUEST_DIALOG_RESIZE, null);
    }

    public WebElement getWebElement() {
        return this.webElement;
    }

    private void setWebElement(WebElement webElement) {
        this.webElement = webElement;
        this.enableControls();
        this.txtName.setText(webElement != null ? webElement.getName() : "");
        this.populateSelectionMethod();
        this.updateWebObjectProperties();
        this.updateWebObjectXpaths();
        this.sendPropertiesChangedEvent();
    }

    private void setLayoutAndLayoutData() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
    }

    private void createHeaderLabel() {
        Label lblObjectsProperties = new Label((Composite)this, 0);
        lblObjectsProperties.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblObjectsProperties.setText(StringConstants.DIA_LBL_OBJECT_PROPERTIES);
        ControlUtils.setFontToBeBold((Control)lblObjectsProperties);
    }

    private void createObjectFields() {
        Composite fieldsComposite = new Composite((Composite)this, 0);
        fieldsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glFieldsComposite = new GridLayout(2, false);
        glFieldsComposite.marginWidth = 0;
        glFieldsComposite.marginHeight = 0;
        fieldsComposite.setLayout((Layout)glFieldsComposite);
        Label lblName = new Label(fieldsComposite, 0);
        lblName.setText(StringConstants.DIA_LBL_NAME);
        lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtName = new Text(fieldsComposite, 2048);
        this.txtName.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createObjectSelectionMethodOptions(fieldsComposite);
    }

    private void createObjectSelectionMethodOptions(Composite parent) {
        Composite methodComposite = new Composite(parent, 0);
        methodComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glMethodComposite = new GridLayout(2, false);
        glMethodComposite.marginWidth = 0;
        glMethodComposite.marginHeight = 0;
        glMethodComposite.marginRight = 10;
        methodComposite.setLayout((Layout)glMethodComposite);
        Label lblObjectDetectMethod = new Label(methodComposite, 0);
        lblObjectDetectMethod.setText(LBL_OBJECT_SELECTION_METHOD);
        this.lblHelp = new Label(methodComposite, 0);
        GridData gdLblHelp = new GridData(16384, 0x1000000, true, true, 1, 1);
        gdLblHelp.heightHint = 20;
        this.lblHelp.setLayoutData((Object)gdLblHelp);
        this.lblHelp.setImage(ImageConstants.IMG_16_HELP);
        this.lblHelp.setCursor(Display.getDefault().getSystemCursor(21));
        this.radioBtnComposite = new Composite(parent, 0);
        this.radioBtnComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
        RowLayout rlRadioBtnComposite = new RowLayout(256);
        rlRadioBtnComposite.marginTop = 0;
        rlRadioBtnComposite.marginRight = 0;
        rlRadioBtnComposite.marginLeft = 0;
        rlRadioBtnComposite.marginBottom = 0;
        rlRadioBtnComposite.spacing = 5;
        rlRadioBtnComposite.fill = true;
        this.radioBtnComposite.setLayout((Layout)rlRadioBtnComposite);
        this.radioXpath = new Button(this.radioBtnComposite, 0x800010);
        this.radioXpath.setText(RADIO_LABEL_XPATH);
        this.radioXpath.setSelection(true);
        this.selectorButtons.put(SelectorMethod.XPATH, this.radioXpath);
        this.radioAttributes = new Button(this.radioBtnComposite, 0x800010);
        this.radioAttributes.setText(RADIO_LABEL_ATTRIBUTES);
        this.selectorButtons.put(SelectorMethod.BASIC, this.radioAttributes);
        this.radioCss = new Button(this.radioBtnComposite, 0x800010);
        this.radioCss.setText(RADIO_LABEL_CSS);
        this.selectorButtons.put(SelectorMethod.CSS, this.radioCss);
    }

    private void createAttributeToolbarButtons(Composite parent) {
        this.compositeAttributeToolbar = new Composite(parent, 0);
        this.compositeAttributeToolbar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.compositeAttributeToolbar.setLayout((Layout)new FillLayout(256));
        this.toolbar = new ToolBar(this.compositeAttributeToolbar, 0x820000);
        this.btnAdd = new ToolItem(this.toolbar, 0);
        this.btnAdd.setText(StringConstants.ADD);
        this.btnAdd.setImage(ImageConstants.IMG_16_ADD);
        this.btnDelete = new ToolItem(this.toolbar, 0);
        this.btnDelete.setText(StringConstants.DELETE);
        this.btnDelete.setImage(ImageConstants.IMG_16_DELETE);
        this.btnDelete.setDisabledImage(ImageConstants.IMG_16_DELETE_DISABLED);
        this.btnClear = new ToolItem(this.toolbar, 0);
        this.btnClear.setText(StringConstants.CLEAR);
        this.btnClear.setImage(ImageConstants.IMG_16_CLEAR);
        this.btnClear.setDisabledImage(ImageConstants.IMG_16_CLEAR_DISABLED);
    }

    private void createPropertyTable(Composite parent) {
        this.propertyTableComposite = new Composite(parent, 0);
        GridData ldTableComposite = new GridData(4, 4, true, true);
        ldTableComposite.heightHint = 100;
        this.propertyTableComposite.setLayoutData((Object)ldTableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        this.propertyTableComposite.setLayout((Layout)tableColumnLayout);
        this.tvProperty = new TableViewer(this.propertyTableComposite, 68354);
        this.tvProperty.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tProperty = this.tvProperty.getTable();
        this.tProperty.setHeaderVisible(true);
        this.tProperty.setLinesVisible(true);
        this.tvProperty.setInput(Collections.emptyList());
        this.cvProperty = new TableViewerColumn(this.tvProperty, 16384);
        this.cName = this.cvProperty.getColumn();
        this.cName.setText(StringConstants.DIA_COL_NAME);
        this.cvProperty.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getName();
            }
        });
        this.cvProperty.setEditingSupport(new EditingSupport(this.cvProperty.getViewer()){

            protected void setValue(Object element, Object value) {
                if (!this.canEdit(element)) {
                    return;
                }
                ((WebElementPropertyEntity)element).setName(String.valueOf(value));
                ObjectPropertiesView.this.tvProperty.update(element, null);
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
                ObjectPropertiesView.this.refreshCapturedObjectsTree();
            }

            protected Object getValue(Object element) {
                if (!this.canEdit(element)) {
                    return StringConstants.EMPTY;
                }
                return ((WebElementPropertyEntity)element).getName();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)ObjectPropertiesView.this.tProperty);
            }

            protected boolean canEdit(Object element) {
                return ObjectPropertiesView.this.isWebElementProperty(element);
            }
        });
        this.cvCondition = new TableViewerColumn(this.tvProperty, 16384);
        this.cCondition = this.cvCondition.getColumn();
        this.cCondition.setText(COL_LABEL_CONDITION);
        this.cvCondition.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getMatchCondition();
            }
        });
        this.cvCondition.setEditingSupport(new EditingSupport(this.cvCondition.getViewer()){

            protected void setValue(Object element, Object value) {
                if (!this.canEdit(element)) {
                    return;
                }
                ((WebElementPropertyEntity)element).setMatchCondition(String.valueOf(value));
                ObjectPropertiesView.this.tvProperty.update(element, null);
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
                ObjectPropertiesView.this.refreshCapturedObjectsTree();
            }

            protected Object getValue(Object element) {
                if (!this.canEdit(element)) {
                    return StringConstants.EMPTY;
                }
                return ((WebElementPropertyEntity)element).getMatchCondition();
            }

            protected CellEditor getCellEditor(Object element) {
                StringComboBoxCellEditor comboBoxCellEditor = new StringComboBoxCellEditor((Composite)ObjectPropertiesView.this.tProperty, WebElementPropertyEntity.MATCH_CONDITION.getTextVlues(), 8);
                return comboBoxCellEditor;
            }

            protected boolean canEdit(Object element) {
                return ObjectPropertiesView.this.isWebElementProperty(element);
            }
        });
        this.cvValue = new TableViewerColumn(this.tvProperty, 16384);
        this.cValue = this.cvValue.getColumn();
        this.cValue.setText(StringConstants.DIA_COL_VALUE);
        this.cvValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getValue();
            }
        });
        this.cvValue.setEditingSupport(new EditingSupport(this.cvValue.getViewer()){

            protected void setValue(Object element, Object value) {
                if (!this.canEdit(element)) {
                    return;
                }
                WebElementPropertyEntity webElementProp = (WebElementPropertyEntity)element;
                String newPropValue = String.valueOf(value);
                webElementProp.setValue(newPropValue);
                ObjectPropertiesView.this.tvProperty.update(element, null);
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
                ObjectPropertiesView.this.refreshCapturedObjectsTree();
            }

            protected Object getValue(Object element) {
                if (!this.canEdit(element)) {
                    return StringConstants.EMPTY;
                }
                return ((WebElementPropertyEntity)element).getValue();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)ObjectPropertiesView.this.tProperty);
            }

            protected boolean canEdit(Object element) {
                return ObjectPropertiesView.this.isWebElementProperty(element);
            }
        });
        this.cvSelected = new TableViewerColumn(this.tvProperty, 0x1000000);
        this.cSelected = this.cvSelected.getColumn();
        this.cSelected.setText(this.getCheckboxIcon(this.isAllPropetyEnabled()));
        this.cSelected.setResizable(false);
        this.cSelected.pack();
        this.cSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectPropertiesView.this.webElement == null || ObjectPropertiesView.this.getProperties() == null || ObjectPropertiesView.this.getProperties().isEmpty()) {
                    return;
                }
                boolean isAllPropetyEnabled = ObjectPropertiesView.this.isAllPropetyEnabled();
                ObjectPropertiesView.this.cSelected.setText(ObjectPropertiesView.this.getCheckboxIcon(!isAllPropetyEnabled));
                ObjectPropertiesView.this.setAllProperty(!isAllPropetyEnabled);
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
            }
        });
        this.cvSelected.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object property = cell.getElement();
                if (!ObjectPropertiesView.this.isWebElementProperty(property)) {
                    return;
                }
                Boolean isSelected = ((WebElementPropertyEntity)property).getIsSelected();
                cell.setText(ObjectPropertiesView.this.getCheckboxIcon(isSelected));
                ObjectPropertiesView.this.cSelected.setText(ObjectPropertiesView.this.getCheckboxIcon(ObjectPropertiesView.this.isAllPropetyEnabled()));
            }
        });
        this.cvSelected.setEditingSupport(new EditingSupport(this.cvSelected.getViewer()){

            protected void setValue(Object element, Object value) {
                if (!this.canEdit(element)) {
                    return;
                }
                ((WebElementPropertyEntity)element).setIsSelected(Boolean.valueOf((Boolean)value));
                ObjectPropertiesView.this.tvProperty.update(element, null);
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
            }

            protected Object getValue(Object element) {
                if (this.canEdit(element) && ((WebElementPropertyEntity)element).getIsSelected().booleanValue()) {
                    return true;
                }
                return false;
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor();
            }

            protected boolean canEdit(Object element) {
                return ObjectPropertiesView.this.isWebElementProperty(element);
            }
        });
        tableColumnLayout.setColumnData((Widget)this.cName, (ColumnLayoutData)new ColumnWeightData(20, 100));
        tableColumnLayout.setColumnData((Widget)this.cCondition, (ColumnLayoutData)new ColumnWeightData(20, 100));
        tableColumnLayout.setColumnData((Widget)this.cValue, (ColumnLayoutData)new ColumnWeightData(50, 150));
        tableColumnLayout.setColumnData((Widget)this.cSelected, (ColumnLayoutData)new ColumnWeightData(5, 30, false));
    }

    private void createXpathTable(Composite parent) {
        this.xpathTableComposite = new Composite(parent, 0);
        GridData ldTableComposite = new GridData(4, 4, true, true);
        ldTableComposite.heightHint = 100;
        this.xpathTableComposite.setLayoutData((Object)ldTableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        this.xpathTableComposite.setLayout((Layout)tableColumnLayout);
        this.tvXpath = new TableViewer(this.xpathTableComposite, 68354);
        this.tvXpath.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tXpath = this.tvXpath.getTable();
        this.tXpath.setHeaderVisible(true);
        this.tXpath.setLinesVisible(true);
        this.tvXpath.setInput(Collections.emptyList());
        this.cvXpathName = new TableViewerColumn(this.tvXpath, 16384);
        this.cXpathName = this.cvXpathName.getColumn();
        this.cXpathName.setText(StringConstants.DIA_COL_NAME);
        this.cvXpathName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementXpathEntity)element).getName();
            }
        });
        this.cvXpathValue = new TableViewerColumn(this.tvXpath, 16384);
        this.cXpathValue = this.cvXpathValue.getColumn();
        this.cXpathValue.setText(StringConstants.DIA_COL_VALUE);
        this.cvXpathValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementXpathEntity)element).getValue();
            }
        });
        this.cvXpathValue.setEditingSupport(new EditingSupport(this.cvXpathValue.getViewer()){

            protected void setValue(Object element, Object value) {
                if (!this.canEdit(element)) {
                    return;
                }
                WebElementXpathEntity webElementXpath = (WebElementXpathEntity)element;
                String newXpathValue = String.valueOf(value);
                webElementXpath.setValue(newXpathValue);
                ObjectPropertiesView.this.tvXpath.update(element, null);
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
                ObjectPropertiesView.this.refreshCapturedObjectsTree();
            }

            protected Object getValue(Object element) {
                if (!this.canEdit(element)) {
                    return StringConstants.EMPTY;
                }
                return ((WebElementXpathEntity)element).getValue();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)ObjectPropertiesView.this.tXpath);
            }

            protected boolean canEdit(Object element) {
                return ObjectPropertiesView.this.isWebElementXpath(element);
            }
        });
        tableColumnLayout.setColumnData((Widget)this.cXpathName, (ColumnLayoutData)new ColumnWeightData(50, 150));
        tableColumnLayout.setColumnData((Widget)this.cXpathValue, (ColumnLayoutData)new ColumnWeightData(50, 150));
    }

    private void showComposite(Composite composite, boolean isVisible) {
        composite.setVisible(isVisible);
        ((GridData)composite.getLayoutData()).exclude = !isVisible;
        composite.getParent().layout();
    }

    private boolean isWebElementProperty(Object element) {
        return element != null && WebElementPropertyEntity.class.getSimpleName().equals(element.getClass().getSimpleName());
    }

    private boolean isWebElementXpath(Object element) {
        return element != null && WebElementXpathEntity.class.getSimpleName().equals(element.getClass().getSimpleName());
    }

    private void deselectAllXpaths() {
        List<WebElementXpathEntity> xpaths = this.getXpaths();
        for (WebElementXpathEntity xpath : xpaths) {
            xpath.setIsSelected(Boolean.valueOf(false));
        }
    }

    private void addControlListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ObjectPropertiesView.this.txtName.getText();
                if (ObjectPropertiesView.this.webElement != null && !ObjectPropertiesView.this.webElement.getName().equals(text)) {
                    ObjectPropertiesView.this.webElement.setName(text);
                    ObjectPropertiesView.this.sendNameChangedEvent();
                    ObjectPropertiesView.this.refreshCapturedObjectsTree();
                }
            }
        });
        this.radioAttributes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectPropertiesView.this.webElement == null || !ObjectPropertiesView.this.radioAttributes.getSelection()) {
                    return;
                }
                ObjectPropertiesView.this.enableControls();
                ObjectPropertiesView.this.webElement.setSelectorMethod(SelectorMethod.BASIC);
                ObjectPropertiesView.this.showComposite(ObjectPropertiesView.this.propertyTableComposite, true);
                ObjectPropertiesView.this.showComposite(ObjectPropertiesView.this.xpathTableComposite, false);
                ObjectPropertiesView.this.showComposite(ObjectPropertiesView.this.compositeAttributeToolbar, true);
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
            }
        });
        this.radioXpath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectPropertiesView.this.webElement == null || !ObjectPropertiesView.this.radioXpath.getSelection()) {
                    return;
                }
                ObjectPropertiesView.this.disableControls();
                ObjectPropertiesView.this.webElement.setSelectorMethod(SelectorMethod.XPATH);
                ObjectPropertiesView.this.showComposite(ObjectPropertiesView.this.propertyTableComposite, false);
                ObjectPropertiesView.this.showComposite(ObjectPropertiesView.this.xpathTableComposite, true);
                ObjectPropertiesView.this.showComposite(ObjectPropertiesView.this.compositeAttributeToolbar, false);
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
            }
        });
        this.radioCss.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectPropertiesView.this.webElement == null || !ObjectPropertiesView.this.radioCss.getSelection()) {
                    return;
                }
                ObjectPropertiesView.this.webElement.setSelectorMethod(SelectorMethod.CSS);
                ObjectPropertiesView.this.showComposite(ObjectPropertiesView.this.propertyTableComposite, false);
                ObjectPropertiesView.this.showComposite(ObjectPropertiesView.this.xpathTableComposite, false);
                ObjectPropertiesView.this.showComposite(ObjectPropertiesView.this.compositeAttributeToolbar, false);
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
            }
        });
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectPropertiesView.this.webElement == null) {
                    return;
                }
                WebElementPropertyEntity property = ObjectPropertiesView.this.openAddPropertyDialog();
                if (property == null) {
                    return;
                }
                if (ObjectPropertiesView.this.webElement.getProperty(property.getName()) != null) {
                    MessageDialog.openWarning((Shell)ObjectPropertiesView.this.getShell(), (String)StringConstants.WARN, (String)WARN_MSG_OBJECT_PROPERTY_NAME_IS_EXISTED);
                    return;
                }
                ObjectPropertiesView.this.webElement.addProperty(property);
                ObjectPropertiesView.this.updateWebObjectProperties();
                ObjectPropertiesView.this.updateWebObjectXpaths();
                ObjectPropertiesView.this.refreshCapturedObjectsTree();
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
            }
        });
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectPropertiesView.this.webElement == null || !ObjectPropertiesView.this.webElement.hasProperty()) {
                    return;
                }
                int[] selectedPropertyIndices = ObjectPropertiesView.this.tProperty.getSelectionIndices();
                if (selectedPropertyIndices.length == 0) {
                    return;
                }
                List properties = ObjectPropertiesView.this.getProperties();
                List selectedProperties = Arrays.stream(selectedPropertyIndices).boxed().map(i -> (WebElementPropertyEntity)properties.get((int)i)).collect(Collectors.toList());
                properties.removeAll(selectedProperties);
                ObjectPropertiesView.this.updateWebObjectProperties();
                ObjectPropertiesView.this.updateWebObjectXpaths();
                ObjectPropertiesView.this.refreshCapturedObjectsTree();
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
            }
        });
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectPropertiesView.this.webElement != null) {
                    ObjectPropertiesView.this.getProperties().clear();
                }
                ObjectPropertiesView.this.updateWebObjectProperties();
                ObjectPropertiesView.this.updateWebObjectXpaths();
                ObjectPropertiesView.this.refreshCapturedObjectsTree();
                ObjectPropertiesView.this.sendPropertiesChangedEvent();
            }
        });
        this.lblHelp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Program.launch((String)DocumentationMessageConstants.DIALOG_OBJECT_SPY_WEB_UI_SELECTION_METHOD);
            }
        });
        this.tvProperty.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObjectPropertiesView.this.btnDelete.setEnabled(ObjectPropertiesView.this.hasPropertySelected());
            }
        });
        this.tvXpath.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObjectPropertiesView.this.btnDelete.setEnabled(ObjectPropertiesView.this.hasXpathSelected());
            }
        });
    }

    private void sendPropertiesChangedEvent() {
        this.invoke((Object)ObjectSpyEvent.ELEMENT_PROPERTIES_CHANGED, this.webElement);
    }

    private void sendNameChangedEvent() {
        this.invoke((Object)ObjectSpyEvent.ELEMENT_NAME_CHANGED, this.webElement);
    }

    public void setRefreshCapturedObjectsTree(Runnable refreshTreeRunnable) {
        this.refreshTreeRunnable = refreshTreeRunnable;
    }

    private void refreshCapturedObjectsTree() {
        if (this.refreshTreeRunnable == null) {
            return;
        }
        Display.getDefault().asyncExec(this.refreshTreeRunnable);
    }

    private String getCheckboxIcon(boolean isChecked) {
        return isChecked ? "\u2611" : "\u2610";
    }

    private boolean isAllPropetyEnabled() {
        if (this.webElement == null) {
            return false;
        }
        List<WebElementPropertyEntity> properties = this.getProperties();
        if (properties == null || properties.isEmpty()) {
            return false;
        }
        return properties.stream().filter(property -> property.getIsSelected()).count() == (long)properties.size();
    }

    private boolean isAllXpathEnabled() {
        if (this.webElement == null) {
            return false;
        }
        List<WebElementXpathEntity> xpaths = this.getXpaths();
        if (xpaths == null || xpaths.isEmpty()) {
            return false;
        }
        return xpaths.stream().filter(xpath -> xpath.getIsSelected()).count() == (long)xpaths.size();
    }

    private void setAllProperty(boolean isSelected) {
        if (this.webElement == null) {
            return;
        }
        List<WebElementPropertyEntity> properties = this.getProperties();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        properties.forEach(property -> property.setIsSelected(Boolean.valueOf(isSelected)));
        this.updateWebObjectProperties();
    }

    private void setAllXpath(boolean isSelected) {
        if (this.webElement == null) {
            return;
        }
        List<WebElementXpathEntity> xpaths = this.getXpaths();
        if (xpaths == null || xpaths.isEmpty()) {
            return;
        }
        xpaths.forEach(xpath -> xpath.setIsSelected(Boolean.valueOf(isSelected)));
        this.updateWebObjectXpaths();
    }

    private WebElementPropertyEntity openAddPropertyDialog() {
        AddTestObjectPropertyDialog dialog = new AddTestObjectPropertyDialog(this.shell);
        if (dialog.open() != 0) {
            return null;
        }
        WebElementPropertyEntity prop = new WebElementPropertyEntity(dialog.getName(), dialog.getValue());
        prop.setMatchCondition(dialog.getCondition());
        return prop;
    }

    private void populateSelectionMethod() {
        if (this.webElement == null) {
            return;
        }
        this.selectorButtons.entrySet().forEach(entry -> ((Button)entry.getValue()).setSelection(entry.getKey() == this.webElement.getSelectorMethod()));
    }

    private void enableControls() {
        boolean isEnabledForNoneWebPage;
        boolean isEnabled = this.webElement != null;
        boolean bl = isEnabledForNoneWebPage = isEnabled && !this.webElement.getClass().getSimpleName().equals(WebPage.class.getSimpleName());
        if (this.radioBtnComposite != null && !this.radioBtnComposite.isDisposed()) {
            Arrays.stream(this.radioBtnComposite.getChildren()).forEach(radioBtn -> radioBtn.setEnabled(isEnabledForNoneWebPage));
        }
        if (ControlUtils.isReady((Control)this.toolbar)) {
            this.btnAdd.setEnabled(isEnabledForNoneWebPage);
            this.btnDelete.setEnabled(isEnabled);
            this.btnClear.setEnabled(isEnabled);
        }
        if (ControlUtils.isReady((Control)this.txtName)) {
            this.txtName.setEditable(isEnabled);
        }
    }

    private void disableControls() {
        this.btnAdd.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.btnClear.setEnabled(false);
    }

    public void refreshTable(WebElement selectedElement) {
        if (selectedElement != null) {
            this.txtName.setEditable(true);
            this.txtName.setText(selectedElement.getName());
        } else {
            this.txtName.setEditable(false);
            this.txtName.setText(StringConstants.EMPTY);
        }
        this.setWebElement(selectedElement);
        this.tvProperty.refresh();
        this.tvXpath.refresh();
    }

    protected void updateWebObjectProperties() {
        this.tProperty.removeAll();
        List<Object> properties = this.webElement == null ? Collections.emptyList() : this.getProperties();
        this.tvProperty.setInput(properties);
        if (this.webElement == null) {
            this.showComposite(this.propertyTableComposite, true);
            this.showComposite(this.xpathTableComposite, false);
            this.showComposite(this.compositeAttributeToolbar, false);
        } else {
            this.showComposite(this.propertyTableComposite, this.webElement.getSelectorMethod() == SelectorMethod.BASIC);
            this.showComposite(this.xpathTableComposite, this.webElement.getSelectorMethod() == SelectorMethod.XPATH);
            this.showComposite(this.compositeAttributeToolbar, this.webElement.getSelectorMethod() == SelectorMethod.BASIC);
        }
        this.cSelected.setText(this.getCheckboxIcon(this.isAllPropetyEnabled()));
        boolean hasProperty = !properties.isEmpty();
        this.btnDelete.setEnabled(hasProperty && this.hasPropertySelected());
        this.btnClear.setEnabled(hasProperty);
        this.refreshCapturedObjectsTree();
    }

    protected void updateWebObjectXpaths() {
        this.tXpath.removeAll();
        List<Object> xpaths = this.webElement == null ? Collections.emptyList() : this.getXpaths();
        this.tvXpath.setInput(xpaths);
        if (this.webElement == null) {
            this.showComposite(this.propertyTableComposite, false);
            this.showComposite(this.xpathTableComposite, true);
            this.showComposite(this.compositeAttributeToolbar, false);
        } else {
            this.showComposite(this.propertyTableComposite, this.webElement.getSelectorMethod() == SelectorMethod.BASIC);
            this.showComposite(this.xpathTableComposite, this.webElement.getSelectorMethod() == SelectorMethod.XPATH);
            this.showComposite(this.compositeAttributeToolbar, this.webElement.getSelectorMethod() == SelectorMethod.BASIC);
        }
        boolean hasXpath = !xpaths.isEmpty();
        this.btnDelete.setEnabled(hasXpath && this.hasXpathSelected());
        this.btnClear.setEnabled(hasXpath);
        this.refreshCapturedObjectsTree();
    }

    private List<WebElementPropertyEntity> getProperties() {
        return this.webElement.getProperties();
    }

    private List<WebElementXpathEntity> getXpaths() {
        return this.webElement.getXpaths();
    }

    private void subscribeEvents() {
    }

    private void unsubscribeEvents() {
    }

    public void dispose() {
        this.unsubscribeEvents();
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private boolean hasPropertySelected() {
        StructuredSelection selection = (StructuredSelection)this.tvProperty.getSelection();
        return selection != null && selection.getFirstElement() != null;
    }

    private boolean hasXpathSelected() {
        StructuredSelection selection = (StructuredSelection)this.tvXpath.getSelection();
        return selection != null && selection.getFirstElement() != null;
    }

    public void handleEvent(ObjectSpyEvent event, Object object) {
        switch (event) {
            case SELECTED_ELEMENT_CHANGED: {
                this.setWebElement((WebElement)object);
                return;
            }
        }
    }

    public Iterable<EventListener<ObjectSpyEvent>> getListeners(ObjectSpyEvent event) {
        return this.eventListeners.get((Object)event);
    }

    public void addListener(EventListener<ObjectSpyEvent> listener, Iterable<ObjectSpyEvent> events) {
        events.forEach(e -> {
            Set<EventListener<ObjectSpyEvent>> listenerOnEvent = this.eventListeners.get(e);
            if (listenerOnEvent == null) {
                listenerOnEvent = new HashSet<EventListener<ObjectSpyEvent>>();
            }
            listenerOnEvent.add(listener);
            this.eventListeners.put((ObjectSpyEvent)((Object)e), listenerOnEvent);
        });
    }
}

