/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.objectspy.constants.ImageConstants;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import com.kms.katalon.objectspy.constants.StringConstants;
import com.kms.katalon.objectspy.core.HTMLElementCollector;
import com.kms.katalon.objectspy.dialog.CapturedObjectsView;
import com.kms.katalon.objectspy.dialog.ObjectPropertiesView;
import com.kms.katalon.objectspy.dialog.ObjectRepositoryService;
import com.kms.katalon.objectspy.dialog.ObjectSpyEvent;
import com.kms.katalon.objectspy.dialog.ObjectSpySelectorEditor;
import com.kms.katalon.objectspy.dialog.ObjectSpyUrlView;
import com.kms.katalon.objectspy.dialog.ObjectVerifyAndHighlightView;
import com.kms.katalon.objectspy.dialog.SaveToObjectRepositoryDialog;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebFrame;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.tree.WebElementTreeContentProvider;
import com.kms.katalon.objectspy.util.UtilitiesAddonUtil;
import com.kms.katalon.objectspy.util.WebElementUtils;
import com.kms.katalon.objectspy.websocket.AddonSocket;
import com.kms.katalon.objectspy.websocket.AddonSocketServer;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.listener.EventListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class NewObjectSpyDialog
extends Dialog
implements EventHandler,
HTMLElementCollector,
EventListener<ObjectSpyEvent> {
    private static final String DIA_BOUNDS_SET = "DIALOG_BOUNDS_SET";
    private static final Point MIN_SIZE = new Point(500, 720);
    private static final int CAPTURED_OBJECT_VIEW_MIN_SIZE = 100;
    private List<WebPage> pages;
    private Logger logger;
    private ToolBar mainToolbar;
    private ToolItem addPageElementToolItem;
    private ToolItem addFrameElementToolItem;
    private ToolItem addElementToolItem;
    private ToolItem removeElementToolItem;
    private ToolItem addElmtToObjRepoToolItem;
    private IEventBroker eventBroker;
    private boolean isDisposed;
    private ObjectSpyUrlView urlView;
    private CapturedObjectsView capturedObjectsView;
    private ObjectPropertiesView objectPropertiesView;
    private Shell shell;
    private ObjectVerifyAndHighlightView verifyView;
    private ObjectSpySelectorEditor selectorEditor;
    private Composite bodyComposite;

    public NewObjectSpyDialog(Shell parentShell, Logger logger, IEventBroker eventBroker) throws Exception {
        super(parentShell);
        boolean onTop = this.getPreferenceStore().getBoolean("objectspy.pinWindow");
        if (onTop && !"linux".equals(Platform.getOS())) {
            this.setShellStyle(16794864);
        } else {
            this.setShellStyle(16778480);
        }
        this.shell = this.getShell();
        this.logger = logger;
        this.eventBroker = eventBroker;
        eventBroker.subscribe("OBJECT_SPY/HTML_ELEMENT_CAPTURED", (EventHandler)this);
        eventBroker.subscribe("WORKSPACE/CLOSE", (EventHandler)this);
        this.isDisposed = false;
        this.pages = new ArrayList<WebPage>();
        this.startSocketServer();
    }

    private void startSocketServer() {
        try {
            new ProgressMonitorDialog(this.getParentShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(ObjectspyMessageConstants.MSG_DLG_INIT_OBJECT_SPY, 1);
                    AddonSocketServer.getInstance().start(AddonSocket.class, UtilitiesAddonUtil.getInstantBrowsersPort());
                }
            });
        }
        catch (InvocationTargetException e) {
            LoggerSingleton.logError((Throwable)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    protected Control createDialogArea(Composite parent) {
        this.bodyComposite = new Composite(parent, 0);
        this.bodyComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.bodyComposite.setLayout((Layout)new GridLayout(1, false));
        Composite toolbarComposite = new Composite(this.bodyComposite, 0);
        toolbarComposite.setLayout((Layout)new GridLayout());
        toolbarComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        this.urlView = new ObjectSpyUrlView(this);
        this.urlView.addStartBrowserToolbar(toolbarComposite);
        this.addElementTreeToolbar(toolbarComposite);
        this.createCapturedObjectsAndPropertiesView(this.bodyComposite);
        this.selectorEditor = new ObjectSpySelectorEditor();
        this.selectorEditor.createObjectSelectorEditor(this.bodyComposite);
        Composite bottomComposite = new Composite(this.bodyComposite, 0);
        GridLayout bottomLayout = new GridLayout(2, false);
        bottomLayout.marginHeight = 0;
        bottomLayout.marginWidth = 0;
        bottomComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        bottomComposite.setLayout((Layout)bottomLayout);
        this.verifyView = new ObjectVerifyAndHighlightView();
        this.verifyView.createVerifyAndHighlightView(bottomComposite, 768);
        this.addControlListeners();
        this.registerObjectSpyEventListeners();
        return this.bodyComposite;
    }

    private void registerObjectSpyEventListeners() {
        this.urlView.addListener(this.verifyView, Arrays.asList(ObjectSpyEvent.ADDON_SESSION_STARTED, ObjectSpyEvent.SELENIUM_SESSION_STARTED));
        this.capturedObjectsView.addListener(this.objectPropertiesView, Arrays.asList(ObjectSpyEvent.SELECTED_ELEMENT_CHANGED));
        this.capturedObjectsView.addListener(this, Arrays.asList(ObjectSpyEvent.SELECTED_ELEMENT_CHANGED));
        this.selectorEditor.addListener(this.verifyView, Arrays.asList(ObjectSpyEvent.SELECTOR_HAS_CHANGED));
        this.objectPropertiesView.addListener(this.selectorEditor, Arrays.asList(ObjectSpyEvent.ELEMENT_PROPERTIES_CHANGED));
        this.objectPropertiesView.addListener(this.verifyView, Arrays.asList(ObjectSpyEvent.ELEMENT_PROPERTIES_CHANGED));
        this.objectPropertiesView.addListener(this, Arrays.asList(ObjectSpyEvent.REQUEST_DIALOG_RESIZE));
    }

    private void createCapturedObjectsAndPropertiesView(Composite bodyComposite) {
        this.capturedObjectsView = new CapturedObjectsView(bodyComposite, 0, this.eventBroker);
        Sash sash = new Sash(bodyComposite, 256);
        GridData layoutData = new GridData(4, 128, true, false);
        sash.setLayoutData((Object)layoutData);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayout parentLayout = (GridLayout)NewObjectSpyDialog.this.capturedObjectsView.getParent().getLayout();
                int newHeight = e.y - ((NewObjectSpyDialog)NewObjectSpyDialog.this).capturedObjectsView.getBounds().y - parentLayout.verticalSpacing;
                if (newHeight < 100) {
                    e.doit = false;
                    return;
                }
                GridData gridData = (GridData)NewObjectSpyDialog.this.capturedObjectsView.getLayoutData();
                gridData.heightHint = newHeight;
                NewObjectSpyDialog.this.capturedObjectsView.getParent().layout();
            }
        });
        this.objectPropertiesView = new ObjectPropertiesView(bodyComposite, 0);
        this.capturedObjectsView.setInput(this.pages);
    }

    private void addControlListeners() {
        this.addPageElementToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebPage page = WebElementUtils.createWebPage();
                NewObjectSpyDialog.this.pages.add(page);
                NewObjectSpyDialog.this.capturedObjectsView.refreshTree(null);
                NewObjectSpyDialog.this.setSelectedTreeItem(page);
            }
        });
        this.addFrameElementToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = NewObjectSpyDialog.this.capturedObjectsView.getSelection();
                if (!(selection.getFirstElement() instanceof WebElement)) {
                    return;
                }
                WebFrame parent = NewObjectSpyDialog.this.getElementParent(selection);
                if (parent == null) {
                    return;
                }
                WebFrame webFrame = WebElementUtils.createWebFrame(parent);
                NewObjectSpyDialog.this.capturedObjectsView.refreshTree(parent);
                NewObjectSpyDialog.this.setSelectedTreeItem(webFrame);
            }
        });
        this.addElementToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = NewObjectSpyDialog.this.capturedObjectsView.getSelection();
                if (!(selection.getFirstElement() instanceof WebElement)) {
                    return;
                }
                WebFrame parent = NewObjectSpyDialog.this.getElementParent(selection);
                if (parent == null) {
                    return;
                }
                WebElement webElement = WebElementUtils.createWebElement(parent);
                NewObjectSpyDialog.this.capturedObjectsView.refreshTree(parent);
                NewObjectSpyDialog.this.setSelectedTreeItem(webElement);
            }
        });
        this.removeElementToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = NewObjectSpyDialog.this.capturedObjectsView.getSelection();
                Iterator iterator = selection.iterator();
                ArrayList<WebElement> removedElements = new ArrayList<WebElement>();
                while (iterator.hasNext()) {
                    WebElement webElement = (WebElement)iterator.next();
                    WebFrame parent = webElement.getParent();
                    removedElements.add(webElement);
                    if (webElement.getParent() == null) {
                        NewObjectSpyDialog.this.pages.remove(webElement);
                        continue;
                    }
                    int index = -1;
                    List<WebElement> children = parent.getChildren();
                    int i = 0;
                    while (i < children.size()) {
                        WebElement child = children.get(i);
                        if (child == webElement) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index < 0) continue;
                    children.remove(index);
                }
                NewObjectSpyDialog.this.removeElements(removedElements.toArray());
                NewObjectSpyDialog.this.objectPropertiesView.refreshTable(null);
            }
        });
        this.addElmtToObjRepoToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewObjectSpyDialog.this.addElementToObjectRepository(NewObjectSpyDialog.this.shell);
                }
                catch (Exception exception) {
                    NewObjectSpyDialog.this.logger.error((Throwable)exception);
                    MessageDialog.openError((Shell)NewObjectSpyDialog.this.shell, (String)StringConstants.ERROR_TITLE, (String)exception.getMessage());
                }
            }
        });
        this.objectPropertiesView.setRefreshCapturedObjectsTree(new Runnable(){

            @Override
            public void run() {
                NewObjectSpyDialog.this.capturedObjectsView.refreshTree(null);
            }
        });
    }

    private void removeElements(Object[] removedElements) {
        TreeViewer treeViewer = this.capturedObjectsView.getTreeViewer();
        treeViewer.getControl().setRedraw(false);
        Object[] expandedElements = treeViewer.getExpandedElements();
        treeViewer.remove(removedElements);
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            treeViewer.setExpandedState(element, true);
            ++n2;
        }
        treeViewer.getControl().setRedraw(true);
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    private void refreshTree(TreeViewer treeViewer, Object object) {
        treeViewer.getControl().setRedraw(false);
        Object[] expandedElements = treeViewer.getExpandedElements();
        if (object == null) {
            treeViewer.refresh();
        } else {
            treeViewer.refresh(object);
        }
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            treeViewer.setExpandedState(element, true);
            ++n2;
        }
        treeViewer.getControl().setRedraw(true);
    }

    private void setSelectedTreeItem(Object object) {
        TreeViewer treeViewer = this.capturedObjectsView.getTreeViewer();
        WebElementTreeContentProvider dataProvider = (WebElementTreeContentProvider)treeViewer.getContentProvider();
        treeViewer.setSelection((ISelection)new TreeSelection(dataProvider.getTreePath(object)), true);
        treeViewer.setExpandedState(object, true);
    }

    private WebFrame getElementParent(IStructuredSelection selection) {
        WebElement element = (WebElement)selection.getFirstElement();
        WebFrame parentElement = null;
        if (element instanceof WebFrame) {
            parentElement = (WebFrame)element;
        } else if (element.getParent() != null) {
            parentElement = element.getParent();
        }
        return parentElement;
    }

    private void addElementTreeToolbar(Composite explorerComposite) {
        this.mainToolbar = new ToolBar(explorerComposite, 0x820000);
        this.mainToolbar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addPageElementToolItem = new ToolItem(this.mainToolbar, 0);
        this.addPageElementToolItem.setImage(ImageConstants.IMG_24_NEW_PAGE_ELEMENT);
        this.addPageElementToolItem.setDisabledImage(ImageConstants.IMG_24_NEW_PAGE_ELEMENT_DISABLED);
        this.addPageElementToolItem.setText(StringConstants.DIA_TOOLITEM_NEW_PAGE);
        this.addPageElementToolItem.setToolTipText(StringConstants.DIA_TOOLITEM_TIP_NEW_PAGE_ELEMENT);
        this.addFrameElementToolItem = new ToolItem(this.mainToolbar, 0);
        this.addFrameElementToolItem.setImage(ImageConstants.IMG_24_NEW_FRAME_ELEMENT);
        this.addFrameElementToolItem.setDisabledImage(ImageConstants.IMG_24_NEW_FRAME_ELEMENT_DISABLED);
        this.addFrameElementToolItem.setText(StringConstants.DIA_TOOLITE_NEW_FRAME);
        this.addFrameElementToolItem.setToolTipText(StringConstants.DIA_TOOLITEM_TIP_NEW_FRAME_ELEMENT);
        this.addFrameElementToolItem.setEnabled(false);
        this.addElementToolItem = new ToolItem(this.mainToolbar, 0);
        this.addElementToolItem.setImage(ImageConstants.IMG_24_NEW_ELEMENT);
        this.addElementToolItem.setDisabledImage(ImageConstants.IMG_24_NEW_ELEMENT_DISABLED);
        this.addElementToolItem.setText(StringConstants.DIA_TOOLITEM_NEW_OBJECT);
        this.addElementToolItem.setToolTipText(StringConstants.DIA_TOOLITEM_TIP_NEW_ELEMENT);
        this.addElementToolItem.setEnabled(false);
        new ToolItem(this.mainToolbar, 2);
        this.removeElementToolItem = new ToolItem(this.mainToolbar, 0);
        this.removeElementToolItem.setImage(ImageConstants.IMG_24_DELETE);
        this.removeElementToolItem.setDisabledImage(ImageConstants.IMG_24_DELETE_DISABLED);
        this.removeElementToolItem.setText(StringConstants.DIA_TOOLITEM_DELETE);
        this.removeElementToolItem.setToolTipText(StringConstants.DIA_TOOLITEM_TIP_REMOVE_ELEMENT);
        this.removeElementToolItem.setEnabled(false);
        new ToolItem(this.mainToolbar, 2);
        this.addElmtToObjRepoToolItem = new ToolItem(this.mainToolbar, 0);
        this.addElmtToObjRepoToolItem.setImage(ImageConstants.IMG_24_ADD_TO_OBJECT_REPOSITORY);
        this.addElmtToObjRepoToolItem.setDisabledImage(ImageConstants.IMG_24_ADD_TO_OBJECT_REPOSITORY_DISABLED);
        this.addElmtToObjRepoToolItem.setText(StringConstants.DIA_TOOLITEM_TIP_ADD_ELEMENT_TO_OBJECT_REPO);
        this.addElmtToObjRepoToolItem.setToolTipText(StringConstants.DIA_TOOLITEM_TIP_ADD_ELEMENT_TO_OBJECT_REPO);
    }

    private List<WebPage> getCloneCapturedObjects(List<WebPage> pages) {
        return pages.stream().map(page -> page.softClone()).collect(Collectors.toList());
    }

    private void addElementToObjectRepository(Shell parentShell) throws Exception {
        TreeViewer capturedTreeViewer = this.capturedObjectsView.getTreeViewer();
        SaveToObjectRepositoryDialog addToObjectRepositoryDialog = new SaveToObjectRepositoryDialog(parentShell, true, this.getCloneCapturedObjects(this.pages), capturedTreeViewer.getExpandedElements());
        if (addToObjectRepositoryDialog.open() != 0) {
            return;
        }
        ObjectRepositoryService objectRepositoryService = new ObjectRepositoryService();
        ObjectRepositoryService.SaveActionResult saveResult = objectRepositoryService.saveObject(addToObjectRepositoryDialog.getDialogResult());
        Trackings.trackSaveSpy((String)"web", (int)saveResult.getSavedObjectCount());
        this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)addToObjectRepositoryDialog.getSelectedParentFolderResult());
        for (Object[] testObj : saveResult.getUpdatedTestObjectIds()) {
            this.eventBroker.post("TESTOBJECT/UPDATED", (Object)testObj);
        }
        if (saveResult.getNewSelectionOnExplorer() == null) {
            return;
        }
        this.selectSelectedElements(capturedTreeViewer, this.pages);
        this.eventBroker.post("EXPLORER/SET_SELECTED_ITEMS", (Object)saveResult.getNewSelectionOnExplorer().toArray());
    }

    private void selectSelectedElements(TreeViewer capturedTreeViewer, List<WebPage> htmlElements) {
        ArrayList selectedElements = new ArrayList();
        htmlElements.forEach(page -> {
            boolean bl = selectedElements.addAll(this.flatten((WebElement)page));
        });
        capturedTreeViewer.setSelection((ISelection)new StructuredSelection(selectedElements));
    }

    private List<WebElement> flatten(WebElement element) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        elements.add(element);
        if (element instanceof WebFrame) {
            WebFrame frame = (WebFrame)element;
            frame.getChildren().forEach(child -> {
                boolean bl = elements.addAll(this.flatten((WebElement)child));
            });
        }
        return elements;
    }

    private Collection<ITreeEntity> addCheckedElements(WebElement element, FolderTreeEntity parentTreeFolder, WebElementEntity refElement) throws Exception {
        FolderEntity parentFolder = parentTreeFolder.getObject();
        WebElementEntity importedElement = ObjectRepositoryController.getInstance().importWebElement(WebElementUtils.convertWebElementToTestObject(element, refElement, parentFolder), parentFolder);
        ArrayList<ITreeEntity> newTreeWebElements = new ArrayList<ITreeEntity>();
        newTreeWebElements.add((ITreeEntity)new WebElementTreeEntity(importedElement, (ITreeEntity)parentTreeFolder));
        if (element instanceof WebFrame) {
            for (WebElement childElement : ((WebFrame)element).getChildren()) {
                newTreeWebElements.addAll(this.addCheckedElements(childElement, parentTreeFolder, importedElement));
            }
        }
        return newTreeWebElements;
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.stop();
    }

    public void stop() {
        if (this.urlView != null) {
            this.urlView.stop();
        }
        this.eventBroker.unsubscribe((EventHandler)this);
        this.isDisposed = true;
    }

    protected Point getInitialSize() {
        IDialogSettings dialogBoundSettings = this.getDialogBoundsSettings();
        Point size = null;
        if (dialogBoundSettings.getBoolean(DIA_BOUNDS_SET)) {
            size = super.getInitialSize();
        } else {
            dialogBoundSettings.put(DIA_BOUNDS_SET, true);
            size = MIN_SIZE;
        }
        return size;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StringConstants.DIA_TITLE_OBJ_SPY);
    }

    public void addObjectsFromObjectRepository(Object[] selectedObjects) {
        WebPage generatingPageElement = null;
        HashMap<String, WebElement> generatingElementMap = new HashMap<String, WebElement>();
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            if (selectedObject instanceof WebElementEntity) {
                if (generatingPageElement == null) {
                    generatingPageElement = WebElementUtils.createWebPage();
                    this.pages.add(generatingPageElement);
                }
                WebElementUtils.createWebElementFromTestObject((WebElementEntity)selectedObject, false, generatingPageElement, generatingElementMap);
            } else if (selectedObject instanceof FolderEntity) {
                this.pages.addAll(WebElementUtils.createWebElementFromFolder((FolderEntity)selectedObject, generatingElementMap));
            }
            ++n2;
        }
        TreeViewer elementTreeViewer = this.capturedObjectsView.getTreeViewer();
        this.refreshTree(elementTreeViewer, null);
        elementTreeViewer.setSelection((ISelection)new StructuredSelection(generatingElementMap.values().toArray()));
    }

    private void setExpandForParentElement(WebFrame pageElement, TreeViewer capturedElementTreeViewer) {
        List<WebElement> childElements = pageElement.getChildren();
        if (childElements.isEmpty()) {
            return;
        }
        capturedElementTreeViewer.setExpandedState((Object)pageElement, true);
        for (WebElement element : childElements) {
            if (!(element instanceof WebFrame)) continue;
            this.setExpandForParentElement((WebFrame)element, capturedElementTreeViewer);
        }
    }

    private void addNewElement(WebFrame frame, WebElement element, WebFrame page) {
        List<WebElement> frameChildren = frame.getChildren();
        if (frameChildren.contains(element)) {
            if (!(element instanceof WebFrame)) {
                return;
            }
            WebFrame frameElement = (WebFrame)element;
            WebFrame existingFrameElement = (WebFrame)frameChildren.get(frameChildren.indexOf(element));
            this.addNewElement(existingFrameElement, frameElement.getChildren().get(0), page);
        } else {
            element.setParent(frame);
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        this.getShell().setMinimumSize(MIN_SIZE);
        return super.open();
    }

    public boolean close() {
        if (this.urlView != null) {
            this.urlView.save();
        }
        boolean result = super.close();
        Trackings.trackCloseSpy((String)"web");
        return result;
    }

    public void handleEvent(Event event) {
        String topic;
        Object dataObject = EventUtil.getData((Event)event);
        switch (topic = event.getTopic()) {
            case "OBJECT_SPY/HTML_ELEMENT_CAPTURED": {
                if (!(dataObject instanceof WebElement)) {
                    return;
                }
                this.addNewElement((WebElement)dataObject);
                return;
            }
            case "WORKSPACE/CLOSE": {
                this.cancelPressed();
                return;
            }
        }
    }

    private WebPage findPage(WebElement webElement) {
        if (webElement == null) {
            return null;
        }
        if (webElement instanceof WebPage) {
            return (WebPage)webElement;
        }
        WebFrame parent = webElement.getParent();
        if (parent == null) {
            return null;
        }
        return this.findPage(parent);
    }

    private int indexOf(List<WebElement> elements, WebElement frame) {
        int index = 0;
        while (index < elements.size()) {
            if (frame.isSameProperties(elements.get(index))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private WebFrame merge(WebFrame oldFrame, WebFrame newFrame) {
        List<WebElement> oldChildren = oldFrame.getChildren();
        newFrame.getChildren().forEach(newChild -> {
            int index = this.indexOf(oldChildren, (WebElement)newChild);
            if (index < 0) {
                newChild.setParent(oldFrame);
                return;
            }
            if (newChild.getType() == WebElement.WebElementType.ELEMENT) {
                return;
            }
            WebFrame oldChildFrame = (WebFrame)oldChildren.get(index);
            WebFrame mergedChildFrame = this.merge(oldChildFrame, (WebFrame)newChild);
            oldChildren.remove(index);
            oldChildren.add(index, mergedChildFrame);
            mergedChildFrame.setParentOnly(oldFrame);
        });
        return oldFrame;
    }

    @Override
    public void addNewElement(WebElement newElement) {
        if (newElement == null || newElement.getParent() == null) {
            return;
        }
        final WebPage pageOfElement = this.findPage(newElement);
        if (this.pages.contains(pageOfElement)) {
            int index = this.pages.indexOf(pageOfElement);
            WebPage oldPage = this.pages.get(index);
            WebPage newPage = (WebPage)this.merge(oldPage, pageOfElement);
            this.pages.remove(index);
            this.pages.add(index, newPage);
        } else {
            this.pages.add(pageOfElement);
        }
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                TreeViewer capturedElementTreeViewer = NewObjectSpyDialog.this.capturedObjectsView.getTreeViewer();
                NewObjectSpyDialog.this.refreshTree(capturedElementTreeViewer, null);
                NewObjectSpyDialog.this.setExpandForParentElement(pageOfElement, capturedElementTreeViewer);
            }
        });
    }

    private ScopedPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.webui.objectspy");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogBoundSettings(this.getClass());
    }

    public void handleEvent(ObjectSpyEvent event, Object object) {
        switch (event) {
            case SELECTED_ELEMENT_CHANGED: {
                this.addElementToolItem.setEnabled(object instanceof WebElement);
                this.addFrameElementToolItem.setEnabled(object instanceof WebElement);
                this.removeElementToolItem.setEnabled(object instanceof WebElement);
                return;
            }
            case REQUEST_DIALOG_RESIZE: {
                Shell shell = this.getShell();
                shell.setSize(shell.getSize().x, this.getInitialSize().y);
                return;
            }
        }
    }
}

