/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.objectspy.constants.ImageConstants;
import com.kms.katalon.objectspy.constants.StringConstants;
import com.kms.katalon.objectspy.dialog.ObjectSpyEvent;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebFrame;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.tree.WebElementLabelProvider;
import com.kms.katalon.objectspy.element.tree.WebElementTreeContentProvider;
import com.kms.katalon.util.listener.EventListener;
import com.kms.katalon.util.listener.EventManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolTip;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CapturedObjectsView
extends Composite
implements EventHandler,
EventManager<ObjectSpyEvent> {
    private TreeViewer treeViewer;
    private WebElement selectedObject;
    private Label lblInfo;
    private ToolTip infoTooltip;
    private IEventBroker eventBroker;
    private Map<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>> eventListeners = new HashMap<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>>();

    public CapturedObjectsView(Composite parent, int style, IEventBroker eventBroker) {
        super(parent, style);
        this.eventBroker = eventBroker;
        this.setLayoutAndLayoutData();
        this.createControls();
        this.addControlListeners();
        this.subscribeEvents();
    }

    private void setLayoutAndLayoutData() {
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.setLayout((Layout)mainLayout);
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.heightHint = 150;
        this.setLayoutData(layoutData);
    }

    private void createControls() {
        Composite capturedObjectsComposite = new Composite((Composite)this, 0);
        capturedObjectsComposite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        GridLayout glCapturedObjectsComposite = new GridLayout(2, false);
        glCapturedObjectsComposite.marginWidth = 0;
        glCapturedObjectsComposite.marginHeight = 0;
        capturedObjectsComposite.setLayout((Layout)glCapturedObjectsComposite);
        Label lblCapturedObjects = new Label(capturedObjectsComposite, 0);
        lblCapturedObjects.setFont(ControlUtils.getFontBold((Control)lblCapturedObjects));
        lblCapturedObjects.setText(StringConstants.DIA_LBL_CAPTURED_OBJECTS);
        this.lblInfo = new Label(capturedObjectsComposite, 0);
        GridData gdLblInfo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdLblInfo.heightHint = 16;
        this.lblInfo.setLayoutData((Object)gdLblInfo);
        this.lblInfo.setImage(ImageConstants.IMG_16_HELP);
        this.infoTooltip = new ToolTip(this.getShell(), 4096);
        this.infoTooltip.setMessage(StringConstants.TOOLTIP_CAPTURED_OBJECTS_HELP);
        this.treeViewer = new TreeViewer((Composite)this, 2050);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setContentProvider((IContentProvider)new WebElementTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WebElementLabelProvider());
    }

    private void addControlListeners() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof TreeSelection)) {
                    return;
                }
                TreeSelection treeSelection = (TreeSelection)event.getSelection();
                Object selection = treeSelection.getFirstElement();
                if (!(selection instanceof WebElement)) {
                    return;
                }
                CapturedObjectsView.this.invoke((Object)ObjectSpyEvent.SELECTED_ELEMENT_CHANGED, selection);
            }
        });
        this.treeViewer.addDragSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            private boolean isDragable(IStructuredSelection selection) {
                if (selection == null) {
                    return false;
                }
                List webElements = selection.toList();
                Optional<WebElement> optionalWebPage = webElements.stream().filter(element -> element instanceof WebPage).findFirst();
                return !optionalWebPage.isPresent();
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CapturedObjectsView.this.treeViewer.getSelection();
                if (!this.isDragable(selection)) {
                    event.detail = 0;
                    event.doit = false;
                    return;
                }
                LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
                if (transfer.isSupportedType(event.dataType)) {
                    transfer.setSelection((ISelection)selection);
                    transfer.setSelectionSetTime((long)(event.time & 0xFFFF));
                }
            }
        });
        this.treeViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.treeViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target == null) {
                    return false;
                }
                LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
                return this.getCurrentLocation() == 3 && target instanceof WebElement && transfer.isSupportedType(transferType);
            }

            public boolean performDrop(Object data) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                if (selection == null) {
                    return false;
                }
                List webElements = selection.toList();
                WebElement target = (WebElement)this.getCurrentTarget();
                WebFrame parent = null;
                parent = target.getType() == WebElement.WebElementType.ELEMENT ? target.getParent() : (WebFrame)target;
                for (WebElement element : webElements) {
                    WebElement newWebElement = element.softClone();
                    newWebElement.setParent(parent);
                    CapturedObjectsView.this.eventBroker.send("RECORDER/ACTION_OBJECT_REORDERED", (Object)new WebElement[]{element, newWebElement});
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                for (WebElement element : webElements) {
                    element.getParent().getChildren().remove(element);
                }
                CapturedObjectsView.this.treeViewer.refresh();
                LocalSelectionTransfer.getTransfer().setSelection(null);
                return true;
            }
        });
        this.lblInfo.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                Point location = e.display.getCursorLocation();
                CapturedObjectsView.this.infoTooltip.setVisible(true);
                CapturedObjectsView.this.infoTooltip.setLocation(location.x, location.y - e.y + ((CapturedObjectsView)CapturedObjectsView.this).lblInfo.getSize().y);
            }

            public void mouseExit(MouseEvent e) {
                CapturedObjectsView.this.infoTooltip.setVisible(false);
            }
        });
    }

    private void setTreeDataInput(Object input) {
        if (this.treeViewer != null && ControlUtils.isReady((Control)this.treeViewer.getControl())) {
            this.treeViewer.setInput(input);
        }
    }

    public void setInput(List<WebPage> input) {
        this.setTreeDataInput(input);
    }

    public WebElement getSelectedObject() {
        return this.selectedObject;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public IStructuredSelection getSelection() {
        return this.treeViewer.getStructuredSelection();
    }

    public void refreshTree(Object object) {
        this.treeViewer.getControl().setRedraw(false);
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        this.treeViewer.refresh(object);
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.treeViewer.setExpandedState(element, true);
            ++n2;
        }
        this.treeViewer.getControl().setRedraw(true);
    }

    private void subscribeEvents() {
        this.eventBroker.subscribe("RECORDER/ACTION_SELECTED", (EventHandler)this);
    }

    private void unsubscribeEvents() {
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    public void dispose() {
        this.unsubscribeEvents();
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public Iterable<EventListener<ObjectSpyEvent>> getListeners(ObjectSpyEvent event) {
        return this.eventListeners.get((Object)event);
    }

    public void addListener(EventListener<ObjectSpyEvent> listener, Iterable<ObjectSpyEvent> events) {
        events.forEach(e -> {
            Set<EventListener<ObjectSpyEvent>> listenerOnEvent = this.eventListeners.get(e);
            if (listenerOnEvent == null) {
                listenerOnEvent = new HashSet<EventListener<ObjectSpyEvent>>();
            }
            listenerOnEvent.add(listener);
            this.eventListeners.put((ObjectSpyEvent)((Object)e), listenerOnEvent);
        });
    }

    public void handleEvent(Event event) {
        String eventType = event.getTopic();
        if (eventType == "RECORDER/ACTION_SELECTED") {
            WebElement selectedElement = (WebElement)event.getProperty("org.eclipse.e4.data");
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)selectedElement), true);
        }
    }

    public List<WebElement> flattenWebElements() {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (WebPage page : (List)this.treeViewer.getInput()) {
            elements.addAll(this.fattenElements(page));
        }
        return elements;
    }

    private List<WebElement> fattenElements(WebElement element) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        elements.add(element);
        if (element instanceof WebFrame) {
            WebFrame frame = (WebFrame)element;
            frame.getChildren().forEach(child -> {
                boolean bl = elements.addAll(this.fattenElements((WebElement)child));
            });
        }
        return elements;
    }
}

