/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.providers.EntityLabelProvider;
import com.kms.katalon.composer.explorer.providers.EntityProvider;
import com.kms.katalon.composer.explorer.providers.EntityViewerFilter;
import com.kms.katalon.composer.explorer.providers.FolderProvider;
import com.kms.katalon.composer.folder.dialogs.NewFolderDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.objectspy.constants.StringConstants;
import com.kms.katalon.objectspy.element.HTMLElement;
import com.kms.katalon.objectspy.element.HTMLFrameElement;
import com.kms.katalon.objectspy.element.HTMLPageElement;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.tree.CheckboxTreeSelectionHelper;
import com.kms.katalon.objectspy.element.tree.HTMLElementLabelProvider;
import com.kms.katalon.objectspy.element.tree.HTMLElementTreeContentProvider;
import com.kms.katalon.objectspy.util.WebElementUtils;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class AddToObjectRepositoryDialog
extends TreeEntitySelectionDialog {
    private int fWidth = 60;
    private int fHeight = 18;
    private TreeViewer treeViewer;
    private boolean isCheckable;
    private TreeViewer htmlElementTreeViewer;
    private FolderEntity rootFolderEntity;
    private FolderTreeEntity rootFolderTreeEntity;
    private List<HTMLPageElement> htmlElements;
    private Button btnPageAsFolder;
    private ScopedPreferenceStore store;
    private boolean modified;
    private boolean createFolderAsPageNameAllowed;
    private SashForm form;

    public AddToObjectRepositoryDialog(Shell parentShell, boolean isCheckable, List<HTMLPageElement> htmlElements, Object[] expandedHTMLElements) {
        super(parentShell, (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new FolderProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter((EntityProvider)new FolderProvider()));
        this.isCheckable = isCheckable;
        this.htmlElements = htmlElements;
        this.store = PreferenceStoreManager.getPreferenceStore(((Object)((Object)this)).getClass());
        this.setShellStyle(67696);
        this.setTitle(StringConstants.TITLE_ADD_TO_OBJECT_DIALOG);
        this.setAllowMultiple(false);
        this.refresh();
    }

    private void refresh() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject != null) {
            try {
                this.rootFolderEntity = FolderController.getInstance().getObjectRepositoryRoot(currentProject);
                this.rootFolderTreeEntity = new FolderTreeEntity(this.rootFolderEntity, null);
                this.setInput(new Object[]{this.rootFolderTreeEntity});
                this.setInitialSelection(this.rootFolderTreeEntity);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MessageDialog.openError((Shell)this.getParentShell(), (String)StringConstants.ERROR, (String)e.getMessage());
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createMainDialogArea(parent);
        this.form = new SashForm(composite, 256);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createLeftPanel((Composite)this.form);
        this.createRightPanel((Composite)this.form);
        this.updateInput();
        this.registerControlModifyListeners();
        return composite;
    }

    private Composite createMainDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        AddToObjectRepositoryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateInput() {
        this.createFolderAsPageNameAllowed = this.store.getBoolean("objectspy.addToObjectSpyDialog.createFolderAsPageName");
        this.btnPageAsFolder.setSelection(this.createFolderAsPageNameAllowed);
        this.modified = false;
    }

    private void registerControlModifyListeners() {
        this.btnPageAsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddToObjectRepositoryDialog.this.createFolderAsPageNameAllowed = AddToObjectRepositoryDialog.this.btnPageAsFolder.getSelection();
                AddToObjectRepositoryDialog.this.store.setValue("objectspy.addToObjectSpyDialog.createFolderAsPageName", AddToObjectRepositoryDialog.this.createFolderAsPageNameAllowed);
                AddToObjectRepositoryDialog.this.modified = true;
            }
        });
    }

    private void createRightPanel(Composite parent) {
        Composite objectRepositoryComposite = new Composite(parent, 0);
        Label label = new Label(objectRepositoryComposite, 0);
        label.setText(StringConstants.DIA_LBL_SELECT_A_DESTINATION_FOLDER);
        label.setLayoutData((Object)new GridData(256));
        this.treeViewer = this.createTreeViewer(objectRepositoryComposite);
        this.treeViewer.expandToLevel((Object)this.rootFolderTreeEntity, 1);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree treeWidget = this.treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        treeWidget.setEnabled(true);
    }

    private void createLeftPanel(Composite parent) {
        Composite htmlObjectTreeComposite = new Composite(parent, 0);
        GridLayout gl_htmlObjectComposite = new GridLayout();
        gl_htmlObjectComposite.marginTop = 5;
        gl_htmlObjectComposite.marginBottom = 5;
        gl_htmlObjectComposite.horizontalSpacing = 0;
        gl_htmlObjectComposite.marginWidth = 0;
        gl_htmlObjectComposite.marginHeight = 0;
        htmlObjectTreeComposite.setLayout((Layout)gl_htmlObjectComposite);
        this.btnPageAsFolder = new Button(htmlObjectTreeComposite, 32);
        this.btnPageAsFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnPageAsFolder.setText(StringConstants.DIA_CHCK_BTN_CREATE_FOLDER_AS_PAGE_NAME);
        HTMLElementTreeContentProvider contentProvider = new HTMLElementTreeContentProvider();
        CheckboxTreeSelectionHelper checkboxSelectionHelper = null;
        if (this.isCheckable) {
            this.htmlElementTreeViewer = new CheckboxTreeViewer(htmlObjectTreeComposite, 2050);
            checkboxSelectionHelper = CheckboxTreeSelectionHelper.attach((CheckboxTreeViewer)this.htmlElementTreeViewer, contentProvider);
        } else {
            this.htmlElementTreeViewer = new TreeViewer(htmlObjectTreeComposite, 2050);
        }
        this.htmlElementTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.htmlElementTreeViewer.setContentProvider((IContentProvider)contentProvider);
        this.htmlElementTreeViewer.setLabelProvider((IBaseLabelProvider)new HTMLElementLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.htmlElementTreeViewer, (int)2);
        this.htmlElementTreeViewer.setInput(this.htmlElements);
        this.htmlElementTreeViewer.expandAll();
        if (checkboxSelectionHelper != null) {
            checkboxSelectionHelper.checkAllItemInTree(this.htmlElements);
        }
    }

    private void refreshTreeEntity(Object object) {
        this.treeViewer.getControl().setRedraw(false);
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        if (object == null) {
            this.treeViewer.refresh();
        } else {
            this.treeViewer.refresh(object);
        }
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.treeViewer.setExpandedState(element, true);
            ++n2;
        }
        this.treeViewer.getControl().setRedraw(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btnNewFolder = this.createButton(parent, 22, StringConstants.DIA_BTN_ADD_NEW_FOLDER, false);
        btnNewFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedObject = AddToObjectRepositoryDialog.this.getFirstResult();
                if (selectedObject == null) {
                    selectedObject = AddToObjectRepositoryDialog.this.rootFolderTreeEntity;
                }
                try {
                    FolderEntity newEntity;
                    FolderEntity parentFolder = ((FolderTreeEntity)selectedObject).getObject();
                    String suggestedName = FolderController.getInstance().getAvailableFolderName(parentFolder, StringConstants.NEW_FOLDER_DEFAULT_NAME);
                    NewFolderDialog newFolderDialog = new NewFolderDialog(AddToObjectRepositoryDialog.this.getParentShell(), parentFolder);
                    newFolderDialog.setName(suggestedName);
                    newFolderDialog.open();
                    if (newFolderDialog.getReturnCode() == 0 && (newEntity = FolderController.getInstance().addNewFolder(parentFolder, newFolderDialog.getName())) != null) {
                        FolderTreeEntity newFolderTreeEntity = TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)newEntity, (FolderEntity)AddToObjectRepositoryDialog.this.rootFolderEntity);
                        AddToObjectRepositoryDialog.this.refreshTreeEntity(selectedObject);
                        AddToObjectRepositoryDialog.this.treeViewer.expandToLevel(selectedObject, 1);
                        AddToObjectRepositoryDialog.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newFolderTreeEntity));
                    }
                }
                catch (Exception exception) {
                    LoggerSingleton.logError((Throwable)exception);
                    MessageDialog.openError((Shell)AddToObjectRepositoryDialog.this.getParentShell(), (String)StringConstants.ERROR, (String)exception.getMessage());
                }
            }
        });
        Button okButton = this.createButton(parent, 55, IDialogConstants.OK_LABEL, false);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(AddToObjectRepositoryDialog.this.getFirstResult() instanceof FolderTreeEntity)) {
                    MessageDialog.openWarning((Shell)AddToObjectRepositoryDialog.this.getParentShell(), (String)StringConstants.WARN, (String)StringConstants.DIA_MSG_PLS_SELECT_A_FOLDER);
                    return;
                }
                if (AddToObjectRepositoryDialog.this.isCheckable) {
                    Object[] checkedHTMLElements = ((CheckboxTreeViewer)AddToObjectRepositoryDialog.this.htmlElementTreeViewer).getCheckedElements();
                    if (checkedHTMLElements == null || checkedHTMLElements.length <= 0) {
                        MessageDialog.openWarning((Shell)AddToObjectRepositoryDialog.this.getParentShell(), (String)StringConstants.WARN, (String)StringConstants.DIA_MSG_PLS_SELECT_ELEMENT);
                        return;
                    }
                    AddToObjectRepositoryDialog.this.removeUncheckedElements(AddToObjectRepositoryDialog.this.htmlElements);
                }
                AddToObjectRepositoryDialog.this.setReturnCode(0);
                AddToObjectRepositoryDialog.this.close();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void updatePreferenceStore() {
        if (this.modified) {
            try {
                this.store.save();
            }
            catch (IOException ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        }
    }

    public boolean close() {
        this.updatePreferenceStore();
        return super.close();
    }

    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    private void removeUncheckedElements(List<? extends HTMLElement> elementList) {
        int i = 0;
        while (i < elementList.size()) {
            HTMLElement childElement = elementList.get(i);
            if (!((CheckboxTreeViewer)this.htmlElementTreeViewer).getChecked((Object)childElement) && !((CheckboxTreeViewer)this.htmlElementTreeViewer).getGrayed((Object)childElement)) {
                elementList.remove(i);
                continue;
            }
            if (childElement instanceof HTMLFrameElement) {
                this.removeUncheckedElements(((HTMLFrameElement)childElement).getChildElements());
            }
            ++i;
        }
    }

    public List<HTMLPageElement> getHtmlElements() {
        return this.htmlElements;
    }

    public AddToObjectRepositoryDialogResult getDialogResult() {
        return new AddToObjectRepositoryDialogResult((FolderTreeEntity)this.getFirstResult(), this.createFolderAsPageNameAllowed);
    }

    public class AddToObjectRepositoryDialogResult {
        private final boolean createFolderAsPageNameAllowed;
        private final FolderTreeEntity selectedParentFolder;

        public AddToObjectRepositoryDialogResult(FolderTreeEntity selectedParentFolder, boolean createFolderAsPageNameAllowed) {
            this.createFolderAsPageNameAllowed = createFolderAsPageNameAllowed;
            this.selectedParentFolder = selectedParentFolder;
        }

        public FolderTreeEntity getSelectedParentFolder() {
            return this.selectedParentFolder;
        }

        public FolderTreeEntity createTreeFolderForPageElement(WebPage pageElement) throws Exception {
            if (this.createFolderAsPageNameAllowed) {
                return new FolderTreeEntity(this.createFolderForPageElement(pageElement), (ITreeEntity)this.selectedParentFolder);
            }
            return this.selectedParentFolder;
        }

        public FolderEntity createFolderForPageElement(WebPage pageElement) throws Exception {
            FolderEntity parentFolder = this.getSelectedParentFolder().getObject();
            return this.createFolderAsPageNameAllowed ? this.newPageWebElementAsFolder(parentFolder, pageElement) : parentFolder;
        }

        private FolderEntity newPageWebElementAsFolder(FolderEntity parentFolder, WebPage pageElement) throws Exception {
            return WebElementUtils.convertWebPageToFolder(pageElement, parentFolder);
        }
    }
}

