/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.core;

import com.google.gson.Gson;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.core.util.internal.ZipUtil;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IExecutionSetting;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.objectspy.constants.StringConstants;
import com.kms.katalon.objectspy.core.HTMLElementCaptureServer;
import com.kms.katalon.objectspy.exception.BrowserNotSupportedException;
import com.kms.katalon.objectspy.exception.ExtensionNotFoundException;
import com.kms.katalon.objectspy.preferences.ObjectSpyPreferences;
import com.kms.katalon.objectspy.util.FileUtil;
import com.kms.katalon.objectspy.websocket.AddonHotKeyData;
import com.kms.katalon.objectspy.websocket.AddonSocket;
import com.kms.katalon.objectspy.websocket.AddonSocketServer;
import com.kms.katalon.objectspy.websocket.messages.StartInspectAddonMessage;
import com.kms.katalon.selenium.driver.CFirefoxDriver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.osgi.framework.FrameworkUtil;

public class InspectSession
implements Runnable {
    private static final String HTTP = "http";
    private static final String ABOUT_BLANK = "about:blank";
    public static final String OBJECT_SPY_ADD_ON_NAME = "Object Spy";
    protected static final String LOAD_EXTENSION_CHROME_PREFIX = "load-extension=";
    private static final String VARIABLE_INIT_EXPRESSION_FOR_CHROME = "katalonServerPort = ''{0}''\r\nkatalonOnOffStatus = true\r\nspy_captureObjectHotKey = {1};\r\nspy_loadDomMapHotKey = {2};\r\n";
    private static final String VARIABLE_INIT_FILE_FOR_CHROME = "chrome_variables_init.js";
    private static final String SERVER_URL_FILE_NAME = "serverUrl.txt";
    private static final String OBJECT_SPY_APPLICATION_DATA_FOLDER = String.valueOf(System.getProperty("user.home")) + File.separator + "AppData" + File.separator + "Local" + File.separator + "KMS" + File.separator + "qAutomate" + File.separator + "ObjectSpy";
    protected static final String IE_ADDON_BHO_KEY = "{8CB0FB3A-8EFA-4F94-B605-F3427688F8C7}";
    protected static final String IE_ABSOLUTE_PATH = "C:\\Program Files\\Internet Explorer\\iexplore.exe";
    protected static final String IE_32BIT_ABSOLUTE_PATH = "C:\\Program Files (x86)\\Internet Explorer\\iexplore.exe";
    protected static final String CHROME_EXTENSION_RELATIVE_PATH = String.valueOf(File.separator) + "Chrome" + File.separator + "Object Spy" + File.separator + "KR";
    protected static final String FIREFOX_ADDON_RELATIVE_PATH = String.valueOf(File.separator) + "Firefox" + File.separator + "objectspy.xpi";
    protected static final String FIREFOX_ADDON_FOLDER_RELATIVE_PATH = String.valueOf(File.separator) + "Firefox" + File.separator + "objectspy";
    protected String projectDir;
    protected boolean isRunFlag;
    protected WebDriver driver;
    protected Object options;
    protected WebUIDriverType webUiDriverType;
    protected HTMLElementCaptureServer server;
    private String startUrl;
    private boolean driverStarted = false;
    private IDriverConnector driverConnector;

    public InspectSession(HTMLElementCaptureServer server, IDriverConnector driverConnector, String startUrl) {
        this.server = server;
        this.driverConnector = driverConnector;
        this.webUiDriverType = (WebUIDriverType)driverConnector.getDriverType();
        this.startUrl = startUrl;
        this.isRunFlag = true;
    }

    public InspectSession(HTMLElementCaptureServer server, IDriverConnector driverConnector) {
        this(server, driverConnector, null);
    }

    protected void setUp() throws IOException, ExtensionNotFoundException, BrowserNotSupportedException {
        DefaultExecutionSetting executionSetting = new DefaultExecutionSetting();
        executionSetting.setTimeout(ExecutionUtil.getDefaultImplicitTimeout());
        HashMap<String, IDriverConnector> driverConnectors = new HashMap<String, IDriverConnector>(1);
        driverConnectors.put("WebUI", this.driverConnector);
        RunConfiguration.setExecutionSetting((Map)ExecutionUtil.getExecutionProperties((IExecutionSetting)executionSetting, driverConnectors, null));
        this.options = this.createDriverOptions(this.webUiDriverType);
        if (this.webUiDriverType == WebUIDriverType.IE_DRIVER) {
            this.setupIE();
        }
    }

    @Override
    public void run() {
        try {
            this.setUp();
        }
        catch (BrowserNotSupportedException | ExtensionNotFoundException | IOException e) {
            LoggerSingleton.logError((Throwable)e);
            InspectSession.showErrorMessageDialog(e.getMessage());
        }
        this.runSeleniumWebDriver();
    }

    public void setupIE() throws IOException {
        File settingFolder = new File(this.getIEApplicationDataFolder());
        if (!settingFolder.exists()) {
            settingFolder.mkdirs();
        }
        File serverSettingFile = new File(this.getIEApplicationServerSettingFile());
        FileUtils.writeStringToFile((File)serverSettingFile, (String)this.server.getServerUrl());
    }

    protected String getIEApplicationServerSettingFile() {
        return String.valueOf(this.getIEApplicationDataFolder()) + File.separator + SERVER_URL_FILE_NAME;
    }

    protected String getIEApplicationDataFolder() {
        return OBJECT_SPY_APPLICATION_DATA_FOLDER;
    }

    protected void runSeleniumWebDriver() {
        try {
            try {
                HttpPost httpPost;
                CloseableHttpClient client;
                URL geckoDriverServiceUrl;
                CFirefoxDriver firefoxDriver;
                Thread.sleep(5L);
                this.driver = DriverFactory.openWebDriver((DriverType)this.webUiDriverType, (Object)this.options);
                this.driverStarted = true;
                if (this.webUiDriverType == WebUIDriverType.FIREFOX_DRIVER) {
                    firefoxDriver = (CFirefoxDriver)this.driver;
                    geckoDriverServiceUrl = firefoxDriver.getGeckoDriverService().getUrl();
                    client = HttpClientBuilder.create().build();
                    httpPost = new HttpPost(String.valueOf(geckoDriverServiceUrl.toString()) + "/session/" + ((RemoteWebDriver)this.driver).getSessionId() + "/moz/addon/install");
                    String bodyContent = String.format("{\"path\": \"%s\"}", StringEscapeUtils.escapeJava((String)this.getFirefoxAddonFile().getAbsolutePath()));
                    httpPost.setEntity((HttpEntity)new StringEntity(bodyContent));
                    client.execute((HttpUriRequest)httpPost);
                    this.handleForFirefoxAddon();
                }
                if (StringUtils.isNotEmpty((String)this.startUrl)) {
                    try {
                        this.driver.navigate().to(PathUtil.getUrl((String)this.startUrl, (String)HTTP));
                    }
                    catch (MalformedURLException | URISyntaxException | InvalidPathException exception) {}
                }
                if (this.webUiDriverType == WebUIDriverType.FIREFOX_DRIVER) {
                    firefoxDriver = (CFirefoxDriver)this.driver;
                    geckoDriverServiceUrl = firefoxDriver.getGeckoDriverService().getUrl();
                    client = HttpClientBuilder.create().build();
                    httpPost = new HttpPost(String.valueOf(geckoDriverServiceUrl.toString()) + "/session/" + ((RemoteWebDriver)this.driver).getSessionId() + "/moz/addon/install");
                    httpPost.setEntity((HttpEntity)new StringEntity(String.format("{\"path\": \"%s\"}", this.getFirefoxAddonFile().getAbsolutePath())));
                    client.execute((HttpUriRequest)httpPost);
                    this.handleForFirefoxAddon();
                }
                while (this.isRunFlag) {
                    try {
                        Thread.sleep(1000L);
                        if (this.driver == null) break;
                        if (this.driver.getTitle() == null) {
                            break;
                        }
                        this.driver.getWindowHandle();
                    }
                    catch (NoSuchWindowException noSuchWindowException) {
                        break;
                    }
                    catch (UnreachableBrowserException unreachableBrowserException) {
                        break;
                    }
                    catch (WebDriverException e) {
                        if (!e.getMessage().startsWith("chrome not reachable")) continue;
                        break;
                    }
                }
            }
            catch (WebDriverException e) {
                InspectSession.showErrorMessageDialog(e.getMessage());
                this.dispose();
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                InspectSession.showErrorMessageDialog(e.getMessage());
                this.dispose();
            }
        }
        finally {
            this.dispose();
        }
    }

    protected void handleForFirefoxAddon() throws InterruptedException {
        AddonSocketServer socketServer = AddonSocketServer.getInstance();
        while (socketServer.getAddonSocketByBrowserName(this.webUiDriverType.toString()) == null && this.isRunFlag) {
            Thread.sleep(500L);
        }
        AddonSocket firefoxAddonSocket = socketServer.getAddonSocketByBrowserName(this.webUiDriverType.toString());
        firefoxAddonSocket.sendMessage(new StartInspectAddonMessage());
    }

    public boolean isDriverStarted() {
        return this.driverStarted;
    }

    private static void showErrorMessageDialog(final String message) {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)message);
            }
        });
    }

    protected Object createDriverOptions(WebUIDriverType driverType) throws IOException, ExtensionNotFoundException, BrowserNotSupportedException {
        DesiredCapabilities capabilities = WebDriverPropertyUtil.toDesireCapabilities((Map)RunConfiguration.getDriverPreferencesProperties((String)"WebUI"), (WebUIDriverType)driverType);
        switch (driverType) {
            case CHROME_DRIVER: {
                return this.createChromDriverOptions(capabilities);
            }
            case IE_DRIVER: {
                return this.createIEDesiredCapabilities(capabilities);
            }
        }
        return capabilities;
    }

    private DesiredCapabilities createIEDesiredCapabilities(DesiredCapabilities capabilities) {
        capabilities.setCapability("initialBrowserUrl", ABOUT_BLANK);
        return capabilities;
    }

    protected FirefoxProfile createFireFoxProfile() throws IOException {
        FirefoxProfile firefoxProfile = WebDriverPropertyUtil.createDefaultFirefoxProfile();
        firefoxProfile.addExtension(this.getFirefoxAddonFile());
        return firefoxProfile;
    }

    protected DesiredCapabilities createChromDriverOptions(DesiredCapabilities capabilities) throws IOException, ExtensionNotFoundException {
        File chromeExtensionFolder = this.getChromeExtensionFile();
        if (chromeExtensionFolder == null || !chromeExtensionFolder.isDirectory() || !chromeExtensionFolder.exists()) {
            throw new ExtensionNotFoundException(this.getChromeExtensionPath(), WebUIDriverType.CHROME_DRIVER);
        }
        this.generateVariableInitFileForChrome(chromeExtensionFolder);
        WebDriverPropertyUtil.removeArgumentsForChrome((DesiredCapabilities)capabilities, (String[])new String[]{"--disable-extensions"});
        WebDriverPropertyUtil.addArgumentsForChrome((DesiredCapabilities)capabilities, (String[])new String[]{LOAD_EXTENSION_CHROME_PREFIX + chromeExtensionFolder.getCanonicalPath()});
        return capabilities;
    }

    private void generateVariableInitFileForChrome(File chromeExtensionFolder) throws IOException {
        File variableInitJSFile = new File(String.valueOf(chromeExtensionFolder.getAbsolutePath()) + File.separator + VARIABLE_INIT_FILE_FOR_CHROME);
        AddonHotKeyData captureObjectHotKey = AddonHotKeyData.buildFrom(ObjectSpyPreferences.getCaptureObjectHotKey());
        AddonHotKeyData loadDomMapHotKey = AddonHotKeyData.buildFrom(ObjectSpyPreferences.getLoadDomMapHotKey());
        Gson gson = new Gson();
        FileUtils.writeStringToFile((File)variableInitJSFile, (String)MessageFormat.format(VARIABLE_INIT_EXPRESSION_FOR_CHROME, String.valueOf(this.server.getServerPort()), gson.toJson((Object)captureObjectHotKey), gson.toJson((Object)loadDomMapHotKey)), (Charset)Charset.defaultCharset());
    }

    protected File getChromeExtensionFile() throws IOException {
        File chromeExtension = null;
        File extensionFolder = FileUtil.getExtensionsDirectory(FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            chromeExtension = new File(String.valueOf(extensionFolder.getAbsolutePath()) + this.getChromeExtensionPath());
        }
        return chromeExtension;
    }

    protected File getFirefoxAddonExtractedFolder() throws IOException {
        File extensionFolder = FileUtil.getExtensionsDirectory(FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            File firefoxExtensionFolder = FileUtil.getExtensionBuildFolder();
            File firefoxAddonExtracted = new File(firefoxExtensionFolder, FIREFOX_ADDON_FOLDER_RELATIVE_PATH);
            if (firefoxAddonExtracted.exists()) {
                FileUtils.cleanDirectory((File)firefoxAddonExtracted);
            }
            File firefoxAddon = new File(String.valueOf(extensionFolder.getAbsolutePath()) + this.getFirefoxExtensionPath());
            ZipUtil.extract((File)firefoxAddon, (File)firefoxAddonExtracted);
            return firefoxAddonExtracted;
        }
        return null;
    }

    protected File getFirefoxAddonFile() throws IOException {
        File extensionFolder = FileUtil.getExtensionsDirectory(FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            return new File(extensionFolder.getAbsolutePath(), FIREFOX_ADDON_RELATIVE_PATH);
        }
        return null;
    }

    public void stop() {
        this.isRunFlag = false;
        this.dispose();
    }

    protected void dispose() {
        try {
            File serverSettingFile;
            if (this.driver != null && ((RemoteWebDriver)this.driver).getSessionId() != null) {
                this.driver.quit();
            }
            if ((serverSettingFile = new File(this.getIEApplicationServerSettingFile())).exists()) {
                serverSettingFile.delete();
            }
        }
        catch (UnreachableBrowserException unreachableBrowserException) {
        }
        catch (WebDriverException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.isRunFlag;
    }

    protected String getAddOnName() {
        return OBJECT_SPY_ADD_ON_NAME;
    }

    protected String getChromeExtensionPath() {
        return CHROME_EXTENSION_RELATIVE_PATH;
    }

    protected String getFirefoxExtensionPath() {
        return FIREFOX_ADDON_RELATIVE_PATH;
    }

    protected String getIEAddonRegistryKey() {
        return IE_ADDON_BHO_KEY;
    }

    public WebDriver getWebDriver() {
        return this.driver;
    }

    public WebUIDriverType getWebUiDriverType() {
        return this.webUiDriverType;
    }
}

