/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.core;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.objectspy.core.ClientMessage;
import com.kms.katalon.objectspy.core.HTMLElementCollector;
import com.kms.katalon.objectspy.core.KatalonRequestHandler;
import com.kms.katalon.objectspy.util.HTMLElementUtil;
import com.kms.katalon.objectspy.util.WebElementUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HTMLElementServlet
extends HttpServlet {
    public static final String WILD_CARD = "*";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String TEXT_HTML = "text/html";
    private static final String EQUALS = "=";
    private static final String ELEMENT_KEY = "element";
    private static final String ELEMENT_MAP_KEY = "elementsMap";
    private static final long serialVersionUID = 1L;
    private HTMLElementCollector objectSpyDialog;

    public HTMLElementServlet(HTMLElementCollector objectSpyDialog) {
        this.objectSpyDialog = objectSpyDialog;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(200);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String key;
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        if (sb.indexOf(EQUALS) == -1) {
            return;
        }
        switch (key = HTMLElementUtil.decodeURIComponent(sb.substring(0, sb.indexOf(EQUALS)))) {
            case "element": {
                this.addNewElement(response, sb.substring(sb.indexOf(EQUALS) + 1, sb.length()));
                break;
            }
            default: {
                KatalonRequestHandler.getInstance().processIncomeRequest(new ClientMessage(sb.toString()), (OutputStream)response.getOutputStream());
            }
            case "elementsMap": 
        }
    }

    private void addNewElement(HttpServletResponse response, String value) {
        response.setContentType(TEXT_HTML);
        response.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN, WILD_CARD);
        try {
            this.objectSpyDialog.addNewElement(WebElementUtils.buildWebElement(value));
            response.setStatus(200);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            response.setStatus(500);
        }
    }
}

