/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.core;

import com.kms.katalon.objectspy.core.HTMLElementCollector;
import com.kms.katalon.objectspy.core.HTMLElementServlet;
import com.kms.katalon.objectspy.filter.CrossOriginFilter;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class HTMLElementCaptureServer {
    protected Server server;
    protected boolean isUsingDynamicPort = false;
    protected ServletContextHandler context;

    public HTMLElementCaptureServer(int port, Class<?> socketClass) {
        this.server = new Server(port);
        this.context = new ServletContextHandler(1);
        this.context.setContextPath("/");
        FilterHolder filterHolder = new FilterHolder((Filter)new CrossOriginFilter());
        filterHolder.setInitParameter("allowedMethods", "GET,POST,HEAD,OPTIONS");
        this.context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.server.setHandler((Handler)this.context);
        try {
            ServerContainer wscontainer = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)this.context);
            wscontainer.addEndpoint(socketClass);
            System.out.println(socketClass);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (DeploymentException e) {
            e.printStackTrace();
        }
    }

    public HTMLElementCaptureServer(HTMLElementCollector objectSpyDialog, Class<?> socketClass) {
        this(0, objectSpyDialog, socketClass);
        this.isUsingDynamicPort = true;
    }

    public HTMLElementCaptureServer(int port, HTMLElementCollector objectSpyDialog, Class<?> socketClass) {
        this(port, socketClass);
        this.addServlets(objectSpyDialog, this.context);
    }

    protected void addServlets(HTMLElementCollector objectSpyDialog, ServletContextHandler context) {
        context.addServlet(new ServletHolder((Servlet)new HTMLElementServlet(objectSpyDialog)), "/*");
    }

    public void start() throws Exception {
        this.server.start();
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isStarted() {
        return this.server.isStarted() && this.server.getConnectors().length > 0 && this.server.getConnectors()[0] != null;
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public String getServerUrl() {
        if (this.isStarted()) {
            return "http://localhost:" + this.getServerPort() + "/";
        }
        return "";
    }

    public int getServerPort() {
        if (this.isStarted()) {
            return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        return -1;
    }

    public boolean isUsingDynamicPort() {
        return this.isUsingDynamicPort;
    }
}

