/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewDSLDWizard
extends BasicNewResourceWizard {
    private WizardNewFileCreationPage mainPage;

    public void addPages() {
        super.addPages();
        this.mainPage = new NewDSLDWizardPage("newDSLDFilePage", this.getSelection());
        this.mainPage.setTitle("DSLD File");
        this.mainPage.setDescription("Create a new Groovy DSL Descriptor");
        this.mainPage.setFileExtension("dsld");
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle("New DSLD File");
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = GroovyDSLCoreActivator.imageDescriptorFromPlugin((String)"org.codehaus.groovy.eclipse.dsl", (String)"icons/GROOVY.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError((Shell)dw.getShell(), (String)ResourceMessages.FileResource_errorMessage, (String)e.getMessage(), (PartInitException)e);
        }
        return true;
    }

    class NewDSLDWizardPage
    extends WizardNewFileCreationPage {
        public NewDSLDWizardPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
        }

        protected InputStream getInitialContents() {
            return new StringInputStream("// this is a DSLD file\n// start off creating a custom DSL Descriptor for your Groovy DSL\n\n// The following snippet adds the 'newProp' to all types that are a subtype of GroovyObjects\n// contribute(currentType(subType('groovy.lang.GroovyObject'))) {\n//   property name : 'newProp', type : String, provider : 'Sample DSL', doc : 'This is a sample.  You should see this in content assist for GroovyObjects: <pre>newProp</pre>'\n// }\n");
        }

        protected boolean validatePage() {
            IProject project;
            if (!super.validatePage()) {
                return false;
            }
            IPath path = this.getContainerFullPath();
            if (path.segmentCount() > 1) {
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                project = folder.getProject();
            } else if (path.segmentCount() == 1) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
            } else {
                Object project2 = null;
                this.setErrorMessage("No folder is selected");
                return false;
            }
            if (!project.exists()) {
                this.setErrorMessage("Project " + project.getName() + " does not exist.");
                return false;
            }
            if (!GroovyNature.hasGroovyNature((IProject)project)) {
                this.setErrorMessage("Project " + project.getName() + " is not a groovy project.");
                return false;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
                boolean inSourceFolder = false;
                IClasspathEntry[] iClasspathEntryArray = rawClasspath;
                int n = rawClasspath.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    IPath sourcePath = entry.getPath();
                    if (sourcePath.isPrefixOf(path)) {
                        inSourceFolder = true;
                        break;
                    }
                    ++n2;
                }
                if (!inSourceFolder) {
                    this.setMessage("Path is not in a source folder.  It is significantly easier to edit DSLDs when they are in source folders", 2);
                }
            }
            catch (JavaModelException e) {
                GroovyCore.logException((String)"Exception while creating DSLD file", (Throwable)e);
                this.setErrorMessage(e.getMessage());
                return false;
            }
            return true;
        }
    }

    class StringInputStream
    extends InputStream {
        private Reader reader;

        public StringInputStream(String contents) {
            this.reader = new StringReader(contents);
        }

        public int read() throws IOException {
            return this.reader.read();
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

