/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.ui;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.DSLDStoreManager;
import org.codehaus.groovy.eclipse.dsl.DSLPreferencesInitializer;
import org.codehaus.groovy.eclipse.dsl.DisabledScriptsCache;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;

public class DSLPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private final String[] LABELS = new String[]{"Edit...", "Recompile Scripts", "Refresh List", "Check All", "Uncheck All"};
    private final int IDX_EDIT = 0;
    private final int IDX_RECOMPILE = 1;
    private final int IDX_REFRESH = 2;
    private final int IDX_CHECK_ALL = 3;
    private final int IDX_UNCHECK_ALL = 4;
    DisabledScriptsCache cache;
    Map<String, ProjectContextKey[]> elementsMap;
    private CheckedTreeListDialogField tree;
    private DSLDStoreManager manager;
    private IWorkbenchPage page;
    private IPreferenceStore store = GroovyDSLCoreActivator.getDefault().getPreferenceStore();
    private Button autoAdd;
    private Button disableDSLDs;
    private static final String EVENT = "Recompiling all DSLDs in the workspace.";

    public DSLPreferencesPage() {
    }

    public DSLPreferencesPage(String title) {
        super(title);
    }

    public DSLPreferencesPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        this.manager = GroovyDSLCoreActivator.getDefault().getContextStoreManager();
        this.cache = new DisabledScriptsCache();
        this.elementsMap = new HashMap<String, ProjectContextKey[]>();
        try {
            this.page = workbench.getActiveWorkbenchWindow().getActivePage();
        }
        catch (NullPointerException nullPointerException) {}
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.tree = new CheckedTreeListDialogField(new DSLListAdapter(), this.LABELS, (ILabelProvider)new DSLLabelProvider());
        this.tree.setTreeExpansionLevel(2);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.tree}, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.tree.getTreeControl(null));
        this.refresh();
        PixelConverter converter = new PixelConverter((Control)parent);
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.tree.setButtonsMinWidth(buttonBarWidth);
        this.autoAdd = new Button(composite, 32);
        this.autoAdd.setText("Automatically add DSL Support to all Groovy projects");
        this.autoAdd.setSelection(this.store.getBoolean("org.codehaus.groovy.eclipse.dsl.auto.add.support"));
        GridData data = new GridData(16384, 128, true, false);
        data.horizontalSpan = 2;
        this.autoAdd.setLayoutData((Object)data);
        this.disableDSLDs = new Button(composite, 32);
        this.disableDSLDs.setText("Disable DSLD support in your workspace. (Requires restart)");
        boolean isDisabled = this.store.getBoolean("org.codehaus.groovy.eclipse.dsl.disabled");
        this.disableDSLDs.setSelection(isDisabled);
        this.disableDSLDs.setLayoutData((Object)data);
        if (this.disableDSLDs.getSelection()) {
            Label l = new Label(composite, 0);
            l.setText("NOTE: DSLD support is currently disabled.");
        }
        return composite;
    }

    protected IProject toProject(Object element) {
        String name;
        IProject proj;
        if (element instanceof String && GroovyNature.hasGroovyNature((IProject)(proj = ROOT.getProject(name = (String)element)))) {
            return proj;
        }
        return null;
    }

    protected boolean canEdit() {
        List selected = this.tree.getSelectedElements();
        return selected.size() == 1 && selected.get(0) instanceof ProjectContextKey;
    }

    protected void edit() {
        if (this.canEdit()) {
            List selected = this.tree.getSelectedElements();
            ProjectContextKey pck = (ProjectContextKey)selected.get(0);
            IStorage storage = pck.dslFile;
            IEditorInput input = this.getEditorInput(storage);
            if (input != null) {
                try {
                    if (this.page != null) {
                        IDE.openEditor((IWorkbenchPage)this.page, (IEditorInput)input, (String)"org.codehaus.groovy.eclipse.editor.GroovyEditor", (boolean)true);
                    }
                }
                catch (PartInitException e) {
                    if (this.page != null) {
                        ErrorDialog.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)"Error opening editor", (String)("See error log: " + e.getLocalizedMessage()), (IStatus)e.getStatus());
                    }
                    GroovyDSLCoreActivator.logException(e);
                }
            } else if (this.page != null) {
                ErrorDialog.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)"Could not open editor", (String)("File " + pck.dslFile + " is not accessible."), (IStatus)new Status(4, "org.codehaus.groovy.eclipse.dsl", "Could not open editor"));
            }
        }
    }

    private IEditorInput getEditorInput(IStorage storage) {
        if (storage instanceof IFile && ((IFile)storage).getProject().equals((Object)JavaModelManager.getExternalManager().getExternalFoldersProject())) {
            return new FileStoreEditorInput((IFileStore)new LocalFile(new File(((IFile)storage).getLocationURI())));
        }
        return EditorUtility.getEditorInput((Object)storage);
    }

    protected void refresh() {
        List<String> allStores = this.manager.getAllStores();
        this.elementsMap.clear();
        for (String element : allStores) {
            DSLDStore store;
            IProject project = this.toProject(element);
            if (project == null || (store = this.manager.getDSLDStore(project)) == null) continue;
            IStorage[] keys = store.getAllContextKeys();
            ProjectContextKey[] pck = new ProjectContextKey[keys.length];
            int i = 0;
            while (i < pck.length) {
                pck[i] = new ProjectContextKey(element, keys[i]);
                pck[i].isChecked = !this.cache.isDisabled(DSLDStore.toUniqueString(pck[i].dslFile));
                ++i;
            }
            this.elementsMap.put(element, pck);
        }
        Collections.sort(allStores);
        this.tree.setElements(allStores);
        this.tree.refresh();
        Iterator<String> iterator = this.elementsMap.values().iterator();
        while (iterator.hasNext()) {
            ProjectContextKey[] keys;
            ProjectContextKey[] projectContextKeyArray = keys = (ProjectContextKey[])iterator.next();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectContextKey key = projectContextKeyArray[n2];
                this.tree.setChecked(key, key.isChecked);
                ++n2;
            }
        }
    }

    void checkAll(boolean newState) {
        Iterator<ProjectContextKey[]> iterator = this.elementsMap.values().iterator();
        while (iterator.hasNext()) {
            ProjectContextKey[] keys;
            ProjectContextKey[] projectContextKeyArray = keys = iterator.next();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectContextKey key = projectContextKeyArray[n2];
                key.isChecked = newState;
                this.tree.setChecked(key, key.isChecked);
                ++n2;
            }
        }
    }

    protected void storeChecks() {
        HashSet<String> unchecked = new HashSet<String>();
        Iterator<ProjectContextKey[]> iterator = this.elementsMap.values().iterator();
        while (iterator.hasNext()) {
            ProjectContextKey[] keys;
            ProjectContextKey[] projectContextKeyArray = keys = iterator.next();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectContextKey key = projectContextKeyArray[n2];
                if (!key.isChecked) {
                    unchecked.add(DSLDStore.toUniqueString(key.dslFile));
                }
                ++n2;
            }
        }
        this.cache.setDisabled(unchecked);
    }

    protected void recompile() {
        new UIJob("Refresh DSLD launcher"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                GroovyLogManager.manager.log(TraceCategory.DSL, DSLPreferencesPage.EVENT);
                GroovyLogManager.manager.logStart(DSLPreferencesPage.EVENT);
                GroovyDSLCoreActivator.getDefault().getContextStoreManager().initializeAll(true);
                if (!DSLPreferencesPage.this.getControl().isDisposed()) {
                    DSLPreferencesPage.this.refresh();
                }
                GroovyLogManager.manager.logEnd(DSLPreferencesPage.EVENT, TraceCategory.DSL);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkAll(true);
        DSLPreferencesInitializer.reset();
        this.autoAdd.setSelection(true);
    }

    public boolean performOk() {
        this.storeChecks();
        this.store.setValue("org.codehaus.groovy.eclipse.dsl.auto.add.support", this.autoAdd.getSelection());
        boolean origDisabled = this.store.getBoolean("org.codehaus.groovy.eclipse.dsl.disabled");
        if (origDisabled != this.disableDSLDs.getSelection()) {
            this.store.setValue("org.codehaus.groovy.eclipse.dsl.disabled", this.disableDSLDs.getSelection());
            String newValue = this.disableDSLDs.getSelection() ? "enabled" : "disabled";
            boolean res = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Restart now?", (String)("You have " + newValue + " DSLDs in your worksoace.  This setting will not coming effect until a restart has " + "been performed.\n\nDo you want to restart now?"));
            if (res) {
                Workbench.getInstance().restart();
            }
        }
        return super.performOk();
    }

    private final class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof ProjectContextKey) {
                ProjectContextKey key = (ProjectContextKey)element;
                key.isChecked = event.getChecked();
            } else if (element instanceof String) {
                ProjectContextKey[] children;
                ProjectContextKey[] projectContextKeyArray = children = DSLPreferencesPage.this.elementsMap.get(element);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ProjectContextKey child = projectContextKeyArray[n2];
                    child.isChecked = event.getChecked();
                    ++n2;
                }
            }
        }
    }

    private final class CheckedTreeListDialogField
    extends TreeListDialogField {
        private ContainerCheckedTreeViewer checkboxViewer;

        private CheckedTreeListDialogField(ITreeListAdapter adapter, String[] buttonLabels, ILabelProvider lprovider) {
            super(adapter, buttonLabels, lprovider);
        }

        protected TreeViewer createTreeViewer(Composite parent) {
            Tree tree = new Tree(parent, this.getTreeStyle() | 0x20);
            tree.setFont(parent.getFont());
            this.checkboxViewer = new ContainerCheckedTreeViewer(tree);
            this.checkboxViewer.addCheckStateListener((ICheckStateListener)new CheckStateListener());
            return this.checkboxViewer;
        }

        void setChecked(Object child, boolean newState) {
            this.checkboxViewer.setChecked(child, newState);
        }
    }

    class DSLLabelProvider
    extends LabelProvider {
        WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

        DSLLabelProvider() {
        }

        public void dispose() {
            this.provider.dispose();
            super.dispose();
        }

        public String getText(Object element) {
            if (element instanceof ProjectContextKey) {
                ProjectContextKey pck = (ProjectContextKey)element;
                return pck.dslFile.getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            IProject proj = DSLPreferencesPage.this.toProject(element);
            if (proj != null) {
                return this.provider.getImage((Object)proj);
            }
            IFile file = null;
            if (element instanceof ProjectContextKey && ((ProjectContextKey)element).dslFile instanceof IFile) {
                file = (IFile)((ProjectContextKey)element).dslFile;
            }
            if (file != null) {
                return this.provider.getImage(file);
            }
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.classf_obj.gif");
        }
    }

    class DSLListAdapter
    implements ITreeListAdapter {
        DSLListAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            if (index == 0) {
                DSLPreferencesPage.this.edit();
            } else if (index == 1) {
                DSLPreferencesPage.this.recompile();
            } else if (index == 2) {
                DSLPreferencesPage.this.refresh();
            } else if (index == 3) {
                DSLPreferencesPage.this.checkAll(true);
            } else if (index == 4) {
                DSLPreferencesPage.this.checkAll(false);
            }
        }

        public void selectionChanged(TreeListDialogField field) {
            if (DSLPreferencesPage.this.canEdit()) {
                field.enableButton(0, true);
            } else {
                field.enableButton(0, false);
            }
        }

        public void doubleClicked(TreeListDialogField field) {
            DSLPreferencesPage.this.edit();
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof String) {
                return DSLPreferencesPage.this.elementsMap.get(element);
            }
            return null;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof ProjectContextKey) {
                return ((ProjectContextKey)element).projectName;
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            Object[] children = this.getChildren(field, element);
            return children != null && children.length > 0;
        }
    }

    class ProjectContextKey {
        final String projectName;
        final IStorage dslFile;
        boolean isChecked;

        public ProjectContextKey(String projectName, IStorage dslFile) {
            this.projectName = projectName;
            this.dslFile = dslFile;
        }
    }
}

