/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.script;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.script.PointcutClosure;
import org.codehaus.groovy.eclipse.dsl.script.PointcutFactory;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class DSLDScriptExecutor {
    private final GroovyClassLoader gcl = new GroovyClassLoader(GroovyDSLCoreActivator.class.getClassLoader());
    private final IJavaProject project;
    private PointcutFactory factory;
    private IStorage scriptFile;
    private static Version groovyEclipseVersion;
    private static Version groovyVersion;
    private static Version grailsToolingVersion;
    private static final Object versionLock;

    static {
        versionLock = new Object();
    }

    public DSLDScriptExecutor(IJavaProject project) {
        this.project = project;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeScript(IStorage scriptFile) {
        Object object;
        block19: {
            this.scriptFile = scriptFile;
            String event = null;
            try {
                if (GroovyLogManager.manager.hasLoggers()) {
                    GroovyLogManager.manager.log(TraceCategory.DSL, "About to compile script for " + scriptFile);
                    event = "Script creation for " + scriptFile;
                    GroovyLogManager.manager.logStart(event);
                }
                this.factory = new PointcutFactory(scriptFile, this.project.getProject());
                Object result = null;
                String scriptContents = this.getContents(scriptFile);
                Class clazz = null;
                try {
                    clazz = this.gcl.parseClass(scriptContents, scriptFile.getName());
                }
                catch (Exception e) {
                    if (GroovyLogManager.manager.hasLoggers()) {
                        StringWriter writer = new StringWriter();
                        e.printStackTrace(new PrintWriter(writer));
                        GroovyLogManager.manager.log(TraceCategory.DSL, "Attempted to compile " + scriptFile + "but failed because:\n" + writer.getBuffer());
                    }
                    Object object3 = result;
                    if (event != null) {
                        GroovyLogManager.manager.logEnd(event, TraceCategory.DSL);
                    }
                    return object3;
                }
                if (!Script.class.isAssignableFrom(clazz)) {
                    if (GroovyLogManager.manager.hasLoggers()) {
                        GroovyLogManager.manager.log(TraceCategory.DSL, "Class " + scriptFile + " is not a script.  Can't execute as DSLD.");
                    }
                    Object object2 = result;
                    if (event != null) {
                        GroovyLogManager.manager.logEnd(event, TraceCategory.DSL);
                    }
                    return object2;
                }
                try {
                    Script dsldScript = (Script)clazz.newInstance();
                    dsldScript.setBinding((Binding)new DSLDScriptBinding(dsldScript));
                    result = dsldScript.run();
                }
                catch (UnsupportedDSLVersion e) {
                    if (GroovyLogManager.manager.hasLoggers()) {
                        GroovyLogManager.manager.log(TraceCategory.DSL, e.getMessage());
                    }
                }
                catch (Exception e) {
                    GroovyDSLCoreActivator.logException(e);
                }
                object = result;
                if (event == null) break block19;
            }
            catch (Throwable throwable) {
                if (event != null) {
                    GroovyLogManager.manager.logEnd(event, TraceCategory.DSL);
                }
                throw throwable;
            }
            GroovyLogManager.manager.logEnd(event, TraceCategory.DSL);
        }
        return object;
    }

    public String getContents(IStorage file) throws IOException, CoreException {
        BufferedReader br;
        try {
            br = new BufferedReader(new InputStreamReader(file.getContents()));
        }
        catch (ResourceException e) {
            if (e.getStatus().getCode() != 368) {
                throw e;
            }
            return "";
        }
        StringBuffer sb = new StringBuffer(300);
        try {
            int read = 0;
            while ((read = br.read()) != -1) {
                sb.append((char)read);
            }
        }
        finally {
            br.close();
        }
        return sb.toString();
    }

    protected Object tryRegister(Object args) {
        Object[] nameAndClosure = this.extractArgsForRegister(args);
        if (nameAndClosure != null) {
            this.factory.registerLocalPointcut((String)nameAndClosure[0], (Closure)nameAndClosure[1]);
            return nameAndClosure[1];
        }
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "Cannot register custom pointcut for " + (args instanceof Object[] ? Arrays.toString((Object[])args) : args));
        }
        return null;
    }

    protected Object[] extractArgsContribution(Object args) {
        if (args instanceof Object[]) {
            Object[] arr = (Object[])args;
            if (arr.length == 2 && arr[0] instanceof IPointcut && arr[1] instanceof Closure) {
                return arr;
            }
        } else if (args instanceof Collection) {
            Collection coll = (Collection)args;
            Object[] arr = new Object[2];
            Iterator iter = coll.iterator();
            if (iter.hasNext() && (arr[0] = iter.next()) instanceof IPointcut && iter.hasNext() && (arr[1] = iter.next()) instanceof Closure && !iter.hasNext()) {
                return arr;
            }
        } else if (args instanceof Map) {
            return this.extractArgsContribution(((Map)args).values());
        }
        return null;
    }

    protected Object[] extractArgsForRegister(Object args) {
        if (args instanceof Object[]) {
            Object[] arr = (Object[])args;
            if (arr.length == 2 && arr[0] instanceof String && arr[1] instanceof Closure) {
                return arr;
            }
        } else if (args instanceof Collection) {
            Collection coll = (Collection)args;
            Object[] arr = new Object[2];
            Iterator iter = coll.iterator();
            if (iter.hasNext() && (arr[0] = iter.next()) instanceof String && iter.hasNext() && (arr[1] = iter.next()) instanceof Closure && !iter.hasNext()) {
                return arr;
            }
        } else if (args instanceof Map) {
            return this.extractArgsForRegister(((Map)args).values());
        }
        return null;
    }

    private static void initializeVersions() {
        Bundle grailsBundle;
        groovyEclipseVersion = GroovyDSLCoreActivator.getDefault().getBundle().getVersion();
        Bundle groovyBundle = Platform.getBundle((String)"org.codehaus.groovy");
        if (groovyBundle != null) {
            groovyVersion = groovyBundle.getVersion();
        }
        if ((grailsBundle = Platform.getBundle((String)"com.springsource.sts.grails.core")) == null) {
            grailsBundle = Platform.getBundle((String)"org.grails.ide.eclipse.core");
        }
        if (grailsBundle != null) {
            grailsToolingVersion = grailsBundle.getVersion();
        }
    }

    public Object contribution(Object args) {
        Object[] contributionArgs = this.extractArgsContribution(args);
        if (args == null || contributionArgs.length == 0) {
            return null;
        }
        IPointcut p = (IPointcut)contributionArgs[0];
        p.accept((Closure)contributionArgs[1]);
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object checkVersion(Object[] array) {
        if (array == null || array.length != 1) {
            return this.createInvalidVersionString(array);
        }
        Object args = array[0];
        Object object = versionLock;
        synchronized (object) {
            if (groovyEclipseVersion == null) {
                DSLDScriptExecutor.initializeVersions();
            }
        }
        if (!(args instanceof Map)) {
            return this.createInvalidVersionString(args);
        }
        Map versions = (Map)args;
        for (Map.Entry entry : versions.entrySet()) {
            if (!(entry.getValue() instanceof String)) {
                return this.createInvalidVersionString(args);
            }
            Version v = null;
            try {
                v = new Version((String)entry.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedDSLVersion(e.getMessage());
            }
            if ("groovy".equals(entry.getKey())) {
                if (groovyVersion != null && v.compareTo(groovyVersion) > 0) {
                    return "Invalid Groovy version.  Expected: " + v + " Installed: " + groovyVersion;
                }
                if (groovyVersion != null) continue;
                return "Could not find a Groovy version.  Expected: " + groovyVersion;
            }
            if ("groovyEclipse".equals(entry.getKey())) {
                if (groovyEclipseVersion != null && v.compareTo(groovyEclipseVersion) > 0) {
                    return "Invalid Groovy-Eclipse version.  Expected: " + v + " Installed: " + groovyEclipseVersion;
                }
                if (groovyEclipseVersion != null) continue;
                return "Could not find a Groovy-Eclipse version.  Expected: " + groovyEclipseVersion;
            }
            if ("grailsTooling".equals(entry.getKey()) || "sts".equals(entry.getKey())) {
                if (grailsToolingVersion != null && v.compareTo(grailsToolingVersion) > 0) {
                    return "Invalid Grails Tooling version.  Expected: " + v + " Installed: " + grailsToolingVersion;
                }
                if (grailsToolingVersion != null) continue;
                return "Could not find a Grails Tooling version.  Expected: " + grailsToolingVersion;
            }
            return this.createInvalidVersionString(args);
        }
        return null;
    }

    protected String createInvalidVersionString(Object args) {
        return args + " is not a valid version identifier, must be a Map<String, String>.  " + "Each value must be a version number X.Y.Z.  " + "Supported version checking is: 'groovy', 'grailsTooling', 'groovyEclipse'.";
    }

    private final class DSLDScriptBinding
    extends Binding {
        private final Script dsldScript;

        public DSLDScriptBinding(Script dsldScript) {
            this.dsldScript = dsldScript;
        }

        public Object invokeMethod(String name, Object args) {
            if (name.equals("registerPointcut")) {
                return DSLDScriptExecutor.this.tryRegister(args);
            }
            if (name.equals("supportsVersion")) {
                String result = (String)DSLDScriptExecutor.this.checkVersion(new Object[]{args});
                if (result == null) {
                    return true;
                }
                return false;
            }
            if (name.equals("assertVersion")) {
                String result = (String)DSLDScriptExecutor.this.checkVersion(new Object[]{args});
                if (result != null) {
                    throw new UnsupportedDSLVersion(result);
                }
                return null;
            }
            if (name.equals("contribute")) {
                Object result = DSLDScriptExecutor.this.contribution(args);
                if (result == null) {
                    throw new MissingMethodException(name, this.dsldScript.getClass(), new Object[]{args});
                }
                return result;
            }
            if (name.equals("log")) {
                if (GroovyLogManager.manager.hasLoggers()) {
                    GroovyLogManager.manager.log(TraceCategory.DSL, "========== " + args);
                }
                return args;
            }
            IPointcut pc = DSLDScriptExecutor.this.factory.createPointcut(name);
            if (pc != null) {
                this.configure(pc, args);
                return pc;
            }
            return super.invokeMethod(name, args);
        }

        public Object getVariable(String name) {
            if ("registerPointcut".equals(name)) {
                return new RegisterClosure((Object)this);
            }
            if ("supportsVersion".equals(name)) {
                return new Closure((Object)this){
                    private static final long serialVersionUID = 1L;

                    public Object call(Object[] args) {
                        String result = (String)DSLDScriptExecutor.this.checkVersion(args);
                        if (result == null) {
                            return true;
                        }
                        return false;
                    }
                };
            }
            if ("assertVersion".equals(name)) {
                return new Closure((Object)this){
                    private static final long serialVersionUID = 1L;

                    public Object call(Object[] args) {
                        String result = (String)DSLDScriptExecutor.this.checkVersion(args);
                        if (result != null) {
                            throw new UnsupportedDSLVersion(result);
                        }
                        return null;
                    }
                };
            }
            if ("contribute".equals(name)) {
                return new Closure((Object)this){
                    private static final long serialVersionUID = 1L;

                    public Object call(Object[] args) {
                        Object result = DSLDScriptExecutor.this.contribution(args);
                        if (result == null) {
                            throw new MissingMethodException("contribute", DSLDScriptBinding.this.dsldScript.getClass(), new Object[]{args});
                        }
                        return result;
                    }
                };
            }
            if ("log".equals(name)) {
                return new Closure((Object)this){
                    private static final long serialVersionUID = 1L;

                    public Object call(Object[] args) {
                        if (GroovyLogManager.manager.hasLoggers()) {
                            String msg = args == null ? "null" : (args.length == 0 ? "" : args[0].toString());
                            GroovyLogManager.manager.log(TraceCategory.DSL, "========== " + msg);
                        }
                        return args;
                    }
                };
            }
            IPointcut pc = DSLDScriptExecutor.this.factory.createPointcut(name);
            if (pc != null) {
                return new PointcutClosure((Object)this, pc);
            }
            return super.getVariable(name);
        }

        private void configure(IPointcut pointcut, Object arguments) {
            if (arguments instanceof Map) {
                for (Map.Entry entry : ((Map)arguments).entrySet()) {
                    Object key = entry.getKey();
                    pointcut.addArgument(key == null ? null : key.toString(), entry.getValue());
                }
            } else if (arguments instanceof Collection) {
                for (Object arg : (Collection)arguments) {
                    pointcut.addArgument(arg);
                }
            } else if (arguments instanceof Object[]) {
                Object[] objectArray = (Object[])arguments;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object arg = objectArray[n2];
                    pointcut.addArgument(arg);
                    ++n2;
                }
            } else if (arguments != null) {
                pointcut.addArgument(arguments);
            }
        }
    }

    private final class RegisterClosure
    extends Closure {
        private static final long serialVersionUID = 1162731585734041055L;

        public RegisterClosure(Object owner) {
            super(owner);
        }

        public Object call(Object arguments) {
            return DSLDScriptExecutor.this.tryRegister(arguments);
        }

        public Object call(Object[] arguments) {
            return DSLDScriptExecutor.this.tryRegister(arguments);
        }
    }

    private final class UnsupportedDSLVersion
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnsupportedDSLVersion(String why) {
            super(String.valueOf(DSLDScriptExecutor.this.scriptFile.getName()) + " is not supported because:\n" + why);
        }
    }
}

