/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.FilteringPointcut;
import org.eclipse.core.resources.IStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTypePointcut
extends FilteringPointcut<ClassNode> {
    private Map<ClassNode, Set<ClassNode>> cachedHierarchies = new HashMap<ClassNode, Set<ClassNode>>();

    public SubTypePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName, ClassNode.class);
    }

    @Override
    protected Collection<ClassNode> explodeObject(Object toMatch) {
        if (toMatch instanceof Collection) {
            LinkedHashSet<ClassNode> classes = new LinkedHashSet<ClassNode>();
            for (Object elt : (Collection)toMatch) {
                if (!(elt instanceof ClassNode)) continue;
                classes.addAll(this.getAllSupers((ClassNode)elt));
            }
            return classes;
        }
        if (toMatch instanceof ClassNode) {
            return this.getAllSupers((ClassNode)toMatch);
        }
        return null;
    }

    @Override
    protected ClassNode filterObject(ClassNode result, GroovyDSLDContext context, String firstArgAsString) {
        if (firstArgAsString == null || result.getName().equals(firstArgAsString)) {
            return result;
        }
        return null;
    }

    private Set<ClassNode> getAllSupers(ClassNode type) {
        Set<ClassNode> cached = this.cachedHierarchies.get(type);
        if (cached == null) {
            cached = new HashSet<ClassNode>();
            this.internalGetAllSupers(type, cached);
            this.cachedHierarchies.put(type, cached);
        }
        return cached;
    }

    private void internalGetAllSupers(ClassNode type, Set<ClassNode> set) {
        if (type == null) {
            return;
        }
        set.add(type);
        this.internalGetAllSupers(type.getSuperClass(), set);
        for (ClassNode inter : type.getAllInterfaces()) {
            if (inter.getName().equals(type.getName())) continue;
            this.internalGetAllSupers(inter, set);
        }
    }
}

