/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.Collection;
import java.util.Collections;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.compiler.CharOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFolderOfTypePointcut
extends AbstractPointcut {
    public SourceFolderOfTypePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext pattern, Object toMatch) {
        String sourceFolder = this.extractFileName(this.toType(toMatch), pattern);
        if (sourceFolder != null && sourceFolder.startsWith((String)this.getFirstArgument())) {
            return Collections.singleton(pattern.fullPathName);
        }
        return null;
    }

    private ClassNode toType(Object toMatch) {
        if (toMatch instanceof ClassNode) {
            return (ClassNode)toMatch;
        }
        if (toMatch instanceof AnnotatedNode) {
            return ((AnnotatedNode)toMatch).getDeclaringClass();
        }
        return null;
    }

    private String extractFileName(ClassNode type, GroovyDSLDContext pattern) {
        if (type == null) {
            return null;
        }
        ClassNode redirect = type.redirect();
        if (redirect instanceof JDTClassNode) {
            JDTClassNode jdtClass = (JDTClassNode)redirect;
            char[] fileName = jdtClass.getJdtBinding().getFileName();
            if (fileName != null) {
                int slashIndex = CharOperation.indexOf((char)'/', (char[])fileName);
                if (slashIndex >= 0) {
                    slashIndex = CharOperation.indexOf((char)'/', (char[])fileName, (int)(slashIndex + 1));
                }
                if (slashIndex > 0) {
                    return String.valueOf(CharOperation.subarray((char[])fileName, (int)(slashIndex + 1), (int)fileName.length));
                }
            }
        } else {
            ModuleNode module = pattern.getCurrentScope().getEnclosingTypeDeclaration().getModule();
            if (module != null && module.getClasses().contains(redirect)) {
                return pattern.fullPathName;
            }
        }
        return "";
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String maybeStatus = this.allArgsAreStrings();
        if (maybeStatus != null) {
            throw new PointcutVerificationException(maybeStatus, this);
        }
        maybeStatus = this.hasOneArg();
        if (maybeStatus != null) {
            throw new PointcutVerificationException(maybeStatus, this);
        }
        super.verify();
    }
}

