/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.FilteringPointcut;
import org.eclipse.core.resources.IStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasArgumentsPointcut
extends FilteringPointcut<AnnotatedNode> {
    public HasArgumentsPointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName, AnnotatedNode.class);
    }

    @Override
    protected Collection<AnnotatedNode> explodeObject(Object toMatch) {
        Parameter[] parameters;
        if (toMatch instanceof MethodCallExpression) {
            Expression arguments = ((MethodCallExpression)toMatch).getArguments();
            if (arguments instanceof TupleExpression) {
                List innerArgs = ((TupleExpression)arguments).getExpressions();
                ArrayList<AnnotatedNode> actualArgs = new ArrayList<AnnotatedNode>(innerArgs.size());
                for (Expression innerArg : innerArgs) {
                    if (innerArg instanceof MapExpression) {
                        actualArgs.addAll(((MapExpression)innerArg).getMapEntryExpressions());
                        continue;
                    }
                    actualArgs.add((AnnotatedNode)innerArg);
                }
                return actualArgs;
            }
            if (arguments instanceof ListExpression) {
                return new ArrayList<AnnotatedNode>(((ListExpression)arguments).getExpressions());
            }
            if (arguments instanceof MapExpression) {
                List mapEntryExpressions = ((MapExpression)arguments).getMapEntryExpressions();
                ArrayList<AnnotatedNode> result = new ArrayList<AnnotatedNode>(mapEntryExpressions);
                result.addAll(mapEntryExpressions);
                return result;
            }
            return Collections.singleton(arguments);
        }
        if (toMatch instanceof MethodNode && (parameters = ((MethodNode)toMatch).getParameters()) != null) {
            return Arrays.asList(parameters);
        }
        return null;
    }

    @Override
    protected AnnotatedNode filterObject(AnnotatedNode result, GroovyDSLDContext context, String firstArgAsString) {
        String name;
        if (firstArgAsString == null) {
            if (result instanceof MapEntryExpression) {
                return ((MapEntryExpression)result).getValueExpression();
            }
            return result;
        }
        if (result instanceof MapEntryExpression) {
            String argName;
            MapEntryExpression entry = (MapEntryExpression)result;
            if (entry.getKeyExpression() instanceof ConstantExpression && (argName = entry.getKeyExpression().getText()).equals(firstArgAsString)) {
                return entry.getValueExpression();
            }
        } else if (result instanceof Parameter && (name = ((Parameter)result).getName()).equals(firstArgAsString)) {
            return result;
        }
        return null;
    }
}

