/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnclosingCallPointcut
extends AbstractPointcut {
    public EnclosingCallPointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext pattern, Object toMatch) {
        List enclosing = pattern.getCurrentScope().getAllEnclosingMethodCallExpressions();
        if (enclosing == null || enclosing.isEmpty()) {
            return null;
        }
        Object firstArgument = this.getFirstArgument();
        if (firstArgument instanceof String) {
            return this.matchesInCalls(enclosing, (String)firstArgument, pattern);
        }
        if (firstArgument == null) {
            return this.asCallList(enclosing);
        }
        return this.matchOnPointcutArgument((IPointcut)firstArgument, pattern, this.asCallList(enclosing));
    }

    private List<MethodCallExpression> asCallList(List<VariableScope.CallAndType> enclosing) {
        ArrayList<MethodCallExpression> types = new ArrayList<MethodCallExpression>(enclosing.size());
        for (VariableScope.CallAndType callAndType : enclosing) {
            types.add(callAndType.call);
        }
        return types;
    }

    private List<MethodCallExpression> matchesInCalls(List<VariableScope.CallAndType> enclosing, String callName, GroovyDSLDContext pattern) {
        ArrayList<MethodCallExpression> calls = null;
        for (VariableScope.CallAndType callAndType : enclosing) {
            if (callName != null && !callName.equals(callAndType.call.getMethodAsString())) continue;
            if (calls == null) {
                calls = new ArrayList<MethodCallExpression>(1);
            }
            calls.add(callAndType.call);
        }
        return calls;
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String hasOneOrNoArgs = this.hasOneOrNoArgs();
        if (hasOneOrNoArgs != null) {
            throw new PointcutVerificationException(hasOneOrNoArgs, this);
        }
        super.verify();
    }
}

