/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnclosingCallDeclaringTypePointcut
extends AbstractPointcut {
    public EnclosingCallDeclaringTypePointcut(IStorage containerIdentifier, String pointcutName) {
        super(containerIdentifier, pointcutName);
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext pattern, Object toMatch) {
        List enclosing = pattern.getCurrentScope().getAllEnclosingMethodCallExpressions();
        if (enclosing == null) {
            return null;
        }
        Object firstArgument = this.getFirstArgument();
        if (firstArgument == null) {
            List allEnclosingMethodCallExpressions = pattern.getCurrentScope().getAllEnclosingMethodCallExpressions();
            if (allEnclosingMethodCallExpressions != null && allEnclosingMethodCallExpressions.size() > 0) {
                ArrayList<ClassNode> enclosingCallTypes = new ArrayList<ClassNode>(allEnclosingMethodCallExpressions.size());
                for (VariableScope.CallAndType callAndType : allEnclosingMethodCallExpressions) {
                    enclosingCallTypes.add(callAndType.declaringType);
                }
                return enclosingCallTypes;
            }
            return null;
        }
        if (firstArgument instanceof Class) {
            firstArgument = ((Class)firstArgument).getName();
        }
        if (firstArgument instanceof String) {
            ClassNode matchingType = this.matchesInCalls(enclosing, (String)firstArgument, pattern);
            if (matchingType != null) {
                return Collections.singleton(matchingType);
            }
            return null;
        }
        return this.matchOnPointcutArgument((IPointcut)firstArgument, pattern, this.asTypeList(enclosing));
    }

    private List<ClassNode> asTypeList(List<VariableScope.CallAndType> enclosing) {
        ArrayList<ClassNode> types = new ArrayList<ClassNode>(enclosing.size());
        for (VariableScope.CallAndType callAndType : enclosing) {
            types.add(callAndType.declaringType);
        }
        return types;
    }

    private ClassNode matchesInCalls(List<VariableScope.CallAndType> enclosing, String typeName, GroovyDSLDContext pattern) {
        for (VariableScope.CallAndType callAndType : enclosing) {
            if (!callAndType.declaringType.getName().equals(typeName)) continue;
            return callAndType.declaringType;
        }
        return null;
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String result = this.hasNoArgs();
        if (result == null) {
            return;
        }
        result = this.oneStringOrOnePointcutOrOneClassArg();
        if (result != null) {
            throw new PointcutVerificationException(result, this);
        }
        super.verify();
    }
}

