/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.FilteringPointcut;
import org.eclipse.core.resources.IStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractModifierPointcut
extends FilteringPointcut<AnnotatedNode> {
    private final int modifier;

    public AbstractModifierPointcut(IStorage containerIdentifier, String pointcutName, int modifier) {
        super(containerIdentifier, pointcutName, AnnotatedNode.class);
        this.modifier = modifier;
    }

    @Override
    protected AnnotatedNode filterObject(AnnotatedNode result, GroovyDSLDContext pattern, String firstArgAsString) {
        boolean success = false;
        if (result instanceof ClassNode) {
            success = (((ClassNode)result).getModifiers() & this.modifier) != 0;
        } else if (result instanceof FieldNode) {
            success = (((FieldNode)result).getModifiers() & this.modifier) != 0;
        } else if (result instanceof MethodNode) {
            success = (((MethodNode)result).getModifiers() & this.modifier) != 0;
        } else if (result instanceof PropertyNode) {
            success = (((PropertyNode)result).getModifiers() & this.modifier) != 0;
        }
        return success ? result : null;
    }

    @Override
    public void verify() throws PointcutVerificationException {
        if (this.getArgumentValues().length > 0) {
            throw new PointcutVerificationException("This pointcut does not take any arguments.", this);
        }
    }

    public static class FinalPointcut
    extends AbstractModifierPointcut {
        public FinalPointcut(IStorage containerIdentifier, String pointcutName) {
            super(containerIdentifier, pointcutName, 16);
        }
    }

    public static class PrivatePointcut
    extends AbstractModifierPointcut {
        public PrivatePointcut(IStorage containerIdentifier, String pointcutName) {
            super(containerIdentifier, pointcutName, 2);
        }
    }

    public static class PublicPointcut
    extends AbstractModifierPointcut {
        public PublicPointcut(IStorage containerIdentifier, String pointcutName) {
            super(containerIdentifier, pointcutName, 1);
        }
    }

    public static class StaticPointcut
    extends AbstractModifierPointcut {
        public StaticPointcut(IStorage containerIdentifier, String pointcutName) {
            super(containerIdentifier, pointcutName, 8);
        }
    }

    public static class SynchronizedPointcut
    extends AbstractModifierPointcut {
        public SynchronizedPointcut(IStorage containerIdentifier, String pointcutName) {
            super(containerIdentifier, pointcutName, 32);
        }
    }
}

