/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringObjectVector {
    static int INITIAL_SIZE = 10;
    public int size;
    public int maxSize;
    private String[] names;
    private Object[] elements;
    private Map<String, Object> cachedMap;

    public StringObjectVector(int initialSize) {
        this.maxSize = initialSize > 0 ? initialSize : INITIAL_SIZE;
        this.size = 0;
        this.elements = new Object[this.maxSize];
        this.names = new String[this.maxSize];
    }

    public void add(String newName, Object newElement) {
        if (this.size == this.maxSize) {
            this.elements = new Object[this.maxSize *= 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.size);
            this.names = new String[this.maxSize];
            System.arraycopy(this.names, 0, this.names, 0, this.size);
        }
        this.names[this.size] = newName;
        this.elements[this.size++] = newElement;
        this.cachedMap = null;
    }

    public void setElement(Object newElement, int index) {
        this.elements[index] = newElement;
        this.cachedMap = null;
    }

    public boolean contains(Object element) {
        if (element == null) {
            int i = this.size;
            while (--i >= 0) {
                if (this.elements[i] != null) continue;
                return true;
            }
        } else {
            int i = this.size;
            while (--i >= 0) {
                if (!element.equals(this.elements[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsName(String name) {
        if (name == null) {
            int i = this.size;
            while (--i >= 0) {
                if (this.names[i] != null) continue;
                return true;
            }
        } else {
            int i = this.size;
            while (--i >= 0) {
                if (!name.equals(this.names[i])) continue;
                return true;
            }
        }
        return false;
    }

    public Object elementAt(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.elements[index];
    }

    public Object find(String name) {
        if (name == null) {
            int i = this.size;
            while (--i >= 0) {
                if (this.names[i] != null) continue;
                return this.elements[i];
            }
        } else {
            int i = this.size;
            while (--i >= 0) {
                if (!name.equals(this.names[i])) continue;
                return this.elements[i];
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.formattedString(sb, 0);
        return sb.toString();
    }

    public String nameAt(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.names[index];
    }

    public Object[] getElements() {
        Object[] res = new Object[this.size];
        System.arraycopy(this.elements, 0, res, 0, this.size);
        return res;
    }

    public String[] getNames() {
        String[] res = new String[this.size];
        System.arraycopy(this.names, 0, res, 0, this.size);
        return res;
    }

    public String nameOf(Object arg) {
        int i = 0;
        while (i < this.size) {
            if (this.elements[i] == arg) {
                return this.names[i];
            }
            ++i;
        }
        return null;
    }

    Map<String, Object> asMap() {
        if (this.cachedMap == null) {
            this.cachedMap = new HashMap<String, Object>();
            int i = 0;
            while (i < this.size) {
                if (this.names[i] != null) {
                    this.cachedMap.put(this.names[i], this.elements[i]);
                }
                ++i;
            }
        }
        return this.cachedMap;
    }

    void formattedString(StringBuilder sb, int indent) {
        String spaces = AbstractPointcut.spaces(indent);
        if (this.size > 0) {
            sb.append(String.valueOf(spaces) + "\n");
            int i = 0;
            while (i < this.size) {
                sb.append(spaces);
                if (this.names[i] != null) {
                    sb.append(this.names[i]).append(" = ");
                }
                if (this.elements[i] instanceof AbstractPointcut) {
                    ((AbstractPointcut)this.elements[i]).formatedString(sb, indent + 2);
                } else {
                    sb.append(this.elements[i]);
                }
                ++i;
            }
        }
    }
}

