/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.contributions.DSLContributionGroup;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.codehaus.groovy.eclipse.dsl.pointcuts.StringObjectVector;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.AndPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.NotPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.impl.OrPointcut;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPointcut
implements IPointcut {
    private IStorage containerIdentifier;
    private StringObjectVector elements = new StringObjectVector(1);
    private IProject project;
    private String pointcutName;

    public AbstractPointcut(IStorage containerIdentifier, String pointcutName) {
        this.containerIdentifier = containerIdentifier;
        this.pointcutName = pointcutName;
    }

    @Override
    public String getPointcutName() {
        return this.pointcutName;
    }

    public void setPointcutName(String pointcutName) {
        this.pointcutName = pointcutName;
    }

    @Override
    public String getPointcutDebugName() {
        return String.valueOf(this.pointcutName) + " (" + this.getClass().getSimpleName() + ")";
    }

    @Override
    public IStorage getContainerIdentifier() {
        return this.containerIdentifier;
    }

    public void setContainerIdentifier(IStorage containerIdentifier) {
        this.containerIdentifier = containerIdentifier;
    }

    @Override
    public void verify() throws PointcutVerificationException {
        if (this.elements.size > 1) {
            throw new PointcutVerificationException("Can't have more than one argument to this pointcut", this);
        }
    }

    @Override
    public final void addArgument(Object argument) {
        this.elements.add(null, argument);
    }

    @Override
    public abstract Collection<?> matches(GroovyDSLDContext var1, Object var2);

    @Override
    public final void addArgument(String name, Object argument) {
        if (name == null) {
            this.addArgument(argument);
            return;
        }
        this.elements.add(name, argument);
    }

    protected Collection<?> matchOnPointcutArgument(IPointcut argument, GroovyDSLDContext pattern, Collection<?> allElementsToMatch) {
        if (allElementsToMatch == null) {
            return null;
        }
        LinkedHashSet outerResults = new LinkedHashSet();
        for (Object toMatch : allElementsToMatch) {
            Collection<?> innerResults = argument.matches(pattern, toMatch);
            if (innerResults == null) continue;
            String bindingName = this.getArgumentName(argument);
            if (bindingName != null) {
                pattern.addToBinding(bindingName, innerResults);
            }
            outerResults.add(toMatch);
        }
        return outerResults.size() > 0 ? outerResults : null;
    }

    protected Collection<?> matchOnPointcutArgumentReturnInner(IPointcut argument, GroovyDSLDContext pattern, Collection<?> allElementsToMatch) {
        String bindingName = this.getArgumentName(argument);
        HashSet innerResults = new HashSet();
        for (Object toMatch : allElementsToMatch) {
            Collection<?> tempInnerResults = argument.matches(pattern, toMatch);
            if (tempInnerResults == null) continue;
            innerResults.addAll(tempInnerResults);
        }
        if (bindingName != null && innerResults.size() > 0) {
            pattern.addToBinding(bindingName, innerResults);
        }
        return innerResults != null && innerResults.size() > 0 ? innerResults : null;
    }

    protected Collection<?> flatten(Map<Object, Collection<?>> pointcutResult) {
        HashSet newCollection = new HashSet(pointcutResult.size());
        for (Collection<?> collection : pointcutResult.values()) {
            newCollection.addAll(collection);
        }
        return newCollection;
    }

    @Override
    public final Object getFirstArgument() {
        if (this.elements.size > 0) {
            return this.elements.elementAt(0);
        }
        return null;
    }

    @Override
    public final String[] getArgumentNames() {
        return this.elements.getNames();
    }

    @Override
    public final Object[] getArgumentValues() {
        return this.elements.getElements();
    }

    public final String getArgumentName(Object argument) {
        int i = 0;
        while (i < this.elements.size) {
            if (this.elements.elementAt(i) == argument) {
                return this.elements.nameAt(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public final String getFirstArgumentName() {
        if (this.elements.size > 0) {
            return this.elements.nameAt(0);
        }
        return null;
    }

    public final String getNameForArgument(Object arg) {
        return this.elements.nameOf(arg);
    }

    @Override
    public IPointcut normalize() {
        int i = 0;
        while (i < this.elements.size) {
            Object elt = this.elements.elementAt(i);
            if (elt instanceof IPointcut) {
                this.elements.setElement(((IPointcut)elt).normalize(), i);
            }
            ++i;
        }
        return this;
    }

    @Override
    public boolean fastMatch(GroovyDSLDContext pattern) {
        Object[] objectArray = this.elements.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object elt = objectArray[n2];
            if (elt instanceof IPointcut && !((IPointcut)elt).fastMatch(pattern)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    public void accept(Closure contributionGroupClosure) {
        block4: {
            DSLContributionGroup group = new DSLContributionGroup(contributionGroupClosure);
            if (this.project != null) {
                try {
                    this.verify();
                    IProject p = this.project;
                    IPointcut normalized = this.normalize();
                    if (GroovyLogManager.manager.hasLoggers()) {
                        GroovyLogManager.manager.log(TraceCategory.DSL, "Registering pointcut:\n" + this.toString());
                    }
                    GroovyDSLCoreActivator.getDefault().getContextStoreManager().getDSLDStore(p).addContributionGroup(normalized, group);
                }
                catch (PointcutVerificationException e) {
                    if (!GroovyLogManager.manager.hasLoggers()) break block4;
                    GroovyLogManager.manager.log(TraceCategory.DSL, "Ignoring invalid pointcut");
                    GroovyLogManager.manager.log(TraceCategory.DSL, e.getPointcutMessage());
                    GroovyLogManager.manager.logException(TraceCategory.DSL, (Throwable)e);
                }
            }
        }
    }

    protected final String allArgsArePointcuts() throws PointcutVerificationException {
        Object[] objectArray = this.elements.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg != null) {
                if (!(arg instanceof IPointcut)) {
                    return "All arguments should be pointcuts";
                }
                ((IPointcut)arg).verify();
            }
            ++n2;
        }
        return null;
    }

    protected final String matchesArgNumber(int num) {
        Object[] elements2 = this.elements.getElements();
        if (elements2.length == num) {
            return null;
        }
        return "Expecting " + num + " arguments, but found " + elements2.length;
    }

    protected final String hasOneArg() {
        if (this.elements.getElements().length == 1) {
            return null;
        }
        return "Expecting 1 argument, but found " + this.elements.getElements().length + ".  Consider using '&' or '|' to connect arguments.";
    }

    protected final String hasOneOrNoArgs() {
        if (this.elements.getElements().length <= 1) {
            return null;
        }
        return "Expecting 1 or no arguments, but found " + this.elements.getElements().length + ".  Consider using '&' or '|' to connect arguments.";
    }

    protected final String hasNoArgs() {
        if (this.elements.getElements().length == 0) {
            return null;
        }
        return "Expecting no arguments, but found " + this.elements.getElements().length + ".  Consider using '&' or '|' to connect arguments.";
    }

    protected final String allArgsAreStrings() {
        Object[] objectArray = this.elements.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg != null && !(arg instanceof String)) {
                return "All arguments should be strings";
            }
            ++n2;
        }
        return null;
    }

    protected final String oneStringOrOnePointcutArg() throws PointcutVerificationException {
        String maybeStatus = this.allArgsAreStrings();
        String maybeStatus2 = this.allArgsArePointcuts();
        if (maybeStatus != null && maybeStatus2 != null) {
            return "This pointcut supports exactly one argument of type Pointcut or String.  Consider using '&' or '|' to connect arguments.";
        }
        maybeStatus = this.hasOneArg();
        if (maybeStatus != null) {
            return maybeStatus;
        }
        return null;
    }

    protected final String oneStringOrOnePointcutOrOneClassArg() throws PointcutVerificationException {
        String maybeStatus = this.allArgsAreStrings();
        String maybeStatus2 = this.allArgsArePointcuts();
        String maybeStatus3 = this.allArgsAreClasses();
        if (maybeStatus != null && maybeStatus2 != null && maybeStatus3 != null) {
            return "This pointcut supports exactly one argument of type Pointcut or String or Class.  Consider using '&' or '|' to connect arguments.";
        }
        maybeStatus = this.hasOneArg();
        if (maybeStatus != null) {
            return maybeStatus;
        }
        return null;
    }

    protected final String allArgsAreClasses() {
        Object[] objectArray = this.elements.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg != null && !(arg instanceof Class)) {
                return "All arguments should be classes";
            }
            ++n2;
        }
        return null;
    }

    protected IPointcut and(IPointcut other) {
        AndPointcut andPointcut = new AndPointcut(this.containerIdentifier, "and");
        andPointcut.setProject(this.project);
        andPointcut.addArgument(this);
        andPointcut.addArgument(other);
        return andPointcut;
    }

    protected IPointcut or(IPointcut other) {
        OrPointcut orPointcut = new OrPointcut(this.containerIdentifier, "or");
        orPointcut.setProject(this.project);
        orPointcut.addArgument(this);
        orPointcut.addArgument(other);
        return orPointcut;
    }

    protected IPointcut bitwiseNegate() {
        NotPointcut notPointcut = new NotPointcut(this.containerIdentifier, "not");
        notPointcut.setProject(this.project);
        notPointcut.addArgument(this);
        return notPointcut;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(" + this.containerIdentifier + ")\n");
        this.formatedString(sb, 2);
        return sb.toString();
    }

    protected void formatedString(StringBuilder sb, int indent) {
        sb.append(this.getPointcutDebugName());
        this.elements.formattedString(sb, indent + 2);
        sb.append("\n");
    }

    static String spaces(int indent) {
        StringBuilder sb = new StringBuilder(indent + 2);
        int i = 0;
        while (i < indent) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    protected Map<String, Object> namedArgumentsAsMap() {
        return this.elements.asMap();
    }

    protected Collection<?> ensureCollection(Object toMatch) {
        if (toMatch == null) {
            return null;
        }
        return toMatch instanceof Collection ? (Set<Object>)toMatch : Collections.singleton(toMatch);
    }
}

