/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.lookup;

import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.groovy.search.VariableScope;

public class ResolverCache {
    private final Map<String, ClassNode> nameTypeCache = new WeakHashMap<String, ClassNode>();
    private final JDTResolver resolver;

    public ResolverCache(JDTResolver resolver, ModuleNode thisModule) {
        this.resolver = resolver;
    }

    public ClassNode resolve(String qName) {
        if (qName == null || qName.length() == 0) {
            return ClassHelper.DYNAMIC_TYPE;
        }
        if ((qName = qName.trim()).equals("java.lang.Void") || qName.equals("void")) {
            return VariableScope.VOID_CLASS_NODE;
        }
        ClassNode clazz = this.nameTypeCache.get(qName);
        int arrayCnt = 0;
        if (clazz == null && this.resolver != null) {
            String componentName;
            int typeParamEnd = qName.lastIndexOf(62);
            int arrayStart = qName.indexOf(91, typeParamEnd);
            if (arrayStart > 0) {
                componentName = qName.substring(0, arrayStart);
                arrayCnt = this.calculateArrayCount(qName, arrayStart);
            } else {
                componentName = qName;
            }
            String erasureName = componentName;
            int typeParamStart = -1;
            if (typeParamEnd > 0 && (typeParamStart = componentName.indexOf(60)) > 0) {
                erasureName = componentName.substring(0, typeParamStart);
            }
            if ((clazz = this.resolver.resolve(erasureName)) == null) {
                clazz = VariableScope.OBJECT_CLASS_NODE;
            }
            this.nameTypeCache.put(erasureName, clazz);
            if (typeParamStart > 0) {
                clazz = VariableScope.clone((ClassNode)clazz);
                String[] typeParameterNames = componentName.substring(typeParamStart + 1, componentName.length() - 1).split(",");
                ClassNode[] typeParameters = new ClassNode[typeParameterNames.length];
                int i = 0;
                while (i < typeParameterNames.length) {
                    typeParameters[i] = this.resolve(typeParameterNames[i]);
                    ++i;
                }
                GenericsType[] genericsTypes = (clazz = VariableScope.clone((ClassNode)clazz)).getGenericsTypes();
                if (genericsTypes != null) {
                    int i2 = 0;
                    while (i2 < genericsTypes.length && i2 < typeParameters.length) {
                        genericsTypes[i2].setType(typeParameters[i2]);
                        genericsTypes[i2].setName(typeParameters[i2].getName());
                        ++i2;
                    }
                    this.nameTypeCache.put(componentName, clazz);
                }
            }
            while (arrayCnt > 0) {
                clazz = new ClassNode(clazz);
                componentName = String.valueOf(componentName) + "[]";
                this.nameTypeCache.put(componentName, clazz);
                --arrayCnt;
            }
        }
        return clazz;
    }

    private int calculateArrayCount(String qName, int arrayStart) {
        if (arrayStart < 0) {
            return 0;
        }
        int cnt = 1;
        while ((arrayStart = qName.indexOf(91, arrayStart + 1)) > 0) {
            ++cnt;
        }
        return cnt;
    }
}

