/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.lookup;

import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.DSLDStoreManager;
import org.codehaus.groovy.eclipse.dsl.DSLPreferences;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.groovy.search.AbstractSimplifiedTypeLookup;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.ITypeResolver;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class DSLDTypeLookup
extends AbstractSimplifiedTypeLookup
implements ITypeLookup,
ITypeResolver {
    private static final String GORM_SIGNATURE = "Provided by Grails ORM DSL";
    DSLDStoreManager contextStoreManager = GroovyDSLCoreActivator.getDefault().getContextStoreManager();
    private DSLDStore store;
    private GroovyDSLDContext pattern;
    private Set<String> disabledScriptsAsSet;
    private ModuleNode module;
    private JDTResolver resolver;

    public void setResolverInformation(ModuleNode module, JDTResolver resolver) {
        this.module = module;
        this.resolver = resolver;
    }

    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
        IProject project = unit.getJavaProject().getProject();
        this.contextStoreManager.ensureInitialized(project, true);
        this.disabledScriptsAsSet = DSLPreferences.getDisabledScriptsAsSet();
        try {
            this.pattern = new GroovyDSLDContext(unit, this.module, this.resolver);
            this.pattern.setCurrentScope(topLevelScope);
        }
        catch (CoreException e) {
            GroovyDSLCoreActivator.logException(e);
        }
        this.store = this.contextStoreManager.getDSLDStore(unit.getJavaProject());
        this.store = this.store.createSubStore(this.pattern);
    }

    protected AbstractSimplifiedTypeLookup.TypeAndDeclaration lookupTypeAndDeclaration(ClassNode declaringType, String name, VariableScope scope) {
        this.pattern.setCurrentScope(scope);
        this.pattern.setTargetType(declaringType);
        this.pattern.setStatic(this.isStatic());
        List<IContributionElement> elts = this.store.findContributions(this.pattern, this.disabledScriptsAsSet);
        declaringType = this.pattern.getCurrentType();
        for (IContributionElement elt : elts) {
            AbstractSimplifiedTypeLookup.TypeAndDeclaration td = elt.lookupType(name, declaringType, this.pattern.getResolverCache());
            if (td == null) continue;
            return td;
        }
        return null;
    }

    public void lookupInBlock(BlockStatement node, VariableScope scope) {
        this.pattern.setCurrentScope(scope);
        ClassNode delegateOrThis = scope.getDelegateOrThis();
        if (delegateOrThis != null) {
            this.pattern.setTargetType(delegateOrThis);
            this.pattern.setStatic(this.isStatic());
            this.store.findContributions(this.pattern, this.disabledScriptsAsSet);
        }
    }

    protected TypeLookupResult.TypeConfidence confidence() {
        return TypeLookupResult.TypeConfidence.INFERRED;
    }

    protected TypeLookupResult.TypeConfidence checkConfidence(Expression node, TypeLookupResult.TypeConfidence originalConfidence, ASTNode declaration, String extraDoc) {
        TypeLookupResult.TypeConfidence confidence;
        TypeLookupResult.TypeConfidence typeConfidence = confidence = originalConfidence == null ? this.confidence() : originalConfidence;
        if (declaration instanceof MethodNode && extraDoc != null && extraDoc.contains(GORM_SIGNATURE)) {
            confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
        }
        return confidence;
    }
}

