/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer;

import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovyMethodSuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovySuggestionDeclaringType;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer.TransformElement;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer.TransformElementProperty;

public class TransformElementFactory {
    public TransformElement getSuggestionsElement(IGroovySuggestion suggestion) {
        if (suggestion == null) {
            return null;
        }
        GroovyMethodSuggestion methodSuggestion = suggestion instanceof GroovyMethodSuggestion ? (GroovyMethodSuggestion)suggestion : null;
        String elementName = methodSuggestion != null ? "method" : "property";
        TransformElement suggestionsElement = new TransformElement(elementName, null);
        suggestionsElement.addProperty("name", suggestion.getName());
        suggestionsElement.addProperty("type", suggestion.getType());
        suggestionsElement.addProperty("isStatic", String.valueOf(suggestion.isStatic()));
        suggestionsElement.addProperty("isActive", String.valueOf(suggestion.isActive()));
        if (methodSuggestion != null) {
            TransformElement argumentsElement = new TransformElement("parameters", null);
            suggestionsElement.addChild(argumentsElement);
            argumentsElement.addProperty("useNamedArguments", String.valueOf(methodSuggestion.useNamedArguments()));
            List<MethodParameter> parameters = methodSuggestion.getParameters();
            if (parameters != null) {
                for (MethodParameter parameter : parameters) {
                    TransformElement parameterElement = new TransformElement("parameter", null);
                    parameterElement.addProperty("name", parameter.getName());
                    parameterElement.addProperty("type", parameter.getType());
                    argumentsElement.addChild(parameterElement);
                }
            }
        }
        TransformElement javadocElement = new TransformElement("doc", suggestion.getJavaDoc());
        suggestionsElement.addChild(javadocElement);
        return suggestionsElement;
    }

    public TransformElement getRootElement() {
        return new TransformElement("projectSuggestions", null);
    }

    public TransformElement getDeclaringTypeWriterElement(GroovySuggestionDeclaringType declaringType) {
        if (declaringType == null) {
            return null;
        }
        TransformElement declaringTypeElement = new TransformElement("declaringtype", null);
        TransformElementProperty property = new TransformElementProperty("type", declaringType.getName());
        declaringTypeElement.addProperty(property);
        List<IGroovySuggestion> suggestions = declaringType.getSuggestions();
        for (IGroovySuggestion suggestion : suggestions) {
            TransformElement suggestionElement = this.getSuggestionsElement(suggestion);
            declaringTypeElement.addChild(suggestionElement);
        }
        return declaringTypeElement;
    }
}

