/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer;

import java.io.Writer;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovySuggestionDeclaringType;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.InferencingSuggestionsManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer.TransformElement;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer.TransformElementFactory;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer.TransformElementProperty;
import org.codehaus.groovy.runtime.StringBufferWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SuggestionsTransform {
    private InferencingSuggestionsManager.ProjectSuggestions suggestions;

    public SuggestionsTransform(InferencingSuggestionsManager.ProjectSuggestions suggestions) {
        this.suggestions = suggestions;
    }

    public String transform() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            TransformElementFactory elementFactory = new TransformElementFactory();
            TransformElement rootElement = elementFactory.getRootElement();
            Element root = document.createElement(rootElement.getElementName());
            document.appendChild(root);
            for (GroovySuggestionDeclaringType declaringType : this.suggestions.getDeclaringTypes()) {
                TransformElement element = elementFactory.getDeclaringTypeWriterElement(declaringType);
                this.transform(element, root, document);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StringBuffer buffer = new StringBuffer();
            StringBufferWriter bufferWriter = new StringBufferWriter(buffer);
            StreamResult result = new StreamResult((Writer)bufferWriter);
            transformer.transform(source, result);
            return buffer.toString();
        }
        catch (TransformerConfigurationException e) {
            GroovyDSLCoreActivator.logException(e);
        }
        catch (IllegalArgumentException e) {
            GroovyDSLCoreActivator.logException(e);
        }
        catch (ParserConfigurationException e) {
            GroovyDSLCoreActivator.logException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            GroovyDSLCoreActivator.logException(e);
        }
        catch (TransformerException e) {
            GroovyDSLCoreActivator.logException(e);
        }
        return null;
    }

    protected void transform(TransformElement element, Node parent, Document document) {
        List<TransformElement> children;
        String name = element.getElementName();
        Element node = document.createElement(name);
        String elementValue = element.getValue();
        if (elementValue != null) {
            node.setTextContent(element.getValue());
        }
        parent.appendChild(node);
        List<TransformElementProperty> properties = element.getProperties();
        if (properties != null) {
            NamedNodeMap attributes = node.getAttributes();
            for (TransformElementProperty property : properties) {
                Attr attr = document.createAttribute(property.getName());
                attr.setValue(property.getValue());
                attributes.setNamedItem(attr);
            }
        }
        if ((children = element.getChildren()) != null) {
            for (TransformElement child : children) {
                this.transform(child, node, document);
            }
        }
    }
}

