/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.InferencingSuggestionsManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionDescriptor;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsReader {
    private String absoluteFile;
    private InferencingSuggestionsManager.ProjectSuggestions projectSuggestions;

    public SuggestionsReader(IProject project, String absoluteFile) {
        this.projectSuggestions = InferencingSuggestionsManager.getInstance().getSuggestions(project);
        this.absoluteFile = absoluteFile;
    }

    public InferencingSuggestionsManager.ProjectSuggestions read() {
        block7: {
            if (this.absoluteFile != null && this.projectSuggestions != null) break block7;
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            BufferedReader reader = new BufferedReader(new FileReader(this.absoluteFile));
            Document document = parser.parse(new InputSource(reader));
            if (document != null) {
                NodeList declaringTypeList;
                Element element;
                Node node;
                this.projectSuggestions = this.projectSuggestions.registerNewProjectSuggestion();
                NodeList list = document.getChildNodes();
                if (list.getLength() > 0 && (node = list.item(0)) instanceof Element && (element = (Element)node).getNodeName().equals("projectSuggestions") && (declaringTypeList = element.getChildNodes()) != null) {
                    this.handleDeclaringTypeNodes(declaringTypeList);
                }
            }
            return this.projectSuggestions;
        }
        catch (ParserConfigurationException e) {
            GroovyDSLCoreActivator.logException(e);
        }
        catch (IOException e) {
            GroovyDSLCoreActivator.logException(e);
        }
        catch (SAXException e) {
            GroovyDSLCoreActivator.logException(e);
        }
        return null;
    }

    protected void handleDeclaringTypeNodes(NodeList list) {
        int i = 0;
        while (i < list.getLength()) {
            Element element;
            Node node = list.item(i);
            if (node instanceof Element && (element = (Element)node).getNodeName().equals("declaringtype")) {
                String declaringTypeName = element.getAttribute("type");
                NodeList suggestions = element.getChildNodes();
                int j = 0;
                while (j < suggestions.getLength()) {
                    SuggestionDescriptor descriptor;
                    Node suggNode = suggestions.item(j);
                    if (suggNode instanceof Element && (descriptor = this.getSuggestionDescriptor((Element)suggNode, declaringTypeName)) != null) {
                        this.projectSuggestions.addSuggestion(descriptor);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected SuggestionDescriptor getSuggestionDescriptor(Element element, String declaringTypeName) {
        if (element.getNodeName().equals("method") || element.getNodeName().equals("property")) {
            Node docNode;
            String suggestionName = element.getAttribute("name");
            String suggestionType = element.getAttribute("type");
            boolean isStatic = new Boolean(element.getAttribute("isStatic"));
            boolean isActive = new Boolean(element.getAttribute("isActive"));
            NodeList docNodes = element.getElementsByTagName("doc");
            String doc = null;
            if (docNodes != null && docNodes.getLength() > 0 && (docNode = docNodes.item(0)) instanceof Element) {
                Element docElement = (Element)docNode;
                doc = docElement.getNodeValue();
            }
            SuggestionDescriptor descriptor = null;
            if (element.getNodeName().equals("method")) {
                Element parametersElement = this.getParametersElement(element);
                boolean useNameArguments = false;
                if (parametersElement != null) {
                    useNameArguments = new Boolean(parametersElement.getAttribute("useNamedArguments"));
                }
                List<MethodParameter> modelParameters = this.getParameters(parametersElement);
                descriptor = new SuggestionDescriptor(declaringTypeName, isStatic, suggestionName, doc, suggestionType, useNameArguments, modelParameters, isActive);
            } else {
                descriptor = new SuggestionDescriptor(declaringTypeName, isStatic, suggestionName, doc, suggestionType, isActive);
            }
            return descriptor;
        }
        return null;
    }

    protected Element getParametersElement(Element element) {
        Node node = element.getFirstChild();
        if (node.getNodeName().equals("parameters") && node instanceof Element) {
            return (Element)node;
        }
        return null;
    }

    protected List<MethodParameter> getParameters(Element parametersElement) {
        if (parametersElement == null) {
            return null;
        }
        ArrayList<MethodParameter> parameters = new ArrayList<MethodParameter>();
        NodeList parametersNodeList = parametersElement.getChildNodes();
        if (parametersNodeList != null) {
            int i = 0;
            while (i < parametersNodeList.getLength()) {
                Node paramNode = parametersNodeList.item(i);
                if (paramNode instanceof Element && paramNode.getNodeName().equals("parameter")) {
                    Element paramElement = (Element)paramNode;
                    String nameParam = paramElement.getAttribute("name");
                    String typeParam = paramElement.getAttribute("type");
                    parameters.add(new MethodParameter(nameParam, typeParam));
                }
                ++i;
            }
        }
        return parameters;
    }
}

