/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.AbstractControlManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlDescriptor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioSelectionDialogueControl
extends AbstractControlManager {
    private IDialogueControlDescriptor[] radioValues;
    private IDialogueControlDescriptor defaultValue;

    protected RadioSelectionDialogueControl(IDialogueControlDescriptor[] radioValues, IDialogueControlDescriptor defaultValue) {
        this.radioValues = radioValues;
        this.defaultValue = defaultValue;
    }

    @Override
    protected Map<Control, IDialogueControlDescriptor> createManagedControls(Composite parent) {
        Composite buttonArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(buttonArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonArea);
        HashMap<Control, IDialogueControlDescriptor> controls = new HashMap<Control, IDialogueControlDescriptor>();
        IDialogueControlDescriptor[] iDialogueControlDescriptorArray = this.radioValues;
        int n = this.radioValues.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogueControlDescriptor descriptor = iDialogueControlDescriptorArray[n2];
            String buttonLabel = descriptor.getLabel();
            if (buttonLabel != null && buttonLabel.length() != 0) {
                final Button button = new Button(buttonArea, 16);
                button.setText(buttonLabel);
                GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)button);
                button.setSelection(false);
                if (button != null) {
                    controls.put((Control)button, descriptor);
                    button.setData((Object)descriptor);
                    String toolTipText = descriptor.getToolTipText();
                    if (toolTipText != null) {
                        button.setToolTipText(toolTipText);
                    }
                    if (buttonLabel.equals(this.defaultValue.getLabel())) {
                        button.setSelection(true);
                    }
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (button.getData() instanceof IDialogueControlDescriptor) {
                                RadioSelectionDialogueControl.this.notifyControlChange(button.getData(), (Control)button);
                            }
                        }
                    });
                }
            }
            ++n2;
        }
        return controls;
    }
}

