/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IProjectUIControl;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ISelectionHandler;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ProjectDisplayControl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDropDownControl
extends ProjectDisplayControl {
    private List<IProject> projects;
    private Combo dropDown;
    private ISelectionHandler handler;

    protected ProjectDropDownControl(List<IProject> projects, Shell shell, Composite parent, ISelectionHandler handler) {
        super(shell, parent);
        this.projects = projects;
        this.handler = handler;
    }

    protected List<IProject> getProjects() {
        return this.projects;
    }

    public static IProjectUIControl getProjectSelectionControl(List<IProject> projects, Shell shell, Composite parent, ISelectionHandler handler) {
        ProjectDisplayControl control = null;
        if (projects == null || projects.size() <= 1) {
            control = new ProjectDisplayControl(shell, parent);
            if (projects.size() == 1) {
                control.setProject(projects.get(0));
            }
        } else {
            control = new ProjectDropDownControl(projects, shell, parent, handler);
        }
        return control;
    }

    @Override
    public void createProjectDisplayControl(Composite parent) {
        String[] projectNames = new String[this.projects.size()];
        int i = 0;
        while (i < projectNames.length && i < this.projects.size()) {
            projectNames[i] = this.projects.get(i).getName();
            ++i;
        }
        this.dropDown = new Combo(parent, 12);
        this.dropDown.setItems(projectNames);
        this.dropDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newSelection = ProjectDropDownControl.this.dropDown.getItem(ProjectDropDownControl.this.dropDown.getSelectionIndex());
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(newSelection);
                ProjectDropDownControl.super.setProject(project);
                ProjectDropDownControl.this.handleProjectChange(project);
            }
        });
        this.setProject(this.projects.get(0));
    }

    protected boolean isSelectionSame(IProject projectToSelect) {
        int selectionIndex = this.dropDown.getSelectionIndex();
        if (selectionIndex >= 0) {
            String currentSelection = this.dropDown.getItem(selectionIndex);
            return projectToSelect.getName().equals(currentSelection);
        }
        return projectToSelect == this.getProject();
    }

    @Override
    public IProject setProject(IProject projectToSelect) {
        if (projectToSelect == null || this.isSelectionSame(projectToSelect)) {
            return projectToSelect;
        }
        int selectedIndex = -1;
        String[] allProjects = this.dropDown.getItems();
        int i = 0;
        while (i < allProjects.length) {
            if (projectToSelect.getName().equals(allProjects[i])) {
                selectedIndex = i;
                break;
            }
            ++i;
        }
        if (selectedIndex >= 0) {
            this.dropDown.select(selectedIndex);
            super.setProject(projectToSelect);
            this.handleProjectChange(projectToSelect);
            return projectToSelect;
        }
        return null;
    }

    protected void handleProjectChange(IProject selectedProject) {
        if (this.handler != null) {
            this.handler.selectionChanged(selectedProject);
        }
    }
}

