/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IProjectUIControl;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ProjectDisplayControl
implements IProjectUIControl {
    private Shell shell;
    private Composite parent;
    private IProject project;
    protected static final String NO_PROJECT = "No Groovy project available.";

    protected ProjectDisplayControl(Shell shell, Composite parent) {
        this.shell = shell;
        this.parent = parent;
    }

    protected Shell getShell() {
        return this.shell;
    }

    public IProject getProject() {
        return this.project;
    }

    public Control createControls() {
        Composite projectComposite = new Composite(this.parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(projectComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)projectComposite);
        Label projectLabel = new Label(projectComposite, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)projectLabel);
        projectLabel.setText("Project: ");
        this.createProjectDisplayControl(projectComposite);
        return projectComposite;
    }

    protected void createProjectDisplayControl(Composite parent) {
        Label projectLabel = new Label(parent, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)projectLabel);
        String labelVal = this.project != null ? this.project.getName() : NO_PROJECT;
        projectLabel.setText(labelVal);
    }

    public IProject setProject(IProject project) {
        this.project = project;
        return project;
    }
}

