/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.AbstractControlManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ControlSelectionEvent;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ControlTypes;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.MethodParameterDialogue;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodParameterTable
extends AbstractControlManager {
    private List<MethodParameter> parameters;
    private TableViewer viewer;
    private IJavaProject project;
    private boolean useNamedArguments;

    public MethodParameterTable(IJavaProject project, List<MethodParameter> parameters, boolean useNamedArguments) {
        this.parameters = parameters;
        if (parameters == null) {
            this.parameters = new ArrayList<MethodParameter>();
        }
        this.project = project;
        this.useNamedArguments = useNamedArguments;
    }

    protected int getLabelRowColumns() {
        return 1;
    }

    protected IDialogueControlDescriptor[] getTableButtonDescriptors() {
        return new IDialogueControlDescriptor[]{ControlTypes.ADD, ControlTypes.REMOVE, ControlTypes.EDIT, ControlTypes.UP, ControlTypes.DOWN};
    }

    protected Map<Control, IDialogueControlDescriptor> createOperationButtonArea(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(2, 1).applyTo((Control)buttons);
        GridLayoutFactory.fillDefaults().applyTo(buttons);
        IDialogueControlDescriptor[] types = this.getTableButtonDescriptors();
        HashMap<Control, IDialogueControlDescriptor> opButtons = new HashMap<Control, IDialogueControlDescriptor>();
        IDialogueControlDescriptor[] iDialogueControlDescriptorArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogueControlDescriptor type = iDialogueControlDescriptorArray[n2];
            Button button = this.createSelectionButton(buttons, type);
            if (button != null) {
                opButtons.put((Control)button, type);
            }
            ++n2;
        }
        return opButtons;
    }

    protected Button createSelectionButton(Composite parent, IDialogueControlDescriptor type) {
        if (type == null) {
            return null;
        }
        Button button = new Button(parent, 8);
        button.setText(type.getLabel());
        button.setData((Object)type);
        Point minSize = button.computeSize(-1, -1, true);
        int widthHint = 0;
        GridDataFactory.fillDefaults().hint(Math.max(widthHint, minSize.x), -1).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof Button) {
                    IDialogueControlDescriptor descriptor = (IDialogueControlDescriptor)((Button)obj).getData();
                    MethodParameterTable.this.handleButtonSelection(descriptor);
                }
            }
        });
        return button;
    }

    protected void handleButtonSelection(IDialogueControlDescriptor type) {
        if (!(type instanceof ControlTypes)) {
            return;
        }
        ControlTypes controlType = (ControlTypes)type;
        switch (controlType) {
            case ADD: {
                this.addElement();
                break;
            }
            case REMOVE: {
                this.removeElement();
                break;
            }
            case EDIT: {
                this.editElement();
                break;
            }
            case UP: {
                int selectionIndex = this.viewer.getTable().getSelectionIndex();
                if (selectionIndex <= 0) break;
                MethodParameter element = this.parameters.remove(selectionIndex);
                this.parameters.add(selectionIndex - 1, element);
                this.refreshTable();
                break;
            }
            case DOWN: {
                int selectionIndex = this.viewer.getTable().getSelectionIndex();
                if (selectionIndex < 0 || selectionIndex >= this.parameters.size() - 1) break;
                MethodParameter element = this.parameters.remove(selectionIndex);
                this.parameters.add(selectionIndex + 1, element);
                this.refreshTable();
            }
        }
    }

    protected int getViewerConfiguration() {
        return 68354;
    }

    protected int getViewerHeightHint() {
        return 200;
    }

    protected TableViewer createTableViewer(Composite parent) {
        ColumnTypes[] values;
        Composite treeComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeComposite);
        GridLayoutFactory.fillDefaults().applyTo(treeComposite);
        Table table = new Table(treeComposite, this.getViewerConfiguration());
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.getViewerHeightHint()).applyTo((Control)table);
        this.viewer = new TableViewer(table);
        ColumnTypes[] columnTypesArray = values = ColumnTypes.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnTypes column = columnTypesArray[n2];
            if (column != null) {
                TableColumn tableColumn = new TableColumn(table, 0);
                tableColumn.setResizable(true);
                tableColumn.setText(column.getLabel());
                tableColumn.setWidth(column.getWeight());
            }
            ++n2;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.setTableProviders(this.viewer);
        return this.viewer;
    }

    protected void setTableProviders(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                int index = cell.getColumnIndex();
                cell.setText(this.getColumnText(element, index));
            }

            public String getColumnText(Object element, int index) {
                String text = null;
                if (element instanceof MethodParameter) {
                    ColumnTypes[] values = ColumnTypes.values();
                    if (index >= 0 && index < values.length) {
                        ColumnTypes type = values[index];
                        MethodParameter arg = (MethodParameter)element;
                        switch (type) {
                            case NAME: {
                                text = arg.getName();
                                break;
                            }
                            case TYPE: {
                                text = arg.getType();
                            }
                        }
                    }
                }
                return text;
            }
        });
        viewer.setInput(this.parameters);
    }

    protected MethodParameter getSelectedElement() {
        Object selectObj;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (selectObj = ((IStructuredSelection)selection).getFirstElement()) instanceof MethodParameter) {
            return (MethodParameter)selectObj;
        }
        return null;
    }

    protected MethodParameter getElement(int index) {
        if (index < this.viewer.getTable().getItemCount()) {
            return this.getArgumentElementFromSelectionObject(this.viewer.getElementAt(index));
        }
        return null;
    }

    protected void addElement() {
        MethodParameterDialogue dialogue = new MethodParameterDialogue(this.getShell(), this.project, null, this.parameters);
        if (dialogue.open() == 0) {
            MethodParameter parameter = dialogue.getMethodParameter();
            if (parameter != null) {
                int selectionIndex = this.viewer.getTable().getSelectionIndex();
                if (selectionIndex >= 0) {
                    this.parameters.add(selectionIndex, parameter);
                } else {
                    this.parameters.add(parameter);
                }
            }
            this.refreshTable();
        }
    }

    protected void editElement() {
        MethodParameterDialogue dialogue;
        MethodParameter selected = this.getSelectedElement();
        if (selected != null && (dialogue = new MethodParameterDialogue(this.getShell(), this.project, selected, this.parameters)).open() == 0) {
            MethodParameter editedParameter = dialogue.getMethodParameter();
            if (editedParameter != null) {
                int selectionIndex = this.viewer.getTable().getSelectionIndex();
                this.parameters.remove(selected);
                if (selectionIndex >= 0) {
                    this.parameters.add(selectionIndex, editedParameter);
                } else {
                    this.parameters.add(editedParameter);
                }
            }
            this.refreshTable();
        }
    }

    protected void removeElement() {
        MethodParameter selected = this.getSelectedElement();
        if (selected != null) {
            int i = 0;
            while (i < this.parameters.size()) {
                MethodParameter item = this.parameters.get(i);
                if (item.equals(selected)) {
                    this.parameters.remove(i);
                }
                ++i;
            }
        }
        this.refreshTable();
    }

    protected void refreshTable() {
        this.viewer.getTable().setFocus();
        this.viewer.setInput(this.parameters);
        this.viewer.refresh(true);
    }

    protected MethodParameter getArgumentElementFromSelectionObject(Object element) {
        TableItem item;
        Object dataOb;
        MethodParameter arg = null;
        if (element instanceof MethodParameter) {
            arg = (MethodParameter)element;
        } else if (element instanceof TableItem && (dataOb = (item = (TableItem)element).getData()) instanceof MethodParameter) {
            arg = (MethodParameter)dataOb;
        }
        return arg;
    }

    public void changeControlValue(ControlSelectionEvent event) {
    }

    protected Button createCheckButton(Composite parent, IDialogueControlDescriptor type) {
        if (type == null) {
            return null;
        }
        Button button = new Button(parent, 32);
        button.setText(type.getLabel());
        button.setData((Object)type);
        Point minSize = button.computeSize(-1, -1, true);
        int widthHint = 0;
        GridDataFactory.fillDefaults().hint(Math.max(widthHint, minSize.x), -1).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof Button) {
                    MethodParameterTable.this.notifyControlChange(new Boolean(((Button)obj).getSelection()), (Control)((Button)obj));
                }
            }
        });
        return button;
    }

    @Override
    protected Map<Control, IDialogueControlDescriptor> createManagedControls(Composite parent) {
        Button useNamedButton;
        Map<Control, IDialogueControlDescriptor> buttonControls;
        Composite viewerArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(viewerArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerArea);
        HashMap<Control, IDialogueControlDescriptor> allControls = new HashMap<Control, IDialogueControlDescriptor>();
        TableViewer viewer = this.createTableViewer(viewerArea);
        if (viewer != null) {
            allControls.put((Control)viewer.getTable(), ControlTypes.PARAMETERS);
        }
        if ((buttonControls = this.createOperationButtonArea(viewerArea)) != null) {
            allControls.putAll(buttonControls);
        }
        if ((useNamedButton = this.createCheckButton(parent, ControlTypes.USE_NAMED_ARGUMENTS)) != null) {
            useNamedButton.setSelection(this.useNamedArguments);
            allControls.put((Control)useNamedButton, ControlTypes.USE_NAMED_ARGUMENTS);
        }
        return allControls;
    }

    public List<MethodParameter> getMethodParameter() {
        return this.parameters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ColumnTypes {
        NAME("Name", 300),
        TYPE("Type", 300);

        private String label;
        private int weight;

        private ColumnTypes(String label, int weight) {
            this.label = label;
            this.weight = weight;
        }

        public String getLabel() {
            return this.label;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

