/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.DuplicateParameterRule;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ValueStatus;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.AbstractDialogue;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ControlSelectionEvent;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ControlTypes;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.DialogueDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.JavaTextControl;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.JavaTypeBrowsingControl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodParameterDialogue
extends AbstractDialogue {
    public static final DialogueDescriptor DIALOGUE_DESCRIPTOR = new DialogueDescriptor("Add parameter", "Suggestion Parameter", "icons/GROOVY.png");
    private Point labelOffset;
    private String type;
    private String name;
    private IJavaProject javaProject;
    private List<MethodParameter> existingParameters;

    public MethodParameterDialogue(Shell parentShell, IJavaProject javaProject, MethodParameter parameterToEdit, List<MethodParameter> existingParameters) {
        super(parentShell);
        this.javaProject = javaProject;
        if (parameterToEdit != null) {
            this.name = parameterToEdit.getName();
            this.type = parameterToEdit.getType();
        }
        this.existingParameters = existingParameters;
    }

    public MethodParameter getMethodParameter() {
        return new MethodParameter(this.name, this.type);
    }

    @Override
    protected DialogueDescriptor getDialogueDescriptor() {
        return DIALOGUE_DESCRIPTOR;
    }

    protected Point getOffsetLabelLocation() {
        if (this.labelOffset == null) {
            IDialogueControlDescriptor[] descriptors = new IDialogueControlDescriptor[]{ControlTypes.TYPE, ControlTypes.NAME};
            String[] labelNames = new String[descriptors.length];
            int i = 0;
            while (i < descriptors.length) {
                labelNames[i] = descriptors[i].getLabel();
                ++i;
            }
            this.labelOffset = this.getOffsetLabelLocation(labelNames);
        }
        return this.labelOffset;
    }

    @Override
    protected void createCommandArea(Composite parent) {
        JavaTextControl nameControl = new JavaTextControl(ControlTypes.NAME, this.getOffsetLabelLocation(), this.name){

            protected ValueStatus isControlValueValid(Control control) {
                ValueStatus status = super.isControlValueValid(control);
                if (!status.isError()) {
                    status = new DuplicateParameterRule(MethodParameterDialogue.this.existingParameters).checkValidity(status.getValue());
                }
                return status;
            }
        };
        nameControl.createControlArea(parent);
        nameControl.addSelectionListener(new AbstractDialogue.ValidatedValueSelectionListener(this, ControlTypes.NAME, this.name){

            protected void handleValidatedValue(ControlSelectionEvent event) {
                Object selection = event.getSelectionData();
                if (selection instanceof String) {
                    MethodParameterDialogue.this.name = (String)selection;
                }
            }
        });
        JavaTypeBrowsingControl typeControl = new JavaTypeBrowsingControl(ControlTypes.TYPE, this.getOffsetLabelLocation(), this.type, this.javaProject){

            protected ValueStatus isControlValueValid(String value) {
                if (value == null || value.length() == 0) {
                    return ValueStatus.getValidStatus(value);
                }
                return super.isControlValueValid(value);
            }
        };
        typeControl.createControlArea(parent);
        typeControl.addSelectionListener(new AbstractDialogue.ValidatedValueSelectionListener(this){

            protected void handleValidatedValue(ControlSelectionEvent event) {
                Object selection = event.getSelectionData();
                if (selection instanceof String) {
                    MethodParameterDialogue.this.type = (String)selection;
                }
            }
        });
    }
}

