/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.AbstractControlManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlDescriptor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentDialogueControl
extends AbstractControlManager {
    private String initialValue;
    private IDialogueControlDescriptor descriptor;

    public DocumentDialogueControl(IDialogueControlDescriptor descriptor, Point offsetLabelLocation, String initialValue) {
        this.descriptor = descriptor;
        this.initialValue = initialValue;
    }

    protected void setControlValue(Control control, Object value) {
        if (control instanceof Browser && value instanceof String) {
            ((Browser)control).setText((String)value);
        }
    }

    protected int numberofColumns() {
        return 1;
    }

    protected int getDocumentControlHeight() {
        return 100;
    }

    @Override
    protected Map<Control, IDialogueControlDescriptor> createManagedControls(Composite parent) {
        HashMap<Control, IDialogueControlDescriptor> controls = new HashMap<Control, IDialogueControlDescriptor>();
        if (this.descriptor != null) {
            Composite labelArea = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(this.numberofColumns()).margins(0, 0).equalWidth(false).applyTo(labelArea);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)labelArea);
            Label parameterNameLabel = new Label(labelArea, 8);
            parameterNameLabel.setText(String.valueOf(this.descriptor.getLabel()) + ": ");
            parameterNameLabel.setToolTipText(this.descriptor.getToolTipText());
            GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)parameterNameLabel);
            final StyledText styledText = new StyledText(labelArea, 2050);
            GridDataFactory.fillDefaults().grab(true, true).minSize(-1, this.getDocumentControlHeight()).applyTo((Control)styledText);
            styledText.setVisible(true);
            styledText.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    DocumentDialogueControl.this.notifyControlChange(styledText.getText(), (Control)styledText);
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            if (this.initialValue != null) {
                styledText.setText(this.initialValue);
            }
            controls.put((Control)styledText, this.descriptor);
        }
        return controls;
    }
}

