/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionDescriptor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.jdt.internal.core.util.Util;

public class SuggestionsRequestor
implements ITypeRequestor {
    private final ASTNode nodeToLookFor;
    private SuggestionDescriptor descriptor;

    public SuggestionsRequestor(ASTNode nodeToLookFor) {
        this.nodeToLookFor = nodeToLookFor;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (!this.interestingElement(enclosingElement)) {
            return ITypeRequestor.VisitStatus.CANCEL_MEMBER;
        }
        if (node instanceof ImportNode && (node = ((ImportNode)node).getType()) == null) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        if (SuggestionsRequestor.isValidNode(node) && this.doTest(node)) {
            Expression expression = (Expression)node;
            this.descriptor = this.createDescriptor(expression, result);
            return ITypeRequestor.VisitStatus.STOP_VISIT;
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    public SuggestionDescriptor getSuggestionDescriptor() {
        return this.descriptor;
    }

    protected SuggestionDescriptor createDescriptor(Expression suggestionNode, TypeLookupResult result) {
        ClassNode declaringTypeNode = result.declaringType;
        ClassNode suggestionTypeNode = result.type;
        VariableScope scope = result.scope;
        String declaringTypeName = declaringTypeNode.getName();
        String suggestionType = suggestionTypeNode.getName();
        Object suggestionName = suggestionNode instanceof ConstantExpression ? ((ConstantExpression)suggestionNode).getValue() : suggestionNode.getText();
        String name = suggestionName instanceof String ? (String)suggestionName : null;
        boolean isStatic = false;
        String javaDoc = null;
        boolean useNamedArguments = false;
        List<MethodParameter> parameters = null;
        boolean isMethod = this.isMethod(scope);
        boolean isActive = true;
        return isMethod ? new SuggestionDescriptor(declaringTypeName, isStatic, name, javaDoc, suggestionType, useNamedArguments, parameters, isActive) : new SuggestionDescriptor(declaringTypeName, isStatic, name, javaDoc, suggestionType, isActive);
    }

    protected boolean isMethod(VariableScope scope) {
        if (scope != null) {
            return scope.isMethodCall();
        }
        return false;
    }

    protected boolean interestingElement(IJavaElement enclosingElement) {
        if (enclosingElement.getElementName().equals("<clinit>")) {
            return true;
        }
        if (enclosingElement instanceof NamedMember) {
            try {
                ISourceRange range = ((ISourceReference)enclosingElement).getSourceRange();
                return range.getOffset() <= this.nodeToLookFor.getStart() && range.getOffset() + range.getLength() >= this.nodeToLookFor.getEnd();
            }
            catch (JavaModelException e) {
                Util.log((Throwable)e);
            }
        }
        return false;
    }

    private boolean doTest(ASTNode node) {
        return node.getClass() == this.nodeToLookFor.getClass() && this.nodeToLookFor.getStart() == node.getStart() && this.nodeToLookFor.getEnd() == node.getEnd();
    }

    public static boolean isValidNode(ASTNode node) {
        return node instanceof VariableExpression || node instanceof StaticMethodCallExpression || node instanceof FieldExpression || node instanceof ConstantExpression;
    }
}

