/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.dsl.contributions.ContributionGroup;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.MethodContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.ParameterContribution;
import org.codehaus.groovy.eclipse.dsl.contributions.PropertyContributionElement;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.DeclaringTypeSuperTypeMatcher;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovyMethodSuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovyPropertySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovySuggestionDeclaringType;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;
import org.codehaus.groovy.eclipse.dsl.pointcuts.BindingSet;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.eclipse.core.resources.IFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsContributionGroup
extends ContributionGroup {
    private IFile file;

    public SuggestionsContributionGroup(IFile file) {
        this.file = file;
    }

    @Override
    public List<IContributionElement> getContributions(GroovyDSLDContext pattern, BindingSet matches) {
        ArrayList<IContributionElement> currentContributions = new ArrayList<IContributionElement>();
        List<GroovySuggestionDeclaringType> superTypes = new DeclaringTypeSuperTypeMatcher(this.file.getProject()).getAllSuperTypes(pattern);
        if (superTypes != null) {
            for (GroovySuggestionDeclaringType declaringType : superTypes) {
                List<IGroovySuggestion> suggestions = declaringType.getSuggestions();
                if (suggestions == null) continue;
                for (IGroovySuggestion suggestion : suggestions) {
                    if (!suggestion.isActive()) continue;
                    if (suggestion instanceof GroovyPropertySuggestion) {
                        GroovyPropertySuggestion prop = (GroovyPropertySuggestion)suggestion;
                        currentContributions.add(new PropertyContributionElement(prop.getName(), prop.getType(), prop.getDeclaringType().getName(), prop.isStatic(), "User", prop.getJavaDoc(), false, 11));
                        continue;
                    }
                    if (!(suggestion instanceof GroovyMethodSuggestion)) continue;
                    GroovyMethodSuggestion method = (GroovyMethodSuggestion)suggestion;
                    ParameterContribution[] paramContribution = null;
                    List<MethodParameter> parameters = method.getParameters();
                    if (parameters != null) {
                        paramContribution = new ParameterContribution[method.getParameters().size()];
                        int i = 0;
                        for (MethodParameter parameter : parameters) {
                            if (i >= paramContribution.length) continue;
                            paramContribution[i++] = new ParameterContribution(parameter.getName(), parameter.getType());
                        }
                    }
                    currentContributions.add(new MethodContributionElement(method.getName(), paramContribution, method.getType(), method.getDeclaringType().getName(), method.isStatic(), "User", method.getJavaDoc(), method.useNamedArguments(), false, 11));
                }
            }
            return currentContributions;
        }
        return null;
    }
}

