/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.InferencingSuggestionsManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.OperationManager;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionsRequestor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SuggestionCompilationUnitHelper {
    private int length;
    private int offset;
    private GroovyCompilationUnit unit;
    private IProject project;

    public SuggestionCompilationUnitHelper(int length, int offset, GroovyCompilationUnit unit, IProject project) {
        this.length = length;
        this.offset = offset;
        this.unit = unit;
        this.project = project;
    }

    public IGroovySuggestion addSuggestion() {
        IGroovySuggestion suggestion = null;
        ASTNode node = this.findValidASTNode();
        if (node != null) {
            SuggestionsRequestor requestor = new SuggestionsRequestor(node);
            TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(this.unit);
            visitor.visitCompilationUnit((ITypeRequestor)requestor);
            SuggestionDescriptor descriptor = requestor.getSuggestionDescriptor();
            suggestion = this.createSuggestion(descriptor);
        }
        return suggestion;
    }

    public boolean canAddSuggestion() {
        return this.findValidASTNode() != null;
    }

    protected ASTNode findValidASTNode() {
        if (this.unit == null) {
            return null;
        }
        Region region = new Region(this.offset, this.length);
        ASTNodeFinder finder = new ASTNodeFinder(region);
        ASTNode node = finder.doVisit(this.unit.getModuleNode());
        return SuggestionsRequestor.isValidNode(node) ? node : null;
    }

    protected IGroovySuggestion createSuggestion(SuggestionDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Shell shell = this.getShell();
        IGroovySuggestion suggestion = null;
        if (shell != null) {
            suggestion = new OperationManager().addGroovySuggestion(this.project, descriptor, shell);
            InferencingSuggestionsManager.getInstance().commitChanges(this.project);
        } else {
            GroovyDSLCoreActivator.logException("Unable to open Inferencing Suggestions dialogue. No shell found.", new Exception());
        }
        return suggestion;
    }

    protected Shell getShell() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display == null) {
            return null;
        }
        Shell shell = display.getActiveShell();
        if (shell == null || shell.isDisposed()) {
            Shell[] shellArray = display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shll = shellArray[n2];
                if (shll != null && !shll.isDisposed()) {
                    shell = shll;
                    break;
                }
                ++n2;
            }
        }
        return shell;
    }
}

