/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.AbstractJavaTypeVerifiedRule;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ValueStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.groovy.core.util.JavaConstants;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaValidParameterizedTypeRule
extends AbstractJavaTypeVerifiedRule {
    public JavaValidParameterizedTypeRule(IJavaProject project) {
        super(project);
    }

    @Override
    public ValueStatus checkValidity(Object value) {
        if (!(value instanceof String)) {
            return ValueStatus.getErrorStatus(value);
        }
        String typeToCheck = (String)value;
        StringBuffer source = new StringBuffer();
        Type astType = this.getASTType(typeToCheck, source);
        ArrayList<String> allNonExistantTypes = new ArrayList<String>();
        if (astType != null) {
            try {
                boolean isValid = this.allTypesExist(astType, source, allNonExistantTypes);
                if (!isValid) {
                    String message = this.composeErrorMessage(allNonExistantTypes);
                    return ValueStatus.getErrorStatus(value, message);
                }
                return ValueStatus.getValidStatus(value);
            }
            catch (JavaModelException e) {
                GroovyDSLCoreActivator.logException(e);
                return ValueStatus.getErrorStatus(value, e.getLocalizedMessage());
            }
        }
        return ValueStatus.getErrorStatus(value, "Invalid Java type.");
    }

    protected String getTypeName(Type type, StringBuffer source) {
        int index;
        String name = null;
        name = source.substring(type.getStartPosition(), ASTNodes.getExclusiveEnd((ASTNode)type));
        if (type instanceof ParameterizedType && (index = name.indexOf(60)) >= 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    protected boolean allTypesExist(Type type, StringBuffer source, List<String> nonExistantTypes) throws JavaModelException {
        String typeName = this.getTypeName(type, source);
        IType actualType = this.getActualType(typeName);
        if (actualType != null) {
            List parameterisedNodes;
            if (type instanceof ParameterizedType && (parameterisedNodes = ((ParameterizedType)type).typeArguments()) != null) {
                boolean allParamsValid = true;
                for (Object node : parameterisedNodes) {
                    if (node instanceof Type && this.allTypesExist((Type)node, source, nonExistantTypes)) continue;
                    allParamsValid = false;
                    break;
                }
                return allParamsValid;
            }
            return true;
        }
        if (type instanceof PrimitiveType || type instanceof ArrayType) {
            return true;
        }
        if (nonExistantTypes != null && !nonExistantTypes.contains(typeName)) {
            nonExistantTypes.add(typeName);
        }
        return false;
    }

    protected Type getASTType(String typeToCheck, StringBuffer sourceBuffer) {
        sourceBuffer.append("class __C__ {");
        int valueOffset = sourceBuffer.length();
        sourceBuffer.append(typeToCheck).append(" v;");
        sourceBuffer.append("}");
        ASTParser parser = ASTParser.newParser((int)JavaConstants.AST_LEVEL);
        parser.setSource(sourceBuffer.toString().toCharArray());
        HashMap options = new HashMap();
        JavaCore.setComplianceOptions((String)"1.5", options);
        parser.setCompilerOptions(options);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        ASTNode selected = NodeFinder.perform((ASTNode)cu, (int)valueOffset, (int)typeToCheck.length());
        if (selected instanceof Name) {
            selected = selected.getParent();
        }
        if (selected instanceof Type) {
            return (Type)selected;
        }
        return null;
    }
}

