/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovyMethodSuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovyPropertySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IBaseGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovySuggestionDeclaringType
implements IBaseGroovySuggestion {
    private List<IGroovySuggestion> suggestions = new ArrayList<IGroovySuggestion>();
    private String name;

    public GroovySuggestionDeclaringType(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public IGroovySuggestion createSuggestion(SuggestionDescriptor descriptor) {
        IGroovySuggestion suggestion = new SuggestionFactory(descriptor).createSuggestion(this);
        if (this.containsSuggestion(suggestion)) {
            return null;
        }
        this.suggestions.add(suggestion);
        return suggestion;
    }

    protected boolean containsSuggestion(IGroovySuggestion suggestion) {
        boolean isContained;
        block9: {
            block10: {
                isContained = false;
                if (!(suggestion instanceof GroovyPropertySuggestion)) break block10;
                String name = suggestion.getName();
                for (IGroovySuggestion existingSugg : this.suggestions) {
                    if (!(existingSugg instanceof GroovyPropertySuggestion) || !existingSugg.getName().equals(name)) continue;
                    isContained = true;
                    break block9;
                }
                break block9;
            }
            if (!(suggestion instanceof GroovyMethodSuggestion)) break block9;
            String name = suggestion.getName();
            GroovyMethodSuggestion methodSuggestion = (GroovyMethodSuggestion)suggestion;
            for (IGroovySuggestion existingSugg : this.suggestions) {
                if (!(existingSugg instanceof GroovyMethodSuggestion) || !existingSugg.getName().equals(name)) continue;
                GroovyMethodSuggestion existingMethodSuggestion = (GroovyMethodSuggestion)existingSugg;
                List<MethodParameter> existingParameters = existingMethodSuggestion.getParameters();
                List<MethodParameter> parameters = methodSuggestion.getParameters();
                if (existingParameters != null) {
                    if (parameters == null || parameters.size() != existingParameters.size()) continue;
                    boolean same = true;
                    int i = 0;
                    while (i < parameters.size()) {
                        String existingType = existingParameters.get(i).getType();
                        String type = parameters.get(i).getType();
                        if (type != null) {
                            if (!type.equals(existingType)) {
                                same = false;
                                break;
                            }
                        } else if (existingType != null) {
                            same = false;
                            break;
                        }
                        ++i;
                    }
                    if (!same) continue;
                    isContained = true;
                } else {
                    if (parameters != null) continue;
                    isContained = true;
                }
                break;
            }
        }
        return isContained;
    }

    public IGroovySuggestion replaceSuggestion(SuggestionDescriptor descriptor, IGroovySuggestion suggestion) {
        if (this.suggestions.contains(suggestion)) {
            this.removeSuggestion(suggestion);
            IGroovySuggestion nwSuggestion = this.createSuggestion(descriptor);
            return nwSuggestion;
        }
        return null;
    }

    public boolean removeSuggestion(IGroovySuggestion suggestion) {
        return this.suggestions.remove(suggestion);
    }

    public List<IGroovySuggestion> getSuggestions() {
        return this.suggestions;
    }

    public boolean hasSuggestions() {
        return !this.suggestions.isEmpty();
    }
}

