/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyPropertyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;
import org.eclipse.jdt.groovy.search.AbstractSimplifiedTypeLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyContributionElement
implements IContributionElement {
    private static final ClassNode UNKNOWN_TYPE = ClassHelper.DYNAMIC_TYPE;
    private final String propName;
    private final String propType;
    private final String declaringType;
    private final boolean isStatic;
    private ClassNode cachedDeclaringType;
    private ClassNode cachedType;
    private final String provider;
    private final String doc;
    private final int relevanceMultiplier;
    private final boolean isDeprecated;

    public PropertyContributionElement(String propName, String propType, String declaringType, boolean isStatic, String provider, String doc, boolean isDeprecated, int relevanceMultiplier) {
        this.propName = propName;
        this.propType = propType;
        this.isStatic = isStatic;
        this.declaringType = declaringType;
        this.isDeprecated = isDeprecated;
        this.relevanceMultiplier = relevanceMultiplier;
        this.provider = provider == null ? "DSL Descriptor" : provider;
        this.doc = doc == null ? "Provided by " + this.provider : doc;
    }

    @Override
    public IGroovyProposal toProposal(ClassNode declaringType, ResolverCache resolver) {
        GroovyPropertyProposal groovyPropertyProposal = new GroovyPropertyProposal(this.toProperty(declaringType, resolver), this.provider);
        groovyPropertyProposal.setRelevanceMultiplier((float)this.relevanceMultiplier);
        return groovyPropertyProposal;
    }

    @Override
    public AbstractSimplifiedTypeLookup.TypeAndDeclaration lookupType(String name, ClassNode declaringType, ResolverCache resolver) {
        return name.equals(this.propName) ? new AbstractSimplifiedTypeLookup.TypeAndDeclaration(this.ensureReturnType(resolver), (ASTNode)this.toProperty(declaringType, resolver), this.ensureDeclaringType(declaringType, resolver), this.doc) : null;
    }

    private PropertyNode toProperty(ClassNode declaringType, ResolverCache resolver) {
        ClassNode realDeclaringType = this.ensureDeclaringType(declaringType, resolver);
        PropertyNode prop = new PropertyNode(new FieldNode(this.propName, this.opcode(), this.ensureReturnType(resolver), realDeclaringType, null), this.opcode(), null, null);
        prop.setDeclaringClass(realDeclaringType);
        prop.getField().setDeclaringClass(realDeclaringType);
        return prop;
    }

    protected int opcode() {
        int modifiers = this.isStatic ? 8 : 1;
        return modifiers |= this.isDeprecated ? 131072 : 0;
    }

    protected ClassNode ensureReturnType(ResolverCache resolver) {
        if (this.cachedType == null) {
            this.cachedType = resolver.resolve(this.propType);
        }
        return this.cachedType == null ? UNKNOWN_TYPE : this.cachedType;
    }

    protected ClassNode ensureDeclaringType(ClassNode lexicalDeclaringType, ResolverCache resolver) {
        if (this.declaringType != null && this.cachedDeclaringType == null) {
            this.cachedDeclaringType = resolver.resolve(this.declaringType);
        }
        return this.cachedDeclaringType == null ? lexicalDeclaringType : this.cachedDeclaringType;
    }

    @Override
    public String contributionName() {
        return this.propName;
    }

    @Override
    public String description() {
        return "Property: " + this.declaringType + "." + this.propName;
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringType;
    }

    public String toString() {
        return "public " + (this.isStatic ? "static " : "") + (this.isDeprecated ? "deprecated " : "") + this.propType + " " + this.declaringType + "." + this.propName + " (" + this.provider + ")";
    }

    @Override
    public List<IGroovyProposal> extraProposals(ClassNode declaringType, ResolverCache resolver, Expression enclosingExpression) {
        return ProposalUtils.NO_PROPOSALS;
    }
}

