/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.eclipse.dsl.contributions.DSLContributionGroup;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;

public class ParameterContribution {
    final String name;
    final String type;
    private Parameter cachedParameter;

    public ParameterContribution(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public ParameterContribution(Parameter cachedParameter) {
        this.cachedParameter = cachedParameter;
        this.name = cachedParameter.getName();
        this.type = DSLContributionGroup.getTypeName(cachedParameter.getType());
    }

    public ParameterContribution(String name) {
        this.name = name;
        this.type = null;
    }

    public Parameter toParameter(ResolverCache resolver) {
        if (this.cachedParameter == null) {
            this.cachedParameter = resolver != null ? new Parameter(resolver.resolve(this.type), this.name) : new Parameter(ClassHelper.DYNAMIC_TYPE, this.name);
        }
        return this.cachedParameter;
    }

    public String toString() {
        return String.valueOf(this.type) + " " + this.name;
    }
}

