/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.NamedArgsMethodNode;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyNamedArgumentProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.ParameterContribution;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;
import org.eclipse.jdt.groovy.search.AbstractSimplifiedTypeLookup;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodContributionElement
implements IContributionElement {
    private static final BlockStatement EMPTY_BLOCK = new BlockStatement();
    private static final ClassNode[] NO_EXCEPTIONS = new ClassNode[0];
    private static final Parameter[] NO_PARAMETERS = new Parameter[0];
    private static final ParameterContribution[] NO_PARAMETER_CONTRIBUTION = new ParameterContribution[0];
    private static final ClassNode UNKNOWN_TYPE = ClassHelper.DYNAMIC_TYPE;
    private final String methodName;
    private final ParameterContribution[] params;
    private final ParameterContribution[] namedParams;
    private final ParameterContribution[] optionalParams;
    private final String returnType;
    private final String declaringType;
    private final boolean isStatic;
    private final boolean useNamedArgs;
    private final String provider;
    private final String doc;
    private ClassNode cachedDeclaringType;
    private ClassNode cachedReturnType;
    private Parameter[] cachedRegularParameters;
    private Parameter[] cachedNamedParameters;
    private Parameter[] cachedOptionalParameters;
    private ProposalFormattingOptions options = ProposalFormattingOptions.newFromOptions();
    private final int relevanceMultiplier;
    private final boolean isDeprecated;
    private final boolean noParens;

    public MethodContributionElement(String methodName, ParameterContribution[] params, String returnType, String declaringType, boolean isStatic, String provider, String doc, boolean useNamedArgs, boolean isDeprecated, int relevanceMultiplier) {
        this(methodName, params, NO_PARAMETER_CONTRIBUTION, NO_PARAMETER_CONTRIBUTION, returnType, declaringType, isStatic, provider, doc, useNamedArgs, false, isDeprecated, relevanceMultiplier);
    }

    public MethodContributionElement(String methodName, ParameterContribution[] params, ParameterContribution[] namedParams, ParameterContribution[] optionalParams, String returnType, String declaringType, boolean isStatic, String provider, String doc, boolean useNamedArgs, boolean noParens, boolean isDeprecated, int relevanceMultiplier) {
        this.methodName = methodName;
        this.params = params;
        this.namedParams = namedParams;
        this.optionalParams = optionalParams;
        this.returnType = returnType;
        this.isStatic = isStatic;
        this.declaringType = declaringType;
        this.useNamedArgs = useNamedArgs;
        this.noParens = noParens;
        this.isDeprecated = isDeprecated;
        this.relevanceMultiplier = relevanceMultiplier;
        this.provider = provider == null ? "DSL Descriptor" : provider;
        this.doc = doc == null ? "Provided by " + this.provider : doc;
    }

    @Override
    public AbstractSimplifiedTypeLookup.TypeAndDeclaration lookupType(String name, ClassNode declaringType, ResolverCache resolver) {
        if (name.equals(this.methodName)) {
            return new AbstractSimplifiedTypeLookup.TypeAndDeclaration(this.ensureReturnType(resolver), (ASTNode)this.toMethod(declaringType, resolver), this.ensureDeclaringType(declaringType, resolver), this.doc);
        }
        return null;
    }

    @Override
    public IGroovyProposal toProposal(ClassNode declaringType, ResolverCache resolver) {
        GroovyMethodProposal groovyMethodProposal = new GroovyMethodProposal(this.toMethod(declaringType.redirect(), resolver), this.provider, this.options);
        groovyMethodProposal.setUseNamedArguments(this.useNamedArgs);
        groovyMethodProposal.setNoParens(this.noParens);
        groovyMethodProposal.setRelevanceMultiplier((float)this.relevanceMultiplier);
        return groovyMethodProposal;
    }

    @Override
    public List<IGroovyProposal> extraProposals(ClassNode declaringType, ResolverCache resolver, Expression expression) {
        Map<String, ClassNode> availableParams = this.findAvailableParameters(resolver);
        if (availableParams.isEmpty()) {
            return ProposalUtils.NO_PROPOSALS;
        }
        this.removeUsedParameters(expression, availableParams);
        ArrayList<IGroovyProposal> extraProposals = new ArrayList<IGroovyProposal>(availableParams.size());
        for (Map.Entry<String, ClassNode> available : availableParams.entrySet()) {
            extraProposals.add((IGroovyProposal)new GroovyNamedArgumentProposal(available.getKey(), available.getValue(), this.toMethod(declaringType.redirect(), resolver), this.provider));
        }
        return extraProposals;
    }

    private void removeUsedParameters(Expression expression, Map<String, ClassNode> availableParams) {
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)expression;
            Expression arguments = call.getArguments();
            if (arguments instanceof TupleExpression) {
                for (Expression maybeArg : ((TupleExpression)arguments).getExpressions()) {
                    if (!(maybeArg instanceof MapExpression)) continue;
                    arguments = maybeArg;
                    break;
                }
            }
            if (arguments instanceof MapExpression) {
                MapExpression enclosingCallArgs = (MapExpression)arguments;
                for (MapEntryExpression entry : enclosingCallArgs.getMapEntryExpressions()) {
                    String paramName = entry.getKeyExpression().getText();
                    availableParams.remove(paramName);
                }
            }
        }
    }

    private Map<String, ClassNode> findAvailableParameters(ResolverCache resolver) {
        ParameterContribution param;
        int n;
        int n2;
        ParameterContribution[] parameterContributionArray;
        HashMap<String, ClassNode> available = new HashMap<String, ClassNode>(this.params.length);
        if (this.useNamedArgs) {
            parameterContributionArray = this.params;
            n2 = this.params.length;
            n = 0;
            while (n < n2) {
                param = parameterContributionArray[n];
                available.put(param.name, param.toParameter(resolver).getType());
                ++n;
            }
        }
        parameterContributionArray = this.namedParams;
        n2 = this.namedParams.length;
        n = 0;
        while (n < n2) {
            param = parameterContributionArray[n];
            available.put(param.name, param.toParameter(resolver).getType());
            ++n;
        }
        parameterContributionArray = this.optionalParams;
        n2 = this.optionalParams.length;
        n = 0;
        while (n < n2) {
            param = parameterContributionArray[n];
            available.put(param.name, param.toParameter(resolver).getType());
            ++n;
        }
        return available;
    }

    private MethodNode toMethod(ClassNode declaringType, ResolverCache resolver) {
        if (this.cachedRegularParameters == null) {
            this.cachedRegularParameters = this.initParams(this.params, resolver);
            this.cachedOptionalParameters = this.initParams(this.optionalParams, resolver);
            this.cachedNamedParameters = this.initParams(this.namedParams, resolver);
            if (this.cachedReturnType == null) {
                this.cachedReturnType = resolver != null ? resolver.resolve(this.returnType) : VariableScope.OBJECT_CLASS_NODE;
            }
        }
        NamedArgsMethodNode meth = new NamedArgsMethodNode(this.methodName, this.opcode(), this.cachedReturnType, this.cachedRegularParameters, this.cachedNamedParameters, this.cachedOptionalParameters, NO_EXCEPTIONS, (Statement)EMPTY_BLOCK);
        meth.setDeclaringClass(this.ensureDeclaringType(declaringType, resolver));
        return meth;
    }

    private Parameter[] initParams(ParameterContribution[] pcs, ResolverCache resolver) {
        Parameter[] ps;
        if (pcs == null) {
            ps = NO_PARAMETERS;
        } else {
            ps = new Parameter[pcs.length];
            int i = 0;
            while (i < pcs.length) {
                ps[i] = pcs[i].toParameter(resolver);
                ++i;
            }
        }
        return ps;
    }

    protected ClassNode ensureReturnType(ResolverCache resolver) {
        if (this.cachedReturnType == null) {
            this.cachedReturnType = resolver.resolve(this.returnType);
        }
        return this.cachedReturnType == null ? UNKNOWN_TYPE : this.cachedReturnType;
    }

    protected ClassNode ensureDeclaringType(ClassNode lexicalDeclaringType, ResolverCache resolver) {
        if (this.declaringType != null && this.cachedDeclaringType == null) {
            this.cachedDeclaringType = resolver.resolve(this.declaringType);
        }
        return this.cachedDeclaringType == null ? lexicalDeclaringType : this.cachedDeclaringType;
    }

    protected int opcode() {
        int modifiers = this.isStatic ? 8 : 1;
        return modifiers |= this.isDeprecated ? 131072 : 0;
    }

    @Override
    public String contributionName() {
        return this.methodName;
    }

    @Override
    public String description() {
        return "Method: " + this.declaringType + "." + this.methodName + "(..)";
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringType;
    }

    public String toString() {
        return "public " + (this.isStatic ? "static " : "") + (this.isDeprecated ? "deprecated " : "") + (this.useNamedArgs ? "useNamedArgs " : "") + this.returnType + " " + this.declaringType + "." + this.methodName + "(" + Arrays.toString(this.params) + ") (" + this.provider + ")";
    }
}

