/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.contributions.ContributionGroup;
import org.codehaus.groovy.eclipse.dsl.contributions.EmptyContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.MethodContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.ParameterContribution;
import org.codehaus.groovy.eclipse.dsl.contributions.PropertyContributionElement;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;
import org.codehaus.groovy.eclipse.dsl.pointcuts.BindingSet;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSLContributionGroup
extends ContributionGroup {
    private static final ParameterContribution[] NO_PARAMS = new ParameterContribution[0];
    private static final String NO_TYPE = "java.lang.Object";
    private static final String NO_NAME = "";
    private final Closure contributionClosure;
    private VariableScope scope;
    private String provider = null;
    private ResolverCache resolver;
    private Map<String, Collection<Object>> bindings;
    private ClassNode currentType;
    private Map<String, Object> wormhole;
    private boolean staticScope;
    private boolean isPrimaryExpression;

    public DSLContributionGroup(Closure contributionClosure) {
        this.contributionClosure = contributionClosure;
        if (contributionClosure != null) {
            contributionClosure.setDelegate((Object)this);
            contributionClosure.setResolveStrategy(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IContributionElement> getContributions(GroovyDSLDContext pattern, BindingSet matches) {
        DSLContributionGroup dSLContributionGroup = this;
        synchronized (dSLContributionGroup) {
            List result;
            block8: {
                try {
                    try {
                        this.contributions = new ArrayList();
                        this.scope = pattern.getCurrentScope();
                        this.resolver = pattern.getResolverCache();
                        this.bindings = matches.getBindings();
                        this.currentType = pattern.getCurrentType();
                        this.wormhole = this.scope.getWormhole();
                        this.staticScope = pattern.isStatic();
                        this.isPrimaryExpression = pattern.isPrimaryNode();
                        this.contributionClosure.call();
                    }
                    catch (Exception e) {
                        GroovyLogManager.manager.logException(TraceCategory.DSL, (Throwable)e);
                        result = this.contributions;
                        pattern.setTargetType(this.currentType);
                        this.contributions = null;
                        this.scope = null;
                        this.resolver = null;
                        this.bindings = null;
                        this.currentType = null;
                        this.wormhole = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    List result2 = this.contributions;
                    pattern.setTargetType(this.currentType);
                    this.contributions = null;
                    this.scope = null;
                    this.resolver = null;
                    this.bindings = null;
                    this.currentType = null;
                    this.wormhole = null;
                    throw throwable;
                }
                result = this.contributions;
                pattern.setTargetType(this.currentType);
                this.contributions = null;
                this.scope = null;
                this.resolver = null;
                this.bindings = null;
                this.currentType = null;
                this.wormhole = null;
            }
            return result;
        }
    }

    public Object getProperty(String property) {
        if ("wormhole".equals(property)) {
            return this.wormhole;
        }
        if ("currentNode".equals(property)) {
            return this.scope.getCurrentNode();
        }
        if ("enclosingNode".equals(property)) {
            return this.scope.getEnclosingNode();
        }
        if ("currentType".equals(property)) {
            return this.currentType;
        }
        if ("resolver".equals(property)) {
            return this.resolver;
        }
        return this.bindings.get(property);
    }

    void setDelegateType(Object arg) {
        ClassNode delegate = this.asClassNode(arg);
        if (delegate != null) {
            this.scope.addVariable("delegate", delegate, VariableScope.CLOSURE_CLASS);
            this.scope.addVariable("getDelegate", delegate, VariableScope.CLOSURE_CLASS);
            this.contributions.add(new EmptyContributionElement(this.currentType));
            if (this.isPrimaryExpression) {
                this.currentType = delegate;
            }
        }
    }

    private ClassNode asClassNode(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.resolver.resolve((String)value);
        }
        if (value instanceof ClassNode) {
            return (ClassNode)value;
        }
        if (value instanceof Class) {
            return this.resolver.resolve(((Class)value).getName());
        }
        return this.resolver.resolve(value.toString());
    }

    void method(Map<String, Object> args) {
        String name = this.asString(args.get("name"));
        Object value = args.get("type");
        String returnType = value == null ? NO_TYPE : this.asString(value);
        value = args.get("declaringType");
        String declaringType = value == null ? DSLContributionGroup.getTypeName(this.currentType) : this.asString(value);
        value = args.get("provider");
        String provider = value == null ? this.provider : this.asString(value);
        value = args.get("doc");
        String doc = value == null ? null : this.asString(value);
        boolean useNamedArgs = this.asBoolean(args.get("useNamedArgs"));
        boolean noParens = this.asBoolean(args.get("noParens"));
        ParameterContribution[] params = this.extractParams(args, "params");
        ParameterContribution[] namedParams = this.extractParams(args, "namedParams");
        ParameterContribution[] optionalParams = this.extractParams(args, "optionalParams");
        boolean isStatic = this.isStatic(args);
        boolean isDeprecated = this.isDeprecated(args);
        if (!this.staticScope || this.staticScope && isStatic) {
            this.contributions.add(new MethodContributionElement(name == null ? NO_NAME : name, params, namedParams, optionalParams, returnType == null ? NO_TYPE : returnType, declaringType, isStatic, provider == null ? this.provider : provider, doc, useNamedArgs, noParens, isDeprecated, 11));
        }
    }

    private ParameterContribution[] extractParams(Map<String, Object> args, String paramKind) {
        ParameterContribution[] params;
        Map paramsMap = (Map)args.get(paramKind);
        if (paramsMap != null) {
            params = new ParameterContribution[paramsMap.size()];
            int i = 0;
            for (Map.Entry entry : paramsMap.entrySet()) {
                Object value = entry.getValue();
                String type = value == null ? NO_TYPE : this.asString(value);
                params[i++] = new ParameterContribution(this.asString(entry.getKey()), type);
            }
        } else {
            params = NO_PARAMS;
        }
        return params;
    }

    private boolean asBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String str = object.toString();
        return str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes");
    }

    void property(Map<String, Object> args) {
        String name = this.asString(args.get("name"));
        Object value = args.get("type");
        String type = value == null ? NO_TYPE : this.asString(value);
        value = args.get("declaringType");
        String declaringType = value == null ? DSLContributionGroup.getTypeName(this.currentType) : this.asString(value);
        value = args.get("provider");
        String provider = value == null ? this.provider : this.asString(value);
        String doc = this.asString(args.get("doc"));
        boolean isStatic = this.isStatic(args);
        boolean isDeprecated = this.isDeprecated(args);
        if (!this.staticScope || this.staticScope && isStatic) {
            this.contributions.add(new PropertyContributionElement(name == null ? NO_NAME : name, type, declaringType, isStatic, provider, doc, isDeprecated, 11));
        }
    }

    void template(Map<String, String> args) {
    }

    void delegatesTo(Map<String, Object> args) {
        String name = this.asString(args.get("type"));
        boolean isStatic = this.isStatic(args);
        boolean isDeprecated = this.isDeprecated(args);
        boolean asCategory = this.getBoolean("asCategory", args);
        boolean useNamed = this.getBoolean("useNamed", args);
        boolean noParens = this.getBoolean("noParens", args);
        List except = (List)args.get("except");
        ClassNode type = this.resolver.resolve(name);
        this.internalDelegatesTo((AnnotatedNode)type, useNamed, isStatic, asCategory, isDeprecated, except, noParens);
    }

    void delegatesTo(String className) {
        this.delegatesTo((AnnotatedNode)this.resolver.resolve(className));
    }

    void delegatesTo(Class<?> clazz) {
        ClassNode resolved = this.resolver.resolve(clazz.getCanonicalName());
        if (resolved == VariableScope.OBJECT_CLASS_NODE && !clazz.getName().equals(Object.class.getName())) {
            try {
                resolved = ClassHelper.make(clazz);
            }
            catch (Exception e) {
                GroovyDSLCoreActivator.logException(e);
            }
        }
        this.delegatesTo((AnnotatedNode)resolved);
    }

    void delegatesTo(AnnotatedNode expr) {
        this.internalDelegatesTo(expr, false, false, false, false, null, false);
    }

    void delegatesToUseNamedArgs(String className) {
        this.delegatesToUseNamedArgs((AnnotatedNode)this.resolver.resolve(className));
    }

    void delegatesToUseNamedArgs(Class<?> clazz) {
        this.delegatesToUseNamedArgs((AnnotatedNode)this.resolver.resolve(clazz.getCanonicalName()));
    }

    void delegatesToUseNamedArgs(AnnotatedNode expr) {
        this.internalDelegatesTo(expr, true, false, false, false, null, false);
    }

    void delegatesToCategory(String className) {
        this.delegatesToCategory((AnnotatedNode)this.resolver.resolve(className));
    }

    void delegatesToCategory(Class<?> clazz) {
        this.delegatesToCategory((AnnotatedNode)this.resolver.resolve(clazz.getCanonicalName()));
    }

    void delegatesToCategory(AnnotatedNode expr) {
        this.internalDelegatesTo(expr, false, false, true, false, null, false);
    }

    static String getTypeName(ClassNode clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getName());
        if (clazz.getGenericsTypes() != null && clazz.getGenericsTypes().length > 0) {
            sb.append('<');
            GenericsType[] genericsTypeArray = clazz.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gt = genericsTypeArray[n2];
                sb.append(DSLContributionGroup.getTypeName(gt.getType()));
                sb.append(',');
                ++n2;
            }
            sb.replace(sb.length() - 1, sb.length(), ">");
        }
        return sb.toString();
    }

    private void internalDelegatesTo(AnnotatedNode expr, boolean useNamedArgs, boolean isStatic, boolean asCategory, boolean isDeprecated, List<String> exceptions, boolean noParens) {
        ClassNode type;
        if (this.staticScope && !isStatic && !this.currentType.getName().equals(VariableScope.CLASS_CLASS_NODE)) {
            return;
        }
        if (expr instanceof ClassNode) {
            type = (ClassNode)expr;
        } else if (expr instanceof FieldNode) {
            type = ((FieldNode)expr).getType();
        } else if (expr instanceof MethodNode) {
            type = ((MethodNode)expr).getReturnType();
        } else if (expr instanceof ClassExpression) {
            type = ((ClassExpression)expr).getType();
        } else {
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.log(TraceCategory.DSL, "Cannot invoke delegatesTo() on an invalid object: " + expr);
            }
            return;
        }
        if (!type.getName().equals(Object.class.getName())) {
            GenericsMapper mapper = GenericsMapper.gatherGenerics((ClassNode)type, (ClassNode)type.redirect());
            ArrayList<IContributionElement> accessorContribs = new ArrayList<IContributionElement>(1);
            for (MethodNode method : type.getMethods()) {
                if (exceptions != null && exceptions.contains(method.getName()) || method instanceof ConstructorNode || method.getName().contains("$")) continue;
                ClassNode resolvedReturnType = VariableScope.resolveTypeParameterization((GenericsMapper)mapper, (ClassNode)VariableScope.clone((ClassNode)method.getReturnType()));
                if (asCategory) {
                    this.delegateToCategoryMethod(useNamedArgs, isStatic, type, method, resolvedReturnType, isDeprecated, accessorContribs, noParens);
                    continue;
                }
                this.delegateToNonCategoryMethod(useNamedArgs, isStatic, type, method, resolvedReturnType, isDeprecated, accessorContribs, noParens);
            }
            this.contributions.addAll(accessorContribs);
        }
    }

    private void delegateToNonCategoryMethod(boolean useNamedArgs, boolean isStatic, ClassNode type, MethodNode method, ClassNode resolvedReturnType, boolean isDeprecated, List<IContributionElement> accessorContribs, boolean noParens) {
        String name = method.getName();
        this.contributions.add(new MethodContributionElement(name, this.toParameterContribution(method.getParameters()), NO_PARAMS, NO_PARAMS, DSLContributionGroup.getTypeName(resolvedReturnType), DSLContributionGroup.getTypeName(type), method.isStatic() || isStatic, this.provider, null, useNamedArgs, noParens, isDeprecated, 11));
        String prefix = this.isAccessor(method, name, false);
        if (prefix != null) {
            accessorContribs.add(new PropertyContributionElement(String.valueOf(Character.toLowerCase(name.charAt(prefix.length()))) + name.substring(prefix.length() + 1), DSLContributionGroup.getTypeName(resolvedReturnType), DSLContributionGroup.getTypeName(method.getDeclaringClass()), method.isStatic() || isStatic, this.provider, null, isDeprecated, 11));
        }
    }

    private void delegateToCategoryMethod(boolean useNamedArgs, boolean isStatic, ClassNode type, MethodNode method, ClassNode resolvedReturnType, boolean isDeprecated, List<IContributionElement> accessorContribs, boolean noParens) {
        ClassNode firstType;
        String name = method.getName();
        if (method.getParameters() != null && method.getParameters().length > 0 && ((firstType = method.getParameters()[0].getType()).isInterface() && this.currentType.implementsInterface(firstType) || this.currentType.isDerivedFrom(firstType))) {
            this.contributions.add(new MethodContributionElement(name, this.toParameterContributionRemoveFirst(method.getParameters()), NO_PARAMS, NO_PARAMS, DSLContributionGroup.getTypeName(resolvedReturnType), DSLContributionGroup.getTypeName(type), isStatic, this.provider, null, useNamedArgs, noParens, isDeprecated, 11));
            String prefix = this.isAccessor(method, name, true);
            if (prefix != null) {
                accessorContribs.add(new PropertyContributionElement(String.valueOf(Character.toLowerCase(name.charAt(prefix.length()))) + name.substring(prefix.length() + 1), DSLContributionGroup.getTypeName(resolvedReturnType), DSLContributionGroup.getTypeName(method.getDeclaringClass()), method.isStatic() || isStatic, this.provider, null, isDeprecated, 11));
            }
        }
    }

    private String isAccessor(MethodNode method, String name, boolean isCategory) {
        int paramCount;
        int n = paramCount = isCategory ? 1 : 0;
        if (method.getParameters() == null || method.getParameters().length == paramCount) {
            if (name.startsWith("get") && name.length() > 3) {
                return "get";
            }
            if (name.startsWith("is") && name.length() > 2) {
                return "is";
            }
        }
        return null;
    }

    private ParameterContribution[] toParameterContribution(Parameter[] params) {
        if (params != null) {
            ParameterContribution[] contribs = new ParameterContribution[params.length];
            int i = 0;
            while (i < contribs.length) {
                contribs[i] = new ParameterContribution(params[i]);
                ++i;
            }
            return contribs;
        }
        return new ParameterContribution[0];
    }

    private ParameterContribution[] toParameterContributionRemoveFirst(Parameter[] params) {
        if (params != null) {
            ParameterContribution[] contribs = new ParameterContribution[params.length - 1];
            int i = 1;
            while (i < params.length) {
                contribs[i - 1] = new ParameterContribution(params[i]);
                ++i;
            }
            return contribs;
        }
        return new ParameterContribution[0];
    }

    void provider(Object args) {
        this.provider = args == null ? null : this.asString(args);
    }

    private boolean isStatic(Map<?, ?> args) {
        return this.getBoolean("isStatic", args);
    }

    private boolean isDeprecated(Map<?, ?> args) {
        return this.getBoolean("isDeprecated", args);
    }

    private boolean getBoolean(String name, Map<?, ?> args) {
        Object maybeStatic = args.get(name);
        if (maybeStatic == null) {
            return false;
        }
        if (maybeStatic instanceof Boolean) {
            return (Boolean)maybeStatic;
        }
        return Boolean.getBoolean(maybeStatic.toString());
    }

    private String asString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof ClassNode) {
            return DSLContributionGroup.getTypeName((ClassNode)value);
        }
        if (value instanceof FieldNode) {
            return String.valueOf(DSLContributionGroup.getTypeName(((FieldNode)value).getDeclaringClass())) + "." + ((FieldNode)value).getName();
        }
        if (value instanceof MethodNode) {
            return String.valueOf(DSLContributionGroup.getTypeName(((MethodNode)value).getDeclaringClass())) + "." + ((MethodNode)value).getName();
        }
        if (value instanceof ConstantExpression) {
            return ((ConstantExpression)value).getText();
        }
        if (value instanceof Variable) {
            return ((Variable)value).getName();
        }
        if (value instanceof AnnotationNode) {
            return ((AnnotationNode)value).getClassNode().getName();
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        return value.toString();
    }

    Object log(Object msg) {
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "========== " + msg);
        }
        return msg;
    }
}

