/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.classpath;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.codehaus.groovy.eclipse.core.builder.GroovyClasspathContainer;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class DSLDContainerInitializer
extends ClasspathContainerInitializer {
    private static final IClasspathEntry[] NO_ENTRIES = new IClasspathEntry[0];
    private static final File globalDsldLocation = DSLDContainerInitializer.getglobalDsldLocation();
    private IJavaProject javaProject;

    private static File getglobalDsldLocation() {
        File location = null;
        String dotGroovyLocation = CompilerUtils.getDotGroovyLocation();
        if (dotGroovyLocation != null && !(location = new File(dotGroovyLocation = String.valueOf(dotGroovyLocation) + "/greclipse/global_dsld_support")).exists()) {
            try {
                location.mkdirs();
            }
            catch (SecurityException securityException) {}
        }
        if (location != null && location.exists()) {
            return location;
        }
        GroovyDSLCoreActivator.logWarning("Cannot create DSL support location at " + dotGroovyLocation + ". Location is read-only, or a security manager is preventing it.");
        return null;
    }

    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        this.javaProject = javaProject;
        DSLDClasspathContainer container = new DSLDClasspathContainer();
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        IClasspathContainer dsld;
        if (containerSuggestion instanceof DSLDClasspathContainer) {
            ((DSLDClasspathContainer)containerSuggestion).reset();
        }
        if (this.javaProject == null && (dsld = JavaCore.getClasspathContainer((IPath)GroovyClasspathContainer.CONTAINER_ID, (IJavaProject)this.javaProject)) instanceof DSLDClasspathContainer) {
            ((DSLDClasspathContainer)dsld).reset();
        }
    }

    private final class DSLDClasspathContainer
    implements IClasspathContainer {
        private IClasspathEntry[] entries;

        private DSLDClasspathContainer() {
        }

        public IPath getPath() {
            return GroovyDSLCoreActivator.CLASSPATH_CONTAINER_ID;
        }

        public int getKind() {
            return 1;
        }

        public String getDescription() {
            return "Groovy DSL Support";
        }

        public IClasspathEntry[] getClasspathEntries() {
            if (this.entries == null) {
                this.entries = this.calculateEntries();
            }
            return this.entries;
        }

        void reset() {
            this.entries = null;
        }

        protected IClasspathEntry[] calculateEntries() {
            URL folder;
            if (GroovyDSLCoreActivator.getDefault().getPreferenceStore().getBoolean("org.codehaus.groovy.eclipse.dsl.disabled")) {
                return NO_ENTRIES;
            }
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            if (globalDsldLocation != null && globalDsldLocation.exists()) {
                Path dsldPath = new Path(globalDsldLocation.getAbsolutePath());
                newEntries.add(JavaCore.newLibraryEntry((IPath)dsldPath, null, null, (boolean)false));
            }
            if ((folder = CompilerUtils.findDSLDFolder()) != null) {
                String file = folder.getFile();
                Assert.isTrue((boolean)new File(file).exists(), (String)("Plugin DSLD location does not exist: " + file));
                Path path = new Path(folder.getPath());
                newEntries.add(JavaCore.newLibraryEntry((IPath)path, null, null));
            }
            return newEntries.toArray(NO_ENTRIES);
        }
    }
}

