/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.classpath;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;

public class AutoAddContainerSupport
implements IResourceChangeListener {
    private final IPreferenceStore store = GroovyDSLCoreActivator.getDefault().getPreferenceStore();
    private final Set<String> alreadyAddedProjects = new HashSet<String>();

    public AutoAddContainerSupport() {
        String toIgnore = this.store.getString("org.codehaus.groovy.eclipse.dsl.projects.ignore");
        if (toIgnore != null) {
            String[] split;
            String[] stringArray = split = toIgnore.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String projName = stringArray[n2];
                if ((projName = projName.trim()).length() > 0 && ResourcesPlugin.getWorkspace().getRoot().getProject(projName).exists()) {
                    this.alreadyAddedProjects.add(projName);
                }
                ++n2;
            }
        }
    }

    private boolean shouldAddSupport() {
        return this.store.getBoolean("org.codehaus.groovy.eclipse.dsl.auto.add.support") || this.store.getBoolean("org.codehaus.groovy.eclipse.dsl.scripts.disabled");
    }

    private void addContainer(IJavaProject project) {
        String projectName = project.getElementName();
        AddDSLSupportJob runnable = new AddDSLSupportJob("Add DSL Support", projectName, project);
        runnable.setPriority(40);
        runnable.setSystem(true);
        runnable.setRule(this.getSetClassPathSchedulingRule(project));
        runnable.schedule();
    }

    private ISchedulingRule getSetClassPathSchedulingRule(IJavaProject project) {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        return new MultiRule(new ISchedulingRule[]{ruleFactory.modifyRule((IResource)project.getProject()), ruleFactory.modifyRule((IResource)JavaModelManager.getExternalManager().getExternalFoldersProject())});
    }

    public void addContainerToAll() {
        IProject[] allProjects;
        if (!this.shouldAddSupport()) {
            return;
        }
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!this.alreadyAddedProjects.contains(project.getName()) && GroovyNature.hasGroovyNature((IProject)project)) {
                this.addContainer(JavaCore.create((IProject)project));
            }
            ++n2;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.shouldAddSupport()) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            if (delta.getAffectedChildren().length > 0) {
                IResourceDelta[] children;
                IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta child = iResourceDeltaArray[n2];
                    if (child.getResource() instanceof IProject) {
                        if (child.getAffectedChildren().length == 0) {
                            projects.add((IProject)child.getResource());
                        } else {
                            IResourceDelta[] iResourceDeltaArray2 = child.getAffectedChildren();
                            int n3 = iResourceDeltaArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResourceDelta childDelta = iResourceDeltaArray2[n4];
                                IResource r = childDelta.getResource();
                                if (r instanceof IFile && r.getName().equals(".project")) {
                                    projects.add((IProject)child.getResource());
                                }
                                ++n4;
                            }
                        }
                    }
                    ++n2;
                }
            }
            for (IProject project : projects) {
                if (this.alreadyAddedProjects.contains(project.getName()) || !GroovyNature.hasGroovyNature((IProject)project)) continue;
                this.addContainer(JavaCore.create((IProject)project));
            }
        }
    }

    public void dispose() {
        StringBuilder sb = new StringBuilder();
        for (String projName : this.alreadyAddedProjects) {
            sb.append(projName);
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.replace(sb.length() - 1, sb.length(), "");
        }
        this.store.setValue("org.codehaus.groovy.eclipse.dsl.projects.ignore", sb.toString());
        if (this.store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.store).save();
            }
            catch (IOException e) {
                GroovyDSLCoreActivator.logException(e);
            }
        }
    }

    public void ignoreProject(IProject project) {
        this.alreadyAddedProjects.add(project.getName());
    }

    private final class AddDSLSupportJob
    extends Job {
        private final String projectName;
        private final IJavaProject project;

        private AddDSLSupportJob(String name, String projectName, IJavaProject project) {
            super(name);
            this.projectName = projectName;
            this.project = project;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                GroovyRuntime.addLibraryToClasspath((IJavaProject)this.project, (IPath)GroovyDSLCoreActivator.CLASSPATH_CONTAINER_ID, (boolean)false);
                AutoAddContainerSupport.this.alreadyAddedProjects.add(this.projectName);
                return Status.OK_STATUS;
            }
            catch (JavaModelException e) {
                GroovyDSLCoreActivator.logException("Problem auto-adding DSL support to " + this.projectName, e);
                return e.getStatus();
            }
        }
    }
}

